/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.template;

import i18n.B;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.module.input.template.RequestResultListener;

public class OnlineRequest
implements Task {
    private ApplicationContext context;
    private short serviceId;
    private String function;
    private Map<String, InputElement> data;
    private Locale locale;
    private RequestResultListener listener;

    public OnlineRequest(ApplicationContext context, short serviceId, String function, Map<String, InputElement> data, Locale locale, RequestResultListener listener) {
        this.serviceId = serviceId;
        this.context = context;
        this.function = function;
        this.data = data;
        this.locale = locale;
        this.listener = listener;
    }

    @Override
    public String getMessage() {
        return B.get((String)"Keeper.request.wait", (Locale)this.locale);
    }

    @Override
    public Object execute() {
        try {
            RequestData rd = new RequestData();
            Integer prov = AppDefaults.getInstance().getIntegerValue("Module.input.template.provider.id");
            if (prov != null) {
                rd.setIdProvider(Short.valueOf(prov.shortValue()));
            }
            rd.setIdService(this.serviceId);
            rd.setFunction(this.function);
            rd.setParamsIe(this.data);
            return this.context.getServerConnector().request(rd);
        }
        catch (Exception ex) {
            return ex;
        }
    }

    @Override
    public void onResult(Object result) {
        if (result instanceof Exception) {
            this.listener.onException((Exception)result);
        } else {
            Response resp = (Response)result;
            if (resp.getServerError() == 0 && resp.getServiceError() == 0) {
                if (this.listener != null) {
                    String res = "";
                    if (resp.getData() != null && ((Data)resp.getData()).getElements() != null && !((Data)resp.getData()).getElements().isEmpty()) {
                        res = ((InputElement)((Data)resp.getData()).getElements().get(0)).getValue();
                    }
                    this.listener.onResult(0, 0, (Data)resp.getData());
                }
            } else {
                this.listener.onResult(resp.getServerError(), resp.getServiceError(), null);
            }
        }
    }
}

