/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.telepay;

import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.validator.sequence.util.SequenceManager;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.processing.ObsoleteProcessingModule;

public class SequenceProcessingModule
extends ObsoleteProcessingModule {
    public static final String SEQ_NAME_KEY = "#sequence.name";
    public static final String SEQ_VALUE = "#sequence.value";

    public SequenceProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _process(Environment env) {
        try {
            if (!Session.getInstance().getPack().isCancel() && Session.getInstance().getPack().getPaymentType() == 0) {
                Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                String name = ((InputElement)payment.getData().get(SEQ_NAME_KEY)).getValue();
                String value = ((InputElement)payment.getData().get(SEQ_VALUE)).getValue();
                SequenceManager.getInstance().getSequence(name).setCurrent(Long.parseLong(value));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            ProblemNotifier.notifyProblem((String)("Error in SequenceProcessingModule: " + e.getMessage()));
        }
        super._process(env);
    }
}

