/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.repayment;

import java.util.Collections;
import java.util.Map;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.module.Paths;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.operation.Operation;
import ru.softlogic.parser.adv.ScenarioStore;

public class LastPaymentRepeatModule
extends BaseInputModule {
    private Restorable parent;
    private ScenarioStore scenarioStore = new ScenarioStore(Paths.getScenarioPath(), Paths.getAutoCompletePath());

    public LastPaymentRepeatModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.parent = parent;
        Operation lp = Session.getInstance().getLastPayment();
        Pack lastPack = Session.getInstance().getLastPack();
        if (lp == null || lastPack == null) {
            throw new ModuleInitException("\u041f\u0440\u043e\u0438\u0437\u043e\u0449\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
        }
        SumScreenDescription ssd = null;
        block2 : switch (lp.getService().getProviderType()) {
            case Mobile: {
                ssd = InitModuleHelper.createSumScreenDescription();
                String sumType = AppDefaults.getInstance().getStringValue("Provider.mobile.screen.sum", "sum");
                ssd.setType(sumType);
                break;
            }
            case UniversalProvider: {
                try {
                    Form form = FormHelper.parseForm(lastPack.getService().getCode(), environment.getLocale());
                    if (form == null) {
                        throw new DescriptionException("Can't get form");
                    }
                    ssd = (SumScreenDescription)form.getSumDescription();
                    this.log.info((Object)"Screen show");
                    break;
                }
                catch (Exception ex) {
                    throw new ModuleInitException(ex);
                }
            }
            case AdvancedProvider: {
                try {
                    Scenario scenario = this.scenarioStore.getScenario(lastPack.getService().getCode(), environment.getLocale());
                    for (String key : scenario.getScreens().keySet()) {
                        if (!(((AdvancedScreenDescription)scenario.getScreens().get(key)).getDescription() instanceof SumScreenDescription)) continue;
                        ssd = (SumScreenDescription)((AdvancedScreenDescription)scenario.getScreens().get(key)).getDescription();
                        break block2;
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new ModuleInitException(ex);
                }
            }
        }
        if (ssd == null) {
            ssd = new SumScreenDescription();
            ssd.setType("sum");
        }
        this._repeatPayment(environment, ssd, lastPack.getPayments(), lastPack.getOperationSum(), lastPack.getService(), lastPack.getCommission());
    }

    @Override
    protected void _restore() {
        if (this.parent != null) {
            this.parent.restore();
        } else {
            this.cancel(null);
        }
    }

    @Override
    public Map<String, Object> getDataContext() {
        return Collections.EMPTY_MAP;
    }
}

