/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntssnack;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import ru.softlogic.system.util.PathUtils;
import snack.machine.model.Snack;

public class SnackMachineUtil {
    private static Boolean SM_PRESENT;
    private static final String SM_FOLDER_NAME = "SNACK_MACHINE";
    private static final int N_ID = 0;
    private static final int N_COST = 5;
    private static final int N_NAME = 6;
    private static final int N_FULLNAME = 7;
    private static final int N_DESCRIPTION = 8;

    public static synchronized boolean isSnackMachinePresent() {
        if (SM_PRESENT != null) {
            return SM_PRESENT;
        }
        try {
            Class.forName("snack.machine.api.SnackMachineAPI");
            SM_PRESENT = true;
        }
        catch (ClassNotFoundException ex) {
            SM_PRESENT = false;
        }
        return SM_PRESENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Integer, Snack> getSnackConfigData() {
        HashMap<Integer, Snack> snacksData = new HashMap<Integer, Snack>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PathUtils.getAppHome() + File.separator + SM_FOLDER_NAME + File.separator + "products.cfg"), "cp1251"));
            String s = null;
            while ((s = br.readLine()) != null) {
                Snack snack = SnackMachineUtil.createSnackByCfgString(s);
                snacksData.put(snack.getId(), snack);
            }
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(br);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)br);
        return snacksData;
    }

    private static Snack createSnackByCfgString(String s) {
        String[] ss = s.split(",");
        int id = Integer.parseInt(ss[0].trim());
        double cost = Double.parseDouble(ss[5].trim());
        String snackName = ss[6].trim();
        String snackFullName = ss[7].trim();
        String description = ss[8].trim();
        return new Snack(id, cost, snackName, snackFullName, description);
    }

    public static List<Integer> getSnackPriority() {
        LinkedList<Integer> snacksPriority = new LinkedList<Integer>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PathUtils.getAppHome() + File.separator + SM_FOLDER_NAME + File.separator + "products_hot.cfg"), "cp1251"));
            String s = null;
            while ((s = br.readLine()) != null) {
                snacksPriority.add(Integer.parseInt(s));
            }
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(br);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)br);
        return snacksPriority;
    }
}

