/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.Drink;
import coffee.machine.model.Ingredient;
import coffee.machine.model.StatusCM;
import i18n.B;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.DigitalFilter;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFormatter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.module.input.ntscoffee.CoffeeHelper;
import ru.softlogic.module.input.ntscoffee.StatusActionListener;
import ru.softlogic.module.input.ntscoffee.StatusTask;
import ru.softlogic.module.present.BasePresentModule;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.reference.adv.Promo;

public class NtsCoffeePresentModule
extends BasePresentModule {
    public static final String DRINK_KEY = "#coffee.bonus.drink";
    private Environment env;
    private Logger log = Logger.getLogger((String)"pay");
    private LocalStatusListener statusListener = new LocalStatusListener();
    private Map<String, Drink> drinks;
    private Drink currentDrink;
    private int currentPromoId;
    private CoffeeContextStub coffeeContext;
    private CoffeeContextStub coffeeContext2;

    public NtsCoffeePresentModule(ApplicationContext context) {
        super(context);
        this.coffeeContext = new CoffeeContextStub(context);
        this.coffeeContext2 = new CoffeeContextStub(context, "coffee-final");
    }

    @Override
    protected void _takePresent(Environment environment) {
        this.env = environment;
        Drink d = null;
        Map data = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
        if (data.get(DRINK_KEY) instanceof Drink) {
            d = (Drink)data.get(DRINK_KEY);
        }
        if (Session.getInstance().getPack().getPaymentType() == 1 || Session.getInstance().getPack().getSumResult().getOut().isEmpty()) {
            this.log.info((Object)"Drink not found or no payment");
            this.toMenu();
        } else {
            Thread th = new Thread((Runnable)new LocalRunner(d), "NtsCoffeePresentThread");
            th.start();
        }
    }

    public static boolean isUsed(Promo promo, Sum sum, Date date, int serviceId, int code, Logger log) {
        if (promo.getBegin() == null || promo.getBegin().after(date)) {
            log.info((Object)"Cancel by promo start date");
            return false;
        }
        if (promo.getEnd() != null && promo.getEnd().before(date)) {
            log.info((Object)"Cancel by promo end date");
            return false;
        }
        if (promo.getPrizeType() != 1) {
            log.info((Object)"Cancel by promo prize");
            return false;
        }
        if (promo.getPaymentSum() > sum.getBasicSum()) {
            log.info((Object)"Cancel by promo sum");
            return false;
        }
        if (promo.getServices() != null && !promo.getServices().trim().isEmpty()) {
            String[] split = promo.getServices().split(",");
            boolean isIn = false;
            for (String service : split) {
                try {
                    if (Integer.parseInt(service.trim()) != serviceId) continue;
                    isIn = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isIn) {
                log.info((Object)"Cancel by promo service");
                return false;
            }
        } else if (promo.getCodes() != null && !promo.getCodes().trim().isEmpty()) {
            String[] split = promo.getCodes().split(",");
            boolean isIn = false;
            for (String c : split) {
                try {
                    if (Integer.parseInt(c.trim()) != code) continue;
                    isIn = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isIn) {
                log.info((Object)"Cancel by promo service code");
                return false;
            }
        }
        return true;
    }

    private void givePrize(Drink d, int promoId) {
        this.currentPromoId = promoId;
        if (d == null) {
            MediaPlayer.getInstance().play("free_drink.mp3");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.present.coffee.drink.want-drink", (Locale)this.env.getLocale()), 60, DC.cases((int)24, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (UserCase.Ok.equals((Object)userCase)) {
                        NtsCoffeePresentModule.this.log.info((Object)"User wants drink");
                        NtsCoffeePresentModule.this.coffeeContext.getTaskExecutor().execute(new StatusTask(NtsCoffeePresentModule.this.statusListener, B.get((String)"Module.input.coffee.request.wait", (Locale)NtsCoffeePresentModule.this.env.getLocale()), 2, NtsCoffeePresentModule.this.env.getLocale()));
                    } else {
                        NtsCoffeePresentModule.this.log.info((Object)"User don't wants drink");
                        NtsCoffeePresentModule.this.toMenu();
                    }
                }
            });
            this.context.showDialog((DialogInterface)dialog);
        } else {
            this.coffeeContext2.getTaskExecutor().execute(new LocalWait4FinishAction(new LocalGiveStatusListener(promoId, d), this.log, B.get((String)"Module.processing.coffee.making.wait", (Locale)this.env.getLocale()), d));
        }
    }

    private void showError(Object object) {
        String message = null;
        String eventMessage = null;
        if (object == null) {
            message = B.get((String)"Module.input.coffee.message.error", (Locale)this.env.getLocale());
            eventMessage = B.get((String)"Module.input.coffee.message.error", (Locale)Locale.ENGLISH);
        } else if (object instanceof Exception) {
            message = B.get((String)"Module.input.coffee.message.error.connection", (Locale)this.env.getLocale());
            eventMessage = B.get((String)"Module.input.coffee.message.error.connection", (Locale)Locale.ENGLISH);
        } else if (object instanceof StatusCM) {
            StatusCM scm = (StatusCM)object;
            message = B.get((String)("Module.input.coffee.message.error.status." + scm.getStatusError()), (Locale)this.env.getLocale(), (String)B.get((String)"Module.input.coffee.message.error.status", (Locale)this.env.getLocale()));
            eventMessage = B.get((String)("Module.input.coffee.message.error.status." + scm.getStatusError()), (Locale)Locale.ENGLISH, (String)B.get((String)"Module.input.coffee.message.error.status", (Locale)Locale.ENGLISH));
            this.log.info((Object)scm.toString());
        } else if (object instanceof String) {
            message = (String)object;
            eventMessage = (String)object;
        }
        ProblemNotifier.getDefaultNotifier().onProblem(eventMessage);
        this.log.info((Object)"Show  error screen");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, message, 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener((DialogListener)new LocalExitDialogListener());
        this.context.showDialog((DialogInterface)dialog);
    }

    private void toShowShelfProducts() {
        this.log.info((Object)"Show select products screen");
        if (this.drinks != null) {
            LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
            for (Drink d : this.drinks.values()) {
                SelectorItem si = new SelectorItem("" + d.getNameDrink(), "" + d.getId());
                HashMap<String, Drink> data = new HashMap<String, Drink>();
                data.put(DRINK_KEY, d);
                si.setCustomData(data);
                si.setData(new Data());
                items.add(si);
            }
            SelectorField sf = new SelectorField();
            sf.setStore((ItemsStore)new StaticStore(items));
            LinkedList<SelectorField> fields = new LinkedList<SelectorField>();
            fields.add(sf);
            ScreenDescription sd = new ScreenDescription("selector-coffee");
            sd.setTitle(B.get((String)"Module.input.coffee.products.title", (Locale)this.env.getLocale()));
            sd.setDecor("coffee-image");
            sd.setSequence(new FieldSequence(fields));
            sd.setButtons(InitModuleHelper.createKeyMap());
            sd.getButtons().remove("Prev");
            CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
            try {
                cs.init(sd, InitModuleHelper.buildScreenInit(this.env, new HashMap<String, Object>()));
                cs.setListener((ScreenListener)new LocalSelectProductListener());
                this.context.showScreen(new ContentScreenAdapter(cs));
                MediaPlayer.getInstance().play("select_drink.mp3");
            }
            catch (InitException ex) {
                this.log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showError(B.get((String)"Module.input.coffee.products.empty", (Locale)this.env.getLocale()));
        }
    }

    private void toShowProductPage(Drink drink) {
        if (drink != null) {
            Keyboard kbr = new Keyboard(KeyboardType.Digital);
            NumericField nf = new NumericField();
            nf.setId("sugar");
            nf.setTitle(B.get((String)"Module.input.coffee.sugar.amount", (Locale)this.env.getLocale()));
            nf.setKeyboard(kbr);
            nf.setFilter((Filter)new DigitalFilter(false));
            nf.setFormatter((Formatter)new VoidFormatter());
            nf.setDataFormatter((Formatter)new VoidFormatter());
            nf.setModificator((Modificator)new VoidModificator());
            nf.setValidator((Validator)new NumericRangeValidator(Collections.singletonList(new Range(0.0f, 6.0f))));
            nf.setUnitCount(1);
            nf.setDecimalCount(1);
            nf.setDefaultValue(drink.isNeedSugar() ? "2" : String.valueOf(drink.getSugar()));
            FieldSequence fs = new FieldSequence();
            fs.setFields(Arrays.asList(nf));
            ScreenDescription sd = new ScreenDescription();
            sd.setTitle(drink.getFullNameDrink());
            sd.setSequence(fs);
            HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
            buttons.put("Prev", new ButtonInit(null));
            buttons.put("Exit", new ButtonInit(null));
            buttons.put("Next", new ButtonInit(null));
            sd.setButtons(buttons);
            CommonScreen cs = CommonScreenStore.getScreen((String)"coffee-info");
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("#sugar", drink.isNeedSugar());
                hashMap.put("#drink-id", String.valueOf(drink.getId()));
                LinkedList<String> ings = new LinkedList<String>();
                if (drink.getIngredients() != null) {
                    for (Ingredient i : drink.getIngredients()) {
                        String[] name = CoffeeHelper.getIngredientName(i.getId());
                        if (name == null) continue;
                        ings.add(name[0] + ": " + i.getAmount() + " " + name[1]);
                    }
                }
                hashMap.put("#ingredients", ings);
                cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)true), InitModuleHelper.buildScreenInit(this.env, hashMap));
                cs.setListener((ScreenListener)new LocalSelectSugarListener(drink));
                this.context.showScreen(new ContentScreenAdapter(cs));
                MediaPlayer.getInstance().play("select_sugar.mp3");
            }
            catch (InitException ex) {
                this.log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showError(B.get((String)"Module.input.coffee.products.notset", (Locale)this.env.getLocale()));
        }
    }

    private void toMenu() {
        this.log.info((Object)"Goto main menu");
        this.context.toMainMenu();
        Logger.getLogger((String)"pay").info((Object)B.get((String)"Module.finish", (Locale)this.env.getLocale()));
    }

    private void toDiscardGift() {
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.present.coffee.drink.discard-gift", (Locale)this.env.getLocale()), 15, DC.cases((int)24, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                if (UserCase.Ok.equals((Object)userCase)) {
                    NtsCoffeePresentModule.this.log.info((Object)"User don't wants drink");
                    NtsCoffeePresentModule.this.toMenu();
                }
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    private class LocalSelectSugarListener
    extends ScreenAdapter {
        private Drink drink;

        private LocalSelectSugarListener(Drink drink) {
            this.drink = drink;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            NtsCoffeePresentModule.this.log.info((Object)("Selector action: action = " + action + ", data = " + data));
            NtsCoffeePresentModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action)) {
                NtsCoffeePresentModule.this.toShowShelfProducts();
            } else if (ActionType.isExit((String)action)) {
                NtsCoffeePresentModule.this.toDiscardGift();
            } else if (ActionType.isNext((String)action) && this.drink != null) {
                InputElement inputElement = (InputElement)data.get("sugar");
                int amountSugar = Integer.parseInt(inputElement.getValue());
                this.drink.setSugar(amountSugar);
                NtsCoffeePresentModule.this.coffeeContext2.getTaskExecutor().execute(new LocalWait4FinishAction(new LocalGiveStatusListener(NtsCoffeePresentModule.this.currentPromoId, NtsCoffeePresentModule.this.currentDrink), NtsCoffeePresentModule.this.log, B.get((String)"Module.processing.coffee.making.wait", (Locale)NtsCoffeePresentModule.this.env.getLocale()), NtsCoffeePresentModule.this.currentDrink));
            }
            ModuleHelper.invoke(cancelListener);
        }
    }

    private class LocalSelectProductListener
    extends ScreenAdapter {
        private LocalSelectProductListener() {
        }

        public final void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            NtsCoffeePresentModule.this.log.info((Object)("Selector action: action = " + action));
            NtsCoffeePresentModule.this.log.info((Object)("Data: " + data));
            if (!ActionType.isPrev((String)action)) {
                if (ActionType.isExit((String)action)) {
                    NtsCoffeePresentModule.this.toDiscardGift();
                } else if (ActionType.isNext((String)action)) {
                    Drink drink = (Drink)data.get(NtsCoffeePresentModule.DRINK_KEY);
                    NtsCoffeePresentModule.this.currentDrink = drink;
                    if (drink.isAvailable()) {
                        NtsCoffeePresentModule.this.toShowProductPage(drink);
                    } else {
                        NtsCoffeePresentModule.this.log.info((Object)"Show warning screen.");
                        NtsCoffeePresentModule.this.log.info((Object)("" + drink.getNameDrink() + " is not available for prepare"));
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.drink.available.false", (Locale)NtsCoffeePresentModule.this.env.getLocale()), 3, DC.cases((int)8, (Locale)NtsCoffeePresentModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                ModuleHelper.invoke(cancelListener);
                            }
                        });
                        NtsCoffeePresentModule.this.context.showDialog((DialogInterface)dialog);
                    }
                }
            }
            ModuleHelper.invoke(cancelListener);
        }
    }

    private class GetDrinksTask
    implements Task {
        @Override
        public Object execute() {
            Serializable object;
            try {
                object = CoffeeMachine.getDefaultInstance().getDrinks();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NtsCoffeePresentModule.this.log.error((Object)ex, (Throwable)ex);
                object = ex;
            }
            return object;
        }

        @Override
        public void onResult(Object object) {
            NtsCoffeePresentModule.this.log.info((Object)("Recived answer: " + object));
            if (object != null) {
                if (object instanceof Exception) {
                    NtsCoffeePresentModule.this.showError(object);
                } else if (object instanceof Map) {
                    NtsCoffeePresentModule.this.drinks = (Map)object;
                    NtsCoffeePresentModule.this.toShowShelfProducts();
                }
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Module.input.coffee.products.request.wait", (Locale)NtsCoffeePresentModule.this.env.getLocale());
        }
    }

    private class LocalStatusListener
    implements StatusActionListener {
        private LocalStatusListener() {
        }

        @Override
        public void onSuccess() {
            NtsCoffeePresentModule.this.coffeeContext.getTaskExecutor().execute(new GetDrinksTask());
        }

        @Override
        public void onError(Object object) {
            NtsCoffeePresentModule.this.showError(object);
        }
    }

    private class LocalGiveStatusListener
    implements StatusActionListener {
        private int promoId;
        private Drink d;

        private LocalGiveStatusListener(int promoId, Drink d) {
            this.promoId = promoId;
            this.d = d;
        }

        @Override
        public void onSuccess() {
            CoffeeHelper.onBonusDrink(NtsCoffeePresentModule.this.context, (Payment)Session.getInstance().getPack().getPayments().get(0), this.d.getNameDrink(), this.d.getSugar(), this.promoId);
            AppEnvironment.getInstance().addAdvEvent(this.promoId, AdvStatisticType.Present);
            MediaPlayer.getInstance().play("done_thanks.mp3");
            DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Custom, B.get((String)"Module.present.coffee.take", (Locale)NtsCoffeePresentModule.this.env.getLocale()), 15, DC.cases((int)1, (Locale)NtsCoffeePresentModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener((DialogListener)new LocalExitDialogListener());
            NtsCoffeePresentModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public void onError(Object object) {
            DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Custom, B.get((String)"Module.present.coffee.take.error", (Locale)NtsCoffeePresentModule.this.env.getLocale()), 15, DC.cases((int)1, (Locale)NtsCoffeePresentModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener((DialogListener)new LocalExitDialogListener());
            NtsCoffeePresentModule.this.context.showDialog((DialogInterface)dialog);
        }
    }

    private class LocalExitDialogListener
    implements DialogListener {
        public void dialogClosed(UserCase userCase) {
            NtsCoffeePresentModule.this.toMenu();
        }
    }

    private class LocalCustomExitDialogListener
    implements CustomDialogListener {
        private LocalCustomExitDialogListener() {
        }

        public void onClose(Object type) {
            NtsCoffeePresentModule.this.toMenu();
        }
    }

    private class LocalRunner
    implements Runnable {
        Drink drink;

        public LocalRunner(Drink drink) {
            this.drink = drink;
        }

        @Override
        public void run() {
            if (Session.getInstance().getPack().getSumResult() != null && !Session.getInstance().getPack().getSumResult().getOut().isEmpty()) {
                Date date = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getDate();
                if (date == null) {
                    date = Session.getInstance().getPack().getDate();
                }
                if (date == null) {
                    date = new Date();
                }
                NtsCoffeePresentModule.this.log.info((Object)("Promos: " + Arrays.toString(NtsCoffeePresentModule.this.env.getPromos())));
                Sum sum = Session.getInstance().getPack().getSumResult().getOutProv() == null || Session.getInstance().getPack().getSumResult().getOutProv().isEmpty() ? Session.getInstance().getPack().getSumResult().getOut() : Session.getInstance().getPack().getSumResult().getOutProv();
                NtsCoffeePresentModule.this.log.info((Object)("Pack sum: " + sum));
                boolean noPrize = true;
                for (Promo promo : NtsCoffeePresentModule.this.env.getPromos()) {
                    if (!NtsCoffeePresentModule.isUsed(promo, sum, date, Session.getInstance().getPack().getService().getId(), Session.getInstance().getPack().getService().getCode(), NtsCoffeePresentModule.this.log)) continue;
                    NtsCoffeePresentModule.this.givePrize(this.drink, promo.getId());
                    noPrize = false;
                    break;
                }
                if (this.drink != null && noPrize) {
                    DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Custom, B.get((String)"Module.present.coffee.no-present", (Locale)NtsCoffeePresentModule.this.env.getLocale()), 15, DC.cases((int)1, (Locale)NtsCoffeePresentModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new LocalExitDialogListener());
                    NtsCoffeePresentModule.this.context.showDialog((DialogInterface)dialog);
                } else if (noPrize) {
                    NtsCoffeePresentModule.this.toMenu();
                }
            }
        }
    }

    private class LocalWait4FinishAction
    extends StatusTask {
        private Drink drink;

        public LocalWait4FinishAction(StatusActionListener actionListener, Logger log, String message, Drink drink) {
            super(actionListener, message, null, NtsCoffeePresentModule.this.env.getLocale());
            this.drink = drink;
        }

        @Override
        public Object execute() {
            Exception object;
            try {
                MediaPlayer.getInstance().play("preparing_drink.mp3");
                CoffeeMachine.getDefaultInstance().prepareDrink(this.drink);
                object = CoffeeMachine.getDefaultInstance().getStatus();
            }
            catch (Exception ex) {
                object = ex;
            }
            return object;
        }
    }
}

