/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.Drink;
import i18n.B;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.module.input.ntscoffee.CoffeeHelper;
import ru.softlogic.module.input.ntscoffee.StatusActionListener;
import ru.softlogic.module.input.ntscoffee.StatusTask;

public class MakeFastDrinkScreenListener
extends ScreenAdapter {
    private Restorable parent;
    private ApplicationContext context;
    private Locale locale;
    private String userName;
    private String userLogin;
    private Logger log;
    private CoffeeContextStub coffeeContext;

    public MakeFastDrinkScreenListener(Restorable parent, ApplicationContext context, Locale locale, String userName, String userLogin) {
        this.parent = parent;
        this.context = context;
        this.locale = locale;
        this.userName = userName;
        this.userLogin = userLogin;
        this.coffeeContext = new CoffeeContextStub(context, "coffee-final");
        this.log = Logger.getLogger((String)"pay");
    }

    public void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
        this.log.info((Object)("Data: " + data));
        if (ActionType.isNext((String)action)) {
            final Drink d = (Drink)data.get("#coffee.drink");
            if (!d.isAvailable()) {
                this.log.info((Object)"Show warning screen.");
                this.log.info((Object)("" + d.getNameDrink() + " is not available for prepare"));
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.drink.available.false", (Locale)this.locale), 3, DC.cases((int)8, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        ModuleHelper.invoke(cancelListener);
                    }
                });
                this.context.showDialog((DialogInterface)dialog);
            } else {
                final int sugar = Integer.parseInt(((InputElement)data.get("sugar")).getValue());
                d.setSugar(sugar);
                StatusActionListener actionListener = new StatusActionListener(){

                    @Override
                    public void onSuccess() {
                        CoffeeHelper.onServiceDrink(MakeFastDrinkScreenListener.this.context, MakeFastDrinkScreenListener.this.userName, MakeFastDrinkScreenListener.this.userLogin, d.getNameDrink(), sugar);
                        MediaPlayer.getInstance().play("done_thanks.mp3");
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.message.make-drink-success", (Locale)MakeFastDrinkScreenListener.this.locale), 10, DC.cases((int)8), UserCase.Ok);
                        dialog.addListener((DialogListener)new LocalDialogListener());
                        MakeFastDrinkScreenListener.this.context.showDialog((DialogInterface)dialog);
                    }

                    @Override
                    public void onError(Object object) {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.message.make-drink-error", (Locale)MakeFastDrinkScreenListener.this.locale), 10, DC.cases((int)8), UserCase.Ok);
                        dialog.addListener((DialogListener)new LocalDialogListener());
                        MakeFastDrinkScreenListener.this.context.showDialog((DialogInterface)dialog);
                    }
                };
                this.coffeeContext.getTaskExecutor().execute(new LocalWait4FinishAction(actionListener, Logger.getLogger((String)"pay"), B.get((String)"Module.processing.coffee.making.wait", (Locale)this.locale), d));
            }
        } else if (ActionType.isPrev((String)action) || ActionType.isExit((String)action)) {
            this.parent.restore();
        } else {
            ModuleHelper.invoke(cancelListener);
        }
    }

    private class LocalDialogListener
    implements DialogListener {
        private LocalDialogListener() {
        }

        public void dialogClosed(UserCase userCase) {
            MakeFastDrinkScreenListener.this.parent.restore();
        }
    }

    private class LocalWait4FinishAction
    extends StatusTask {
        private Drink drink;

        public LocalWait4FinishAction(StatusActionListener actionListener, Logger log, String message, Drink drink) {
            super(actionListener, message, null, MakeFastDrinkScreenListener.this.locale);
            this.drink = drink;
        }

        @Override
        public Object execute() {
            Exception object;
            try {
                MediaPlayer.getInstance().play("preparing_drink.mp3");
                CoffeeMachine.getDefaultInstance().prepareDrink(this.drink);
                object = CoffeeMachine.getDefaultInstance().getStatus();
            }
            catch (Exception ex) {
                object = ex;
            }
            return object;
        }
    }
}

