/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import i18n.B;
import java.util.Collections;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.Menu;

public class EntryCashManagerSwitcher
implements KeeperObserver,
ModuleTypeListener {
    private Logger log = Logger.getLogger((String)"pay");
    private int lastModule;
    private CoffeeContextStub coffeeContext;

    public EntryCashManagerSwitcher(ApplicationContext context) {
        this.coffeeContext = new CoffeeContextStub(context);
    }

    public void update(Keeper keeper, Sum sum) {
        if (sum != null && !sum.isEmpty()) {
            this.log.error((Object)("Entry accept bill " + sum));
            ProblemNotifier.notifyProblem((String)("Entry accept bill " + sum));
        }
    }

    public void notifyNoMoreNeed() {
        this.log.info((Object)"Show no need money dialog.");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.entry.cashmanager.no-need-more"), AppDefaults.getInstance().getIntegerValue("Entry.cashmanager.no-need-more.timeout", 10).intValue(), DC.cases((int)1), UserCase.Ok);
        this.coffeeContext.showDialog((DialogInterface)dialog);
        this.log.info((Object)"Play money_reject.mp3");
        MediaPlayer.getInstance().play("money_reject.mp3");
    }

    @Override
    public void onChange(int moduleType) {
        String layer = null;
        try {
            Menu menu = ReferenceManager.getInstance().getMenu();
            if (menu != null) {
                this.log.debug((Object)("root.size=" + menu.getTypes().length));
                layer = menu.getTypes() != null && menu.getTypes().length == 1 ? menu.getTypes()[0].getScreenType().getCode() : menu.getScreenType().getCode();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("coffeemat".equals(layer) || "coffeemat2".equals(layer) || "coffeemat-l2r6".equals(layer)) {
            this.log.info((Object)("Module type " + moduleType));
            if (moduleType == 2 && this.lastModule == 1) {
                this.log.info((Object)"Disable CM");
                CashManager.getDefaultInstance().disable();
            } else if (moduleType == 1) {
                this.log.info((Object)"Enable CM");
                CashManager.getDefaultInstance().enable(null, new Sum(15000), Collections.EMPTY_SET, Collections.EMPTY_SET, (KeeperObserver)this, 65535, true);
            }
            this.lastModule = moduleType;
        }
    }
}

