/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.model.Drink;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.Payment;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.input.ntscoffee.CoffeeMachineUtil;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.operation.CashlessData;
import ru.softlogic.operation.Operation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.system.util.PathUtils;

public class CoffeeHelper {
    private static Properties ingredientsNames;
    private static Logger log;

    static ScreenDescription getFullnessScreenDescription(Map<Integer, Double> fullness, Locale locale) throws ParseException {
        SelectorField sf;
        Form f = FormHelper.parseCustom(new File(PathUtils.getAppHome() + "/resources/utility/coffee-fullness.xml"), locale);
        if (f.getScreenSequence().getScreens().size() != 1) {
            throw new ParseException("Wrong number of screens");
        }
        ScreenDescription sd = (ScreenDescription)f.getScreenSequence().getScreens().get(0);
        if (!sd.getSequence().getFields().isEmpty() && sd.getSequence().getFields().get(0) instanceof SelectorField && (sf = (SelectorField)sd.getSequence().getFields().get(0)).getItems() != null) {
            for (SelectorItem si : sf.getItems()) {
                try {
                    Double fln = fullness.get(Integer.parseInt(si.getValue()) - 1);
                    int range = Integer.parseInt(si.getImage());
                    if (fln == null) {
                        fln = 0.0;
                    }
                    si.setTitle(MessageFormat.format(si.getTitle(), fln / (double)range));
                    LinkedList<InputElement> dt = new LinkedList<InputElement>();
                    dt.add(new InputElement("curr-fullness", null, String.valueOf(fln)));
                    dt.add(new InputElement("curr-range", null, String.valueOf(range)));
                    si.setData(new Data(dt));
                }
                catch (Exception exception) {}
            }
        }
        return sd;
    }

    static ScreenDescription getCoffeeMakeScreenDescription(Map<String, Drink> drinks, Locale locale) throws ParseException {
        Form f = FormHelper.parseCustom(new File(PathUtils.getAppHome() + "/resources/utility/coffee-make-drink.xml"), locale);
        if (f.getScreenSequence().getScreens().size() != 1) {
            throw new ParseException("Wrong number of screens");
        }
        ScreenDescription sd = (ScreenDescription)f.getScreenSequence().getScreens().get(0);
        if (!sd.getSequence().getFields().isEmpty() && sd.getSequence().getFields().get(0) instanceof SelectorField) {
            SelectorField sf = (SelectorField)sd.getSequence().getFields().get(0);
            LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
            for (Drink d : drinks.values()) {
                SelectorItem si = new SelectorItem("" + d.getNameDrink(), "" + d.getId());
                HashMap<String, Drink> data = new HashMap<String, Drink>();
                data.put("#coffee.drink", d);
                si.setCustomData(data);
                si.setData(new Data());
                items.add(si);
            }
            sf.setStore((ItemsStore)new StaticStore(items));
        }
        return sd;
    }

    public static synchronized String[] getIngredientName(int id) {
        String name;
        if (ingredientsNames == null) {
            ingredientsNames = CoffeeMachineUtil.getIngredients();
        }
        if ((name = ingredientsNames.getProperty("ing." + id)) != null) {
            String[] split = name.split("\\|");
            if (split.length != 2) {
                return null;
            }
            return split;
        }
        return null;
    }

    public static synchronized String getBoxName(int id) {
        if (ingredientsNames == null) {
            ingredientsNames = CoffeeMachineUtil.getIngredients();
        }
        return ingredientsNames.getProperty("box." + id);
    }

    static void onServiceDrink(ApplicationContext context, String userName, String userLogin, String drink, int sugar) {
        Integer sid = AppDefaults.getInstance().getIntegerValue("Coffee.serviceDrink.sid");
        if (sid != null) {
            Dealer d = null;
            Point p = null;
            PaymentSystem ps = null;
            try {
                d = ReferenceManager.getInstance().getDealer();
                p = ReferenceManager.getInstance().getPoint();
                ps = ReferenceManager.getInstance().getPaymentSystem();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Operation operation = new Operation();
            operation.setFeHash(PaymentHelper.getFeHash());
            operation.setService(new Service(sid.intValue()));
            operation.setCommission(new Commission(1));
            operation.setIdOperation(SequenceManager.getValueQuietly((String)"service-coffee-id") % 32000);
            operation.setCheckNumber(new Random().nextInt(32000));
            operation.setDate(new Date());
            operation.setDealer(d);
            operation.setPoint(p);
            operation.setPaymentSystem(ps);
            operation.setServiceType(new ServiceType());
            operation.setPaymentTool(0);
            operation.setCashlessData(new CashlessData());
            operation.setPaybackType(0);
            operation.setSumResult(new SumResult(new Sum(), new Sum(200), new Sum(200), new Sum(), new Sum(), new Sum(), null, null));
            operation.setLocale(Locale.getDefault());
            Keeper keeper = new Keeper();
            keeper.addPayback(new Sum(200));
            operation.setKeeper(keeper);
            operation.getForm().put("id1", drink);
            operation.getViews().put("id1", drink);
            operation.getTitles().put("id1", "Drink");
            operation.getInputElements().put("id1", new InputElement("id1", "Drink", drink, drink, 0));
            operation.getForm().put("id2", userLogin);
            operation.getViews().put("id2", userLogin);
            operation.getTitles().put("id2", "Login");
            operation.getInputElements().put("id2", new InputElement("id2", "Login", userLogin, userLogin, 0));
            operation.getForm().put("user", userName);
            operation.getViews().put("user", userName);
            operation.getTitles().put("user", "User");
            operation.getInputElements().put("user", new InputElement("user", "User", userName, userName, 0));
            operation.getForm().put("sugar", "" + sugar);
            operation.getViews().put("sugar", "" + sugar);
            operation.getTitles().put("sugar", "Sugar");
            operation.getInputElements().put("sugar", new InputElement("sugar", "Sugar", "" + sugar, "" + sugar, 0));
            operation.setChange(new Keeper());
            try {
                log.info((Object)("Result of service drink process: " + context.getServerConnector().process(operation)));
            }
            catch (ConnectorException ex) {
                log.error((Object)"Error on service drink process", (Throwable)ex);
            }
        } else {
            log.info((Object)"Coffee.serviceDrink.sid not set");
        }
    }

    static void onBonusDrink(ApplicationContext context, Payment pm, String drink, int sugar, int promoId) {
        Integer sid = AppDefaults.getInstance().getIntegerValue("Coffee.bonus.sid");
        if (sid != null) {
            Dealer d = null;
            Point p = null;
            PaymentSystem ps = null;
            try {
                d = ReferenceManager.getInstance().getDealer();
                p = ReferenceManager.getInstance().getPoint();
                ps = ReferenceManager.getInstance().getPaymentSystem();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Operation operation = new Operation();
            operation.setFeHash(PaymentHelper.getFeHash());
            operation.setService(new Service(sid.intValue()));
            operation.setCommission(new Commission(1));
            operation.setIdOperation(SequenceManager.getValueQuietly((String)"service-coffee-id") % 32000);
            operation.setCheckNumber(new Random().nextInt(32000));
            operation.setDate(new Date());
            operation.setDealer(d);
            operation.setPoint(p);
            operation.setPaymentSystem(ps);
            operation.setServiceType(new ServiceType());
            operation.setPaymentTool(0);
            operation.setCashlessData(new CashlessData());
            operation.setPaybackType(0);
            operation.setSumResult(new SumResult(new Sum(), new Sum(200), new Sum(200), new Sum(), new Sum(), new Sum(), null, null));
            operation.setLocale(Locale.getDefault());
            Keeper keeper = new Keeper();
            keeper.addPayback(new Sum(200));
            operation.setKeeper(keeper);
            operation.getForm().put("id1", drink);
            operation.getViews().put("id1", drink);
            operation.getTitles().put("id1", "Drink");
            operation.getInputElements().put("id1", new InputElement("id1", "Drink", drink, drink, 0));
            InputElement id1 = (InputElement)pm.getData().get("id1");
            if (id1 != null) {
                operation.getForm().put("id2", id1.getValue());
                operation.getViews().put("id2", id1.getValueTitle());
                operation.getTitles().put("id2", id1.getKeyTitle());
                operation.getInputElements().put("id2", new InputElement("id2", id1.getKeyTitle(), id1.getValue(), id1.getValueTitle(), 0));
            }
            operation.getForm().put("sugar", "" + sugar);
            operation.getViews().put("sugar", "" + sugar);
            operation.getTitles().put("sugar", "Sugar");
            operation.getInputElements().put("sugar", new InputElement("sugar", "Sugar", "" + sugar, "" + sugar, 0));
            operation.getForm().put("promoid", "" + promoId);
            operation.getViews().put("promoid", "" + promoId);
            operation.getTitles().put("promoid", "Promo Id");
            operation.getInputElements().put("promoid", new InputElement("promoid", "Promo Id", "" + promoId, "" + promoId, 0));
            operation.setChange(new Keeper());
            try {
                log.info((Object)("Result of service drink process: " + context.getServerConnector().process(operation)));
            }
            catch (ConnectorException ex) {
                log.error((Object)"Error on service drink process", (Throwable)ex);
            }
        } else {
            log.info((Object)"Coffee.bonus.sid not set");
        }
    }

    static {
        log = Logger.getLogger((String)"pay");
    }
}

