/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.mobile;

import i18n.B;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui.utils.menu.MobileSearchVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.RegexFormatter;
import ru.softlogic.input.model.field.text.RegexValidator;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.ExtraButton;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.mobile.CityNumberValidator;
import ru.softlogic.module.input.mobile.FederalNumberValidator;
import ru.softlogic.module.input.mobile.LocalCapacityElement;
import ru.softlogic.module.input.mobile.LocalNumberExtractor;
import ru.softlogic.module.input.mobile.MobileFilter;
import ru.softlogic.provider.ForceVerifyListener;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.provider.ProviderHelperListener;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.srv.api.verify.ArgumentType;
import ru.softlogic.srv.api.verify.VerifyDataItem;
import ru.softlogic.srv.api.verify.VerifyResult;
import ru.softlogic.srv.api.verify.VerifyResultType;

public class MobileInputModule
extends BaseInputModule {
    private final ProviderHelper helper;
    private final LocalHelperListener helperListener;
    private final CityNumberValidator cnv = new CityNumberValidator();
    private final ComplexScreenListener screenListener;
    private MenuItem menuItem;
    private MenuItem realItem;
    private Service currentService;
    private Commission currentCommission;
    private Locale locale;
    private String cityCode;
    private LocalCapacityElement[] lces;
    private String currentNumber;
    private String currentView;
    private boolean verifyUnknownNumbers;
    private String actionOnError;
    private String confirmChange;
    private Environment environment;
    private Restorable parent;
    private Map<String, Object> data;
    private ScreenDescription mobileScreenDescription;
    private CommonScreen currentScreen;
    private ScreenDescription currentSd;
    private ScreenListener currentListener;
    private final String inputType;
    private final String confirmType;
    private final String sumType;

    public MobileInputModule(ApplicationContext context) {
        super(context);
        this.helper = new ProviderHelper(context);
        this.helperListener = new LocalHelperListener();
        this.screenListener = new LocalScreenListener(context);
        this.inputType = AppDefaults.getInstance().getStringValue("Provider.mobile.screen.number", "digital");
        this.confirmType = AppDefaults.getInstance().getStringValue("Provider.mobile.screen.confirm", "confirm");
        this.sumType = AppDefaults.getInstance().getStringValue("Provider.mobile.screen.sum", "sum");
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        String localMask;
        this.environment = environment;
        this.parent = parent;
        this.locale = environment.getLocale();
        this.menuItem = environment.getMenuItem();
        this.verifyUnknownNumbers = (this.menuItem.getFlags() & 2) > 0;
        this.currentCommission = this.menuItem.getCommission();
        this.currentService = this.menuItem.getService();
        this.currentNumber = null;
        this.currentView = null;
        this.cityCode = null;
        this.data = new HashMap<String, Object>();
        this.screenListener.setEnvironment(environment);
        ModuleHelper.fillStore(environment.getInitData(), this.data);
        if (environment.getPoint() != null) {
            this.cityCode = environment.getPoint().getCityCode();
            this.log.info((Object)("City code: " + environment.getPoint().getCityCode()));
        }
        this.lces = LocalNumberExtractor.getElements(this.cityCode);
        this.cnv.setLces(this.lces);
        Keyboard kbr = new Keyboard(KeyboardType.Digital);
        TextField tf = new TextField();
        tf.setId("id1");
        tf.setTitle(B.get((String)"Provider.mobile.phone.number", (Locale)this.locale));
        tf.setMaxLength(10);
        tf.setKeyboard(kbr);
        tf.setExampleValue(AppDefaults.getInstance().getStringValue("Provider.mobile.input.field.example", "8( ) - -"));
        if ("ru".equals(AppDefaults.getInstance().getStringValue("Provider.mobile.input.filter.country", "ru"))) {
            tf.setFilter((Filter)new MobileFilter());
        } else {
            tf.setFilter((Filter)new VoidFilter());
        }
        tf.setHelp(B.get((String)"Provider.mobile.phone.help", (Locale)this.locale));
        RegexFormatter formatter = new RegexFormatter();
        formatter.setDefaultMask(AppDefaults.getInstance().getStringValue("Provider.mobile.input.mask", "8(***)***-****"));
        formatter.setPadding(Character.valueOf(' '));
        HashMap<String, String> fm = new HashMap<String, String>();
        formatter.setMasks(fm);
        tf.setFormatter((Formatter)formatter);
        LinkedList<String> vr = new LinkedList<String>();
        RegexValidator validator = new RegexValidator(vr, null);
        vr.add("^\\d{10}");
        tf.setValidator((Validator)validator);
        if (this.cityCode != null && !this.cityCode.isEmpty() && (localMask = LocalNumberExtractor.getLocalMask(this.cityCode)) != null && !localMask.isEmpty() && this.lces != null) {
            for (LocalCapacityElement lce : this.lces) {
                vr.add(lce.getReplaceRegex());
                fm.put(lce.getValidateRegex(), localMask);
            }
        }
        FieldSequence fs = new FieldSequence();
        fs.setFields(Arrays.asList(tf));
        ScreenDescription sd = new ScreenDescription();
        sd.setTitle(B.get((String)"Provider.mobile.phone.screen.title", (Locale)this.locale));
        sd.setDecor(B.get((String)"Provider.mobile.phone.screen.decor", (Locale)this.locale));
        sd.setSequence(fs);
        sd.setId("input");
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Commission", new ButtonInit(null));
        buttons.put("Prev", new ButtonInit(null));
        buttons.put("Exit", new ButtonInit(null));
        buttons.put("Next", new ButtonInit(null));
        sd.setButtons(buttons);
        this.mobileScreenDescription = sd;
        try {
            this.toShowNumberPanel();
        }
        catch (InitException ex) {
            throw new ModuleInitException(ex);
        }
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        this.environment.setMenuItem(this.menuItem);
        try {
            this.initCurrentScreen(this.currentScreen, this.currentSd, InitModuleHelper.buildScreenInit(this.environment, this.data), this.currentListener);
        }
        catch (InitException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        this.context.showScreen(new ContentScreenAdapterKbr(this.currentScreen));
    }

    @Override
    public Map<String, Object> getDataContext() {
        return this.data;
    }

    protected void initCurrentScreen(CommonScreen cs, ScreenDescription sd, ScreenInit si, ScreenListener listener) throws InitException {
        this.currentSd = sd;
        this.currentListener = listener;
        cs.init(sd, si);
        cs.setListener(listener);
    }

    private void toShowNumberPanel() throws InitException {
        CommonScreen cs;
        MediaPlayer.getInstance().play("input_mobile.mp3");
        this.log.debug((Object)"toShowNumberPanel");
        this.currentScreen = cs = CommonScreenStore.getScreen((String)this.inputType);
        Map<Integer, ExtraButton> extraButtons = FederalNumberValidator.getInstance().getExtraButtons();
        if (extraButtons == null) {
            this.mobileScreenDescription.setExtraButton(null);
        } else {
            this.mobileScreenDescription.setExtraButton(extraButtons.get(this.currentService.getCode()));
        }
        this.initCurrentScreen(cs, ScreenHelper.processBack((ScreenDescription)this.mobileScreenDescription, (boolean)true, (this.parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(this.environment, this.data), (ScreenListener)this.screenListener);
        this.context.showScreen(new ContentScreenAdapterKbr(cs));
    }

    private void toAskAboutChange(int serviceId) {
        this.log.debug((Object)"toAskAboutChange");
        MobileSearchVisitor mbcv = new MobileSearchVisitor(serviceId);
        MenuUtils.processMenu((MenuVisitor)mbcv);
        this.realItem = mbcv.getMenuItem();
        this.log.info((Object)("\u041f\u0443\u043d\u043a\u0442 \u0434\u043b\u044f \u0437\u0430\u043c\u0435\u043d\u044b: " + this.realItem));
        if (AppDefaults.getInstance().getBooleanProperty("provider.mobile.operator.ask-change", true)) {
            this.log.info((Object)"\u0417\u0430\u0434\u0430\u0435\u043c \u0432\u043e\u043f\u0440\u043e\u0441 \u043e \u0441\u043c\u0435\u043d\u0435 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Provider.mobile.operator.change", (Locale)this.locale), this.menuItem.getService().getName(), this.currentView, this.realItem.getService().getName()), 20, DC.cases((int)14), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    MobileInputModule.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                    if (userCase == UserCase.Ok) {
                        MobileInputModule.this.currentService = MobileInputModule.this.realItem.getService();
                        MobileInputModule.this.currentCommission = MobileInputModule.this.realItem.getCommission();
                        Date now = new Date();
                        MobileInputModule.this.environment.setAllowedNotes(PaymentHelper.getAllowedUnits(MobileInputModule.this.realItem, 3, now));
                        MobileInputModule.this.environment.setAllowedCoins(PaymentHelper.getAllowedUnits(MobileInputModule.this.realItem, 4, now));
                    }
                    MobileInputModule.this.toConfirm();
                }
            });
            this.context.showDialog((DialogInterface)dialog);
        } else {
            this.log.info((Object)"\u041c\u0435\u043d\u044f\u0435\u043c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u0432\u0430\u044f \u0432\u043e\u043f\u0440\u043e\u0441");
            this.currentService = this.realItem.getService();
            this.currentCommission = this.realItem.getCommission();
            Date now = new Date();
            this.environment.setAllowedNotes(PaymentHelper.getAllowedUnits(this.realItem, 3, now));
            this.environment.setAllowedCoins(PaymentHelper.getAllowedUnits(this.realItem, 4, now));
            this.toConfirm();
        }
    }

    private void toConfirm() {
        this.log.debug((Object)("toConfirm, is-show: " + this.currentService.isShowConfirm()));
        CommonScreen cs = CommonScreenStore.getScreen((String)this.confirmType);
        if (cs != null && this.currentService.isUseInAdSending() && !AppDefaults.getInstance().isSuppressImplictConfirm()) {
            this.log.debug((Object)"Show confirm SMS screen");
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            this.currentScreen = cs;
            sd.setId("confirm");
            sd.setTitle(B.get((String)"Provider.mobile.confirmsms.title", (Locale)this.locale));
            sd.setDecor("single");
            CheckBoxField sf = new CheckBoxField();
            sf.setId("sms-agree");
            sf.setTitle(B.get((String)"Provider.mobile.confirmsms.field.title", (Locale)this.locale));
            sf.setValue("1");
            sf.setText(B.get((String)"Provider.mobile.confirmsms.field.value-title", (Locale)this.locale));
            ArrayList<CheckBoxField> fields = new ArrayList<CheckBoxField>();
            fields.add(sf);
            sd.setSequence(new FieldSequence(fields));
            this.data.put(sf.getId(), new InputElement(sf.getId(), sf.getTitle(), "1"));
            try {
                this.initCurrentScreen(cs, ScreenHelper.processBack((ScreenDescription)sd, (boolean)false, (this.parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(this.environment, this.data, this.currentService, this.currentCommission), (ScreenListener)new LocalConfirmListener());
                this.context.showScreen(new ContentScreenAdapterKbr(cs));
            }
            catch (InitException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
        } else if (cs != null && this.currentService.isShowConfirm()) {
            MediaPlayer.getInstance().play("confirm_mobile.mp3");
            this.log.debug((Object)"Show confirm screen");
            this.currentScreen = cs;
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            sd.setId("confirm");
            sd.setTitle(B.get((String)"Provider.mobile.confirm.title", (Locale)this.locale));
            sd.setDecor(AppDefaults.getInstance().getStringValue("Provider.mobile.screen.confirm.decor", null));
            try {
                this.initCurrentScreen(cs, ScreenHelper.processBack((ScreenDescription)sd, (boolean)false, (this.parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(this.environment, this.data, this.currentService, this.currentCommission), (ScreenListener)new LocalConfirmListener());
                this.context.showScreen(new ContentScreenAdapterKbr(cs));
            }
            catch (InitException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
        } else {
            this.toVerify();
        }
    }

    private void toVerify() {
        this.log.debug((Object)("toVerify " + this.currentService));
        this.helper.verify(this.currentService, this.currentCommission, this.realItem.isVerify(), this.currentNumber, (ProviderHelperListener)this.helperListener, this.locale, this.realItem.isIgnoreMinMaxCommission());
    }

    private void toPayment() {
        SumScreenDescription ssd = InitModuleHelper.createSumScreenDescription();
        ssd.setType(this.sumType);
        Pack pack = Session.getInstance().getPack();
        this.environment.setMenuItem(this.realItem);
        this._startPayment(this.environment, ssd, this.data, pack.getOperationSum(), this.currentService, this.currentCommission);
    }

    private void toAskAboutPayment() {
        this.log.debug((Object)"toAskAboutPayment");
        this.log.info((Object)"\u0421\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b");
        boolean defaultOk = AppDefaults.getInstance().getBooleanProperty("Provider.mobile.phone.unknown.default-ok", true);
        DialogScreen dialog = "cancel".equals(AppDefaults.getInstance().getStringValue("Provider.mobile.screen.capacity")) ? ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Provider.mobile.phone.unknown", (Locale)this.locale), this.currentView), 30, DC.cases((int)23), UserCase.Cancel) : ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Provider.mobile.phone.unknown", (Locale)this.locale), this.currentView), 30, DC.cases((int)6), defaultOk ? UserCase.Ok : UserCase.Timeout);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                MobileInputModule.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                if (userCase == UserCase.Ok) {
                    MobileInputModule.this.helper.notifyUnknownNumber(MobileInputModule.this.menuItem, MobileInputModule.this.currentNumber);
                    MobileInputModule.this.toConfirm();
                } else if (userCase == UserCase.Cancel) {
                    ModuleHelper.invoke(MobileInputModule.this.cancelListener);
                } else {
                    MobileInputModule.this.cancel(null);
                }
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    private void toShowInvalidNumberDialog() {
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Provider.mobile.phone.invalid", (Locale)this.locale), this.currentView), 10, DC.cases((int)8, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
        this.context.showDialog((DialogInterface)dialog);
    }

    private void toShowNetworkErrorDialog() {
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.mobile.phone.verify.failure", (Locale)this.locale), 10, DC.cases((int)8, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
        this.context.showDialog((DialogInterface)dialog);
        ModuleHelper.invoke(this.cancelListener);
    }

    private void toAskOnNetworkError() {
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Provider.mobile.phone.unknown.verify.failure", (Locale)this.locale), this.currentView), 10, DC.cases((int)6, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                MobileInputModule.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                if (userCase == UserCase.Ok) {
                    MobileInputModule.this.log.info((Object)"\u041f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043a \u0431\u043b\u043e\u043a\u0443 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f");
                    MobileInputModule.this.toConfirm();
                } else {
                    ModuleHelper.invoke(MobileInputModule.this.cancelListener);
                }
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    public String toString() {
        return "MobileProvider";
    }

    private class LocalVefifyListener
    implements ForceVerifyListener {
        private LocalVefifyListener() {
        }

        @Override
        public void onResult(VerifyResult verifyResult) {
            MobileInputModule.this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043d\u043e\u043c\u0435\u0440\u0430: " + verifyResult));
            if (verifyResult.getResultType() == VerifyResultType.Ok) {
                MobileInputModule.this.toConfirm();
            } else if (verifyResult.getResultType() == VerifyResultType.NotFound) {
                ModuleHelper.invoke(MobileInputModule.this.cancelListener);
                MobileInputModule.this.toShowInvalidNumberDialog();
            } else if ("allow".equals(MobileInputModule.this.actionOnError)) {
                MobileInputModule.this.log.info((Object)"\u041f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043d\u0430 \u043a\u043e\u043d\u0444\u0438\u0440\u043c");
                MobileInputModule.this.toConfirm();
            } else if ("disallow".equals(MobileInputModule.this.actionOnError)) {
                MobileInputModule.this.log.info((Object)"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u044e \u0434\u0438\u0430\u043b\u043e\u0433 \u043e\u0448\u0438\u0431\u043a\u0438");
                MobileInputModule.this.toShowNetworkErrorDialog();
            } else {
                MobileInputModule.this.log.info((Object)"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u044e \u0434\u0438\u0430\u043b\u043e\u0433 \u0432\u044b\u0431\u043e\u0440\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
                ModuleHelper.invoke(MobileInputModule.this.cancelListener);
                MobileInputModule.this.toAskOnNetworkError();
            }
        }

        @Override
        public void onException(Exception ex) {
            MobileInputModule.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", (Throwable)ex);
            if ("allow".equals(MobileInputModule.this.actionOnError)) {
                MobileInputModule.this.log.info((Object)"\u041f\u0435\u0440\u0435\u0445\u043e\u0434\u0443 \u043d\u0430 \u043a\u043e\u043d\u0444\u0438\u0440\u043c");
                MobileInputModule.this.toConfirm();
            } else if ("disallow".equals(MobileInputModule.this.actionOnError)) {
                MobileInputModule.this.log.info((Object)"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u044e \u0434\u0438\u0430\u043b\u043e\u0433 \u043e\u0448\u0438\u0431\u043a\u0438");
                MobileInputModule.this.toShowNetworkErrorDialog();
            } else {
                MobileInputModule.this.log.info((Object)"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u044e \u0434\u0438\u0430\u043b\u043e\u0433 \u0432\u044b\u0431\u043e\u0440\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
                MobileInputModule.this.toAskOnNetworkError();
            }
        }
    }

    private class LocalHelperListener
    implements ProviderHelperListener {
        private LocalHelperListener() {
        }

        @Override
        public void onVerifyComplete(VerifyResult result) {
            MobileInputModule.this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043d\u043e\u043c\u0435\u0440\u0430: " + result));
            if (result.getDataItems() != null && result.getDataItems().length > 0) {
                for (VerifyDataItem vdi : result.getDataItems()) {
                    if (!ArgumentType.In.equals((Object)vdi.getType()) && !ArgumentType.InOut.equals((Object)vdi.getType())) continue;
                    MobileInputModule.this.data.put(vdi.getKey(), new InputElement(vdi.getKey(), vdi.getKeyTitle(), vdi.getValue(), vdi.getValueTitle(), vdi.getFlags() != null ? vdi.getFlags() : 0));
                }
            }
            MobileInputModule.this.toPayment();
        }

        @Override
        public void toPayment() {
            MobileInputModule.this.log.debug((Object)"\u041e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f, \u043f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043a \u043e\u043f\u043b\u0430\u0442\u0435");
            MobileInputModule.this.toPayment();
        }

        @Override
        public void onVerifyError() {
            MobileInputModule.this.log.info((Object)"Erron on verify");
            ModuleHelper.invoke(MobileInputModule.this.cancelListener);
        }
    }

    private class LocalConfirmListener
    extends ScreenAdapter {
        private LocalConfirmListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            MobileInputModule.this.log.info((Object)("Confirm action: " + action));
            MobileInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                MobileInputModule.this.data.putAll(data);
                MobileInputModule.this.toVerify();
            } else if (ActionType.isExit((String)action)) {
                MobileInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                try {
                    MobileInputModule.this.toShowNumberPanel();
                }
                catch (InitException ex) {
                    MobileInputModule.this.log.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            MobileInputModule.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action)) {
                MobileInputModule.this.back();
            } else if (ActionType.isExit((String)action)) {
                MobileInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                MobileInputModule.this.currentService = MobileInputModule.this.menuItem.getService();
                MobileInputModule.this.currentCommission = MobileInputModule.this.menuItem.getCommission();
                Date now = new Date();
                MobileInputModule.this.environment.setAllowedNotes(PaymentHelper.getAllowedUnits(MobileInputModule.this.menuItem, 3, now));
                MobileInputModule.this.environment.setAllowedCoins(PaymentHelper.getAllowedUnits(MobileInputModule.this.menuItem, 4, now));
                MobileInputModule.this.data = data;
                InputElement ie = (InputElement)data.get("id1");
                MobileInputModule.this.log.info((Object)ie);
                MobileInputModule.this.currentNumber = LocalNumberExtractor.convertNumber(ie.getValue(), MobileInputModule.this.lces);
                if (!ie.getValue().equals(MobileInputModule.this.currentNumber)) {
                    MobileInputModule.this.log.info((Object)("\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430 \u0437\u0430\u043c\u0435\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 \u043d\u0430: " + MobileInputModule.this.currentNumber));
                    ie.setValue(MobileInputModule.this.currentNumber);
                }
                MobileInputModule.this.currentView = ie.getValueTitle();
                MobileInputModule.this.realItem = MobileInputModule.this.menuItem;
                Integer serviceId = FederalNumberValidator.getInstance().getProvider(MobileInputModule.this.currentNumber);
                MobileInputModule.this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043f\u043e \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c: " + serviceId));
                if (serviceId == null) {
                    MobileInputModule.this.log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043e \u0444\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c, \u0441\u043c\u043e\u0442\u0440\u0438\u043c \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430");
                    serviceId = MobileInputModule.this.cnv.getProvider(MobileInputModule.this.currentNumber);
                    if (serviceId == null) {
                        MobileInputModule.this.log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043e \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u0430\u043c");
                        if (MobileInputModule.this.verifyUnknownNumbers) {
                            MobileInputModule.this.log.info((Object)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443");
                            MobileInputModule.this.helper.forceVerify(MobileInputModule.this.menuItem.getService(), MobileInputModule.this.currentNumber, (ForceVerifyListener)new LocalVefifyListener(), MobileInputModule.this.locale, MobileInputModule.this.menuItem.isIgnoreMinMaxCommission());
                            return;
                        }
                        MobileInputModule.this.toAskAboutPayment();
                        return;
                    }
                }
                if (serviceId.intValue() == MobileInputModule.this.menuItem.getService().getCode()) {
                    MobileInputModule.this.log.info((Object)"\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443");
                    MobileInputModule.this.toConfirm();
                } else if (MobileInputModule.this.menuItem.getService().getChildServices() != null && MobileInputModule.this.menuItem.getService().getChildServices().contains(serviceId)) {
                    MobileInputModule.this.log.info((Object)"\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u043e\u0447\u0435\u0440\u043d\u0435\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430 \u043c\u0435\u043d\u044e. \u041f\u043e\u0434\u043c\u0435\u043d\u044f\u044e \u0441\u0435\u0440\u0432\u0438\u0441");
                    MobileInputModule.this.currentService = new Service(MobileInputModule.this.menuItem.getService());
                    MobileInputModule.this.currentService.setId(serviceId.intValue());
                    MobileInputModule.this.toConfirm();
                } else {
                    MobileInputModule.this.log.info((Object)"\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u0440\u0435\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u0440\u0443\u0433\u043e\u043c\u0443 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0443. \u041f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043d\u0430 \u0444\u043e\u0440\u043c\u0443 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430");
                    MobileInputModule.this.toAskAboutChange(serviceId);
                }
            }
        }

        public void onRedirect(int serviceId) {
            MobileInputModule.this._redirect(serviceId);
        }
    }
}

