/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.hopper;

import i18n.B;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.MoneyUnit;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.hopper.Hopper;
import ru.softlogic.hardware.device.hopper.HopperException;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.system.util.PathUtils;

public class CoinHopperInputModule
extends BaseInputModule {
    private Environment environment;
    private CashBox cashBox;
    private ServerUser menuUser;

    public CoinHopperInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        this.menuUser = environment.getInitData() != null && environment.getInitData().get("menu-user") instanceof ServerUser ? (ServerUser)environment.getInitData().get("menu-user") : null;
        if (Hopper.getDefaultHopper() != null) {
            try {
                Form f = FormHelper.parseCustom(new File(PathUtils.getAppHome() + "/resources/utility/coin-hopper.xml"), environment.getLocale());
                if (f.getScreenSequence().getScreens().size() != 1) {
                    throw new ParseException("Wrong number of screens");
                }
                CommonScreen cs = CommonScreenStore.getScreen((String)"letter");
                cs.init(ScreenHelper.processBack((ScreenDescription)((ScreenDescription)f.getScreenSequence().getScreens().get(0)), (boolean)true, (parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(environment, new HashMap<String, Object>()));
                cs.setListener((ScreenListener)new LocalScreenListener());
                this.context.showScreen(new ContentScreenAdapterKbr(cs));
            }
            catch (InitException ex) {
                throw new ModuleInitException(ex);
            }
            catch (ParseException ex) {
                throw new DescriptionException(ex);
            }
        } else {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.coin-hopper.nohopper", (Locale)environment.getLocale()), 10, DC.cases((int)8, (Locale)environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener((DialogListener)new ExitDialogListener(this));
            this.context.showDialog((DialogInterface)dialog);
        }
    }

    public void setCoinBox(CashBox cashBox) {
        this.cashBox = cashBox;
    }

    @Override
    protected void _restore() {
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CoinHopperInputModule.this.log.info((Object)("User make action: " + action + ", " + data));
            if (ActionType.isNext((String)action)) {
                DialogScreen dialog;
                Keeper keeper = new Keeper();
                try {
                    for (String key : data.keySet()) {
                        InputElement coin = (InputElement)data.get(key);
                        if (coin == null || coin.getValue() == null || !coin.getValue().matches("^\\d+$") || !key.matches("^\\d+$")) continue;
                        CoinHopperInputModule.this.log.info((Object)("Coin " + key + "->" + coin.getValue()));
                        CashUnit cu = CashFactory.getDefaultInstance().getCoinUnitByNominal(new Sum(Integer.parseInt(key)));
                        if (cu != null) {
                            CoinHopperInputModule.this.log.info((Object)("Process " + cu));
                            CoinHopperInputModule.this.log.info((Object)"  Add it to hopper");
                            int count = Integer.parseInt(coin.getValue());
                            Hopper.getDefaultHopper().add((MoneyUnit)cu, count);
                            CoinHopperInputModule.this.log.info((Object)"  Success!");
                            if (CoinHopperInputModule.this.cashBox != null) {
                                CoinHopperInputModule.this.log.info((Object)"  Add it to coin box");
                                CoinHopperInputModule.this.cashBox.addCash(cu, count);
                                CoinHopperInputModule.this.log.info((Object)"  Success!");
                            } else {
                                CoinHopperInputModule.this.log.error((Object)"Coin box is not set");
                            }
                            keeper.addCash(cu, count);
                            continue;
                        }
                        CoinHopperInputModule.this.log.error((Object)"Coin is not found");
                    }
                    CoinHopperInputModule.this.log.info((Object)"Complete");
                    DialogScreen dialog2 = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.coin-hopper.load.success", (Locale)CoinHopperInputModule.this.environment.getLocale()), 10, DC.cases((int)8, (Locale)CoinHopperInputModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog2.addListener((DialogListener)new ExitDialogListener(CoinHopperInputModule.this));
                    CoinHopperInputModule.this.context.showDialog((DialogInterface)dialog2);
                }
                catch (HopperException ex) {
                    dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Provider.coin-hopper.nohopper", (Locale)CoinHopperInputModule.this.environment.getLocale()), ex.getMessage()), 10, DC.cases((int)8, (Locale)CoinHopperInputModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CoinHopperInputModule.this));
                    CoinHopperInputModule.this.context.showDialog((DialogInterface)dialog);
                }
                catch (IOException ex) {
                    dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.coin-hopper.load.io-error", (Locale)CoinHopperInputModule.this.environment.getLocale()), 10, DC.cases((int)8, (Locale)CoinHopperInputModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CoinHopperInputModule.this));
                    CoinHopperInputModule.this.context.showDialog((DialogInterface)dialog);
                }
                int id = SequenceManager.getValueQuietly((String)"collection-id");
                MoneyCollection mc = new MoneyCollection(id, keeper, DeviceClass.CoinAcceptor, keeper.getCreated(), CoinHopperInputModule.this.menuUser);
                mc.setPayout(true);
                if (CoinHopperInputModule.this.context.getFraudQueue() != null) {
                    CoinHopperInputModule.this.context.getFraudQueue().putMoneyCollection(mc);
                } else {
                    CoinHopperInputModule.this.context.getServerConnector().sendMoneyCollection(mc);
                }
            } else {
                CoinHopperInputModule.this.cancel(null);
            }
        }
    }
}

