/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.dynamic;

import i18n.B;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.task.Task;
import ru.softlogic.dynamic.input.model.transport.MessageSerializer;
import ru.softlogic.dynamic.input.model.transport.message.TransportMessage;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.dynamic.DynamicFormInputModule;
import ru.softlogic.module.input.dynamic.RequestResultListener;
import ru.softlogic.srv.api.request.RequestResult;

public class OnlineRequest
implements Task {
    private DynamicFormInputModule module;
    private TransportMessage meassage;
    private RequestResultListener listener;
    private Logger log = Logger.getLogger((String)"pay");

    public OnlineRequest(DynamicFormInputModule module, TransportMessage meassage, RequestResultListener listener) {
        this.module = module;
        this.meassage = meassage;
        this.listener = listener;
    }

    @Override
    public String getMessage() {
        return B.get((String)"Module.dynamic.request.wait", (Locale)this.module.getLocale());
    }

    @Override
    public Object execute() {
        try {
            HashMap<String, InputElement> data = new HashMap<String, InputElement>();
            data.put("id1", new InputElement("id1", "id1", "id1"));
            String v = MessageSerializer.serialize((TransportMessage)this.meassage);
            data.put("request", new InputElement("request", "request", v));
            return this.module.getContext().getServerConnector().request(this.module.getEnv().getMenuItem().getService(), data, true);
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    @Override
    public void onResult(Object result) {
        this.log.info((Object)("Online result: " + result));
        if (result instanceof Exception) {
            Exception ex = (Exception)result;
            ModuleHelper.invoke(this.module.getCancelListener());
            if (this.listener == null || this.listener.onException(ex)) {
                DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.dynamic.request.error", (Locale)this.module.getLocale()), 10, DC.cases((int)8, (Locale)this.module.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                this.module.getContext().showDialog((DialogInterface)ds);
            }
        } else {
            RequestResult rr = (RequestResult)result;
            if (rr.getError() == 0) {
                if (this.listener != null) {
                    TransportMessage tm = null;
                    try {
                        tm = MessageSerializer.deserialize((String)((String)rr.getData().get("response")));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    this.listener.onResult(0, tm);
                }
            } else {
                ModuleHelper.invoke(this.module.getCancelListener());
                if (this.listener == null || this.listener.onResult(rr.getError(), null)) {
                    DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)("Module.dynamic.request.error." + rr.getError()), (Locale)this.module.getLocale()), 10, DC.cases((int)8, (Locale)this.module.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    this.module.getContext().showDialog((DialogInterface)ds);
                }
            }
        }
    }
}

