/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.dynamic;

import i18n.B;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.Sum;
import ru.softlogic.dynamic.input.model.exception.WrongArgumentException;
import ru.softlogic.dynamic.input.model.field.Field;
import ru.softlogic.dynamic.input.model.field.FieldBar;
import ru.softlogic.dynamic.input.model.field.impl.SimpleField;
import ru.softlogic.dynamic.input.model.message.Message;
import ru.softlogic.dynamic.input.model.message.MessageType;
import ru.softlogic.dynamic.input.model.screen.Screen;
import ru.softlogic.dynamic.input.model.transport.message.TransportMessage;
import ru.softlogic.dynamic.input.model.transport.message.impl.FinishSessionRequest;
import ru.softlogic.dynamic.input.model.transport.message.impl.FinishSessionResponse;
import ru.softlogic.dynamic.input.model.transport.message.impl.GetNextScreenRequest;
import ru.softlogic.dynamic.input.model.transport.message.impl.GetPrevScreenRequest;
import ru.softlogic.dynamic.input.model.transport.message.impl.GetScreenResponse;
import ru.softlogic.dynamic.input.model.transport.message.impl.StartSessionRequest;
import ru.softlogic.dynamic.input.model.transport.message.impl.StartSessionResponse;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.dynamic.DFHelper;
import ru.softlogic.module.input.dynamic.OnlineRequest;
import ru.softlogic.module.input.dynamic.RequestResultListener;
import ru.softlogic.module.input.dynamic.ScreenStatus;
import ru.softlogic.module.utils.CancelDialogListener;
import ru.softlogic.module.utils.ExitDialogListener;

public class DynamicFormInputModule
extends BaseInputModule {
    private Locale locale;
    private Map<String, Object> data = new LinkedHashMap<String, Object>();
    private Screen current;
    private Environment env;
    private Restorable parent;
    private ComplexScreenListener screenListener;
    private SumScreenDescription sumDescription;
    private Integer session;
    private RequestResultListener sessionListener = new LocalStartResultListener();
    private List<ScreenStatus> currentScreens;
    private ScreenStatus currentScreenStatus;
    private Set<String> sumFields;

    public DynamicFormInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.env = environment;
        this.parent = parent;
        this.sumDescription = null;
        this.session = null;
        this.current = null;
        this.screenListener = new LocalScreenListener((ApplicationContext)this.context);
        this.screenListener.setEnvironment(environment);
        this.data.clear();
        this.context.getTaskExecutor().execute(new OnlineRequest(this, (TransportMessage)new StartSessionRequest(), this.sessionListener));
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        try {
            this.showScreen(this.currentScreenStatus);
        }
        catch (InitException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.notifyProblem((String)ex.getMessage());
        }
    }

    @Override
    public Map<String, Object> getDataContext() {
        return this.data;
    }

    private void showScreen(ScreenStatus st) throws InitException {
        if (st == null) {
            throw new InitException("ScreenStatus can't be null");
        }
        CommonScreen currentScreen = CommonScreenStore.getScreen((String)st.getSd().getType());
        if (currentScreen != null) {
            currentScreen.init(st.getSd(), InitModuleHelper.buildScreenInit(this.env, this.data));
            currentScreen.setListener((ScreenListener)this.screenListener);
            this.context.showScreen(new ContentScreenAdapterKbr(currentScreen));
        }
        this.currentScreenStatus = st;
        if (st.getMessage() != null && !st.getMessage().trim().isEmpty()) {
            DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, st.getMessage(), 10, DC.cases((int)8, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
            this.context.showDialog((DialogInterface)ds);
        }
    }

    private void showScreen(Screen screen) throws InitException {
        if (screen == null) {
            throw new InitException("Screen can't be null");
        }
        this.sumFields = DFHelper.getSumFields(screen);
        this.currentScreens = DFHelper.convert(screen);
        if (this.currentScreens.isEmpty()) {
            throw new InitException("CurrentScreens can't be empty");
        }
        this.current = screen;
        this.data.clear();
        this.showScreen(this.currentScreens.get(0));
        if (screen.getMessageBar() != null && screen.getMessageBar().getMessages() != null) {
            for (Message m : screen.getMessageBar().getMessages()) {
                if (m.getType() != MessageType.ERROR) continue;
                DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, m.getMessage(), 10, DC.cases((int)8, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
                this.context.showDialog((DialogInterface)ds);
                break;
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Runnable getCancelListener() {
        return this.cancelListener;
    }

    public Restorable getParent() {
        return this.parent;
    }

    public InputModuleContext getContext() {
        return this.context;
    }

    public Environment getEnv() {
        return this.env;
    }

    private class LocalStartResultListener
    implements RequestResultListener {
        private LocalStartResultListener() {
        }

        @Override
        public boolean onResult(int error, TransportMessage result) {
            DynamicFormInputModule.this.log.info((Object)("On result: " + error + " " + result));
            if (error == 0) {
                if (result instanceof StartSessionResponse) {
                    StartSessionResponse ssr = (StartSessionResponse)result;
                    try {
                        DynamicFormInputModule.this.showScreen(ssr.getScreen());
                        DynamicFormInputModule.this.session = ssr.getSession();
                    }
                    catch (InitException ex) {
                        DynamicFormInputModule.this.log.error((Object)ex, (Throwable)ex);
                        DynamicFormInputModule.this.cancel(new ExitIntent((ApplicationContext)DynamicFormInputModule.this.context));
                    }
                } else if (result instanceof GetScreenResponse) {
                    GetScreenResponse gsr = (GetScreenResponse)result;
                    try {
                        DynamicFormInputModule.this.showScreen(gsr.getScreen());
                        DynamicFormInputModule.this.session = gsr.getSession();
                    }
                    catch (InitException ex) {
                        this.onError();
                    }
                } else if (result instanceof FinishSessionResponse) {
                    FinishSessionResponse fsr = (FinishSessionResponse)result;
                    LinkedHashMap<String, Object> localData = new LinkedHashMap<String, Object>();
                    InputElement id1 = null;
                    if (fsr.getFieldBar() != null && fsr.getFieldBar().getFields() != null && !fsr.getFieldBar().getFields().isEmpty()) {
                        for (Field f : fsr.getFieldBar().getFields()) {
                            String title = f.getTitle();
                            if (title != null) {
                                title = title.replace(":", "");
                            }
                            localData.put(f.getCode(), new InputElement(f.getCode(), title, String.valueOf(f.getValue())));
                            if (id1 != null || String.valueOf(f.getValue()).length() >= 35) continue;
                            id1 = new InputElement("id1", title, String.valueOf(f.getValue()));
                        }
                        if (id1 == null) {
                            id1 = new InputElement("id1", "-", "-");
                        }
                        localData.put("id1", id1);
                    }
                    DynamicFormInputModule.this.sumDescription = new SumScreenDescription();
                    DynamicFormInputModule.this.sumDescription.setType("sum");
                    Object obj = DynamicFormInputModule.this.data.get("#sum");
                    Sum operationSum = null;
                    if (obj != null) {
                        if (obj instanceof TransactionSum) {
                            TransactionSum ts = (TransactionSum)obj;
                            operationSum = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
                        } else if (obj instanceof InputElement) {
                            InputElement ie = (InputElement)obj;
                            if (ie.getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                                operationSum = new Sum(Double.parseDouble(ie.getValue()));
                            } else if (ie.hasFlag(2048)) {
                                DynamicFormInputModule.this.log.error((Object)("Wrong sum format: " + ie));
                            } else {
                                DynamicFormInputModule.this.log.error((Object)("Wrong sum format: " + ie.getValue()));
                            }
                        } else if (obj instanceof Sum) {
                            operationSum = (Sum)obj;
                        }
                    }
                    DynamicFormInputModule.this._startPayment(DynamicFormInputModule.this.env, DynamicFormInputModule.this.sumDescription, localData, operationSum, null, null);
                } else {
                    DynamicFormInputModule.this.log.info((Object)("Unknown object: " + result));
                    this.onError();
                }
            } else {
                DynamicFormInputModule.this.log.info((Object)("Error status: " + error));
                this.onError();
            }
            return false;
        }

        @Override
        public boolean onException(Exception ex) {
            this.onError();
            return false;
        }

        private void onError() {
            DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.dynamic.request.error", (Locale)DynamicFormInputModule.this.locale), 10, DC.cases((int)8, (Locale)DynamicFormInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
            if (DynamicFormInputModule.this.session == null) {
                ds.addListener((DialogListener)new ExitDialogListener(DynamicFormInputModule.this));
            } else {
                ds.addListener((DialogListener)new CancelDialogListener(DynamicFormInputModule.this.cancelListener));
            }
            DynamicFormInputModule.this.context.showDialog((DialogInterface)ds);
        }
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            DynamicFormInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                DynamicFormInputModule.this.data.putAll(data);
                if (data != null) {
                    for (String key : data.keySet()) {
                        if (DynamicFormInputModule.this.sumFields == null || !DynamicFormInputModule.this.sumFields.contains(key)) continue;
                        DynamicFormInputModule.this.data.put("#sum", new InputElement("#sum", "", ((InputElement)data.get(key)).getValue()));
                    }
                }
                if (DynamicFormInputModule.this.currentScreens.indexOf(DynamicFormInputModule.this.currentScreenStatus) < DynamicFormInputModule.this.currentScreens.size() - 1) {
                    try {
                        DynamicFormInputModule.this.showScreen((ScreenStatus)DynamicFormInputModule.this.currentScreens.get(DynamicFormInputModule.this.currentScreens.indexOf(DynamicFormInputModule.this.currentScreenStatus) + 1));
                    }
                    catch (InitException ex) {
                        DynamicFormInputModule.this.log.error((Object)ex, (Throwable)ex);
                        ModuleHelper.invoke(cancelListener);
                    }
                } else {
                    try {
                        FieldBar fb = new FieldBar();
                        for (Object o : DynamicFormInputModule.this.data.values()) {
                            InputElement ie;
                            if (!(o instanceof InputElement) || (ie = (InputElement)o).getKey() == null || ie.getKey().startsWith("#")) continue;
                            fb.addField((Field)new SimpleField(ie.getKey(), ie.getKeyTitle(), (Object)ie.getValue()));
                        }
                        DynamicFormInputModule.this.context.getTaskExecutor().execute(new OnlineRequest(DynamicFormInputModule.this, (TransportMessage)(DynamicFormInputModule.this.current.getActionBar().hasPay() ? new FinishSessionRequest(DynamicFormInputModule.this.session, DynamicFormInputModule.this.current.getCode(), fb) : new GetNextScreenRequest(DynamicFormInputModule.this.session, DynamicFormInputModule.this.current.getCode(), fb)), DynamicFormInputModule.this.sessionListener));
                    }
                    catch (WrongArgumentException ex) {
                        DynamicFormInputModule.this.log.error((Object)ex, (Throwable)ex);
                        ModuleHelper.invoke(cancelListener);
                    }
                }
            } else if (ActionType.isExit((String)action)) {
                DynamicFormInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                if (DynamicFormInputModule.this.currentScreens.indexOf(DynamicFormInputModule.this.currentScreenStatus) > 0) {
                    try {
                        DynamicFormInputModule.this.showScreen((ScreenStatus)DynamicFormInputModule.this.currentScreens.get(DynamicFormInputModule.this.currentScreens.indexOf(DynamicFormInputModule.this.currentScreenStatus) - 1));
                    }
                    catch (InitException ex) {
                        DynamicFormInputModule.this.log.error((Object)ex, (Throwable)ex);
                        ModuleHelper.invoke(cancelListener);
                    }
                } else if (DynamicFormInputModule.this.current.getActionBar().hasPrev()) {
                    try {
                        DynamicFormInputModule.this.context.getTaskExecutor().execute(new OnlineRequest(DynamicFormInputModule.this, (TransportMessage)new GetPrevScreenRequest(DynamicFormInputModule.this.session, DynamicFormInputModule.this.current.getCode()), DynamicFormInputModule.this.sessionListener));
                    }
                    catch (WrongArgumentException ex) {
                        DynamicFormInputModule.this.log.error((Object)ex, (Throwable)ex);
                        ModuleHelper.invoke(cancelListener);
                    }
                } else {
                    DynamicFormInputModule.this.back();
                }
            }
        }
    }
}

