/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.chcopy;

import i18n.B;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.GroupByMenuItemVisitor;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.text.SimpleFormatter;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.operation.Operation;
import ru.softlogic.provider.ProviderType;

public class RequestAccountTask
implements Task {
    private static final Logger log = Logger.getLogger((String)"pay");
    private final Environment environment;
    private final String number;
    private final String pin;
    private final InputModuleContext context;
    private final Runnable cancelAction;

    public RequestAccountTask(Environment environment, InputModuleContext context, String number, String pin, Runnable cancelAction) {
        this.environment = environment;
        this.number = number;
        this.pin = pin;
        this.context = context;
        this.cancelAction = cancelAction;
    }

    @Override
    public Object execute() {
        log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a\u043e\u043f\u0438\u0438 \u0447\u0435\u043a\u0430: oper=" + this.number + ",pin=" + this.pin));
        try {
            return this.context.getServerConnector().checkCopy(Long.parseLong(this.number), this.pin);
        }
        catch (Exception ex) {
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + object));
        if (object == null) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.chcopy.request.error"), 10, DC.cases((int)1), UserCase.Ok);
            this.context.showDialog((DialogInterface)dialog);
            ModuleHelper.invoke(this.cancelAction);
        } else if (object instanceof Exception) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.chcopy.request.failure"), 10, DC.cases((int)1), UserCase.Ok);
            this.context.showDialog((DialogInterface)dialog);
            ModuleHelper.invoke(this.cancelAction);
        } else if (object instanceof Operation) {
            Operation op = (Operation)object;
            this.fixOperation(op);
            log.info((Object)("Views=" + op.getViews() + ", titles=" + op.getTitles() + ", form=" + op.getForm() + ", point=" + op.getPoint() + ", dealer=" + op.getDealer()));
            this.context.getPrinterQueue().print(op);
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.chcopy.request.succees"), 20, DC.cases((int)1), UserCase.Ok);
            dialog.addListener((DialogListener)new ExitDialogListener(this.environment.getInputModule()));
            this.context.showDialog((DialogInterface)dialog);
        }
    }

    @Override
    public String getMessage() {
        return B.get((String)"Request.wait");
    }

    private void fixOperation(Operation op) {
        if (op == null) {
            return;
        }
        MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(op.getService().getId());
        MenuUtils.processMenu((MenuVisitor)mbsiv);
        if (mbsiv.getMenuItem() != null) {
            log.info((Object)mbsiv.getMenuItem());
            GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(mbsiv.getMenuItem());
            MenuUtils.processMenu((MenuVisitor)gbmiv);
            op.setServiceType(gbmiv.getServiceType());
        } else {
            log.error((Object)("Menu item by service id " + op.getService().getId() + " not found"));
        }
        if (op.getPoint() == null) {
            op.setPoint(this.environment.getPoint());
        }
        op.setCopy(true);
        if (op.getService() != null) {
            if (op.getService().getProviderType() == ProviderType.Mobile) {
                SimpleFormatter formatter = new SimpleFormatter("8(***)***-****");
                op.getTitles().put("id1", B.get((String)"Provider.mobile.phone.number"));
                op.getViews().put("id1", formatter.format((String)op.getForm().get("id1")));
                InputElement id1 = (InputElement)op.getInputElements().get("id1");
                if (id1 != null) {
                    id1.setKeyTitle(B.get((String)"Provider.mobile.phone.number"));
                    id1.setValueTitle(formatter.format((String)op.getForm().get("id1")));
                }
            } else {
                if (op.getViews().get("id1") == null) {
                    op.getViews().put("id1", op.getForm().get("id1"));
                }
                if (op.getTitles().get("id1") == null) {
                    op.getTitles().put("id1", "");
                }
                if (op.getTitles().get("id2") == null) {
                    op.getTitles().put("id2", "");
                }
                if (op.getViews().get("id2") == null && op.getForm().get("id2") != null) {
                    op.getViews().put("id2", op.getForm().get("id2"));
                }
            }
        }
        ModuleHelper.clearNotPrinted(op.getInputElements(), op.getForm(), op.getViews(), op.getTitles());
    }
}

