/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.cashtocard;

import i18n.B;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.OperationDepositResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.gui.factory.AbstractComponentFactory;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.BaseCardInputModule;
import ru.softlogic.module.card.CardConfirmHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.card.proxy.DepositListenerProxy;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.payment.CashPaymentModule;
import ru.softlogic.module.processing.card.BankCardProcessingModule;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.provider.ProviderHelperListener;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.srv.api.verify.ArgumentType;
import ru.softlogic.srv.api.verify.VerifyDataItem;
import ru.softlogic.srv.api.verify.VerifyResult;

public class CashToCardInputModule
extends BaseCardInputModule {
    private final ProviderHelper helper;
    private CommonScreen lastScreen;
    private String panMasked = "";

    public CashToCardInputModule(ApplicationContext context) {
        super(context);
        this.helper = new ProviderHelper(context);
    }

    @Override
    protected void _startModule(Environment environment, ApplicationContext context) {
        this.log.info((Object)"Start module: CashToCardInputModule");
        this.invokeOperation = false;
        environment.setProcessingModule(new BankCardProcessingModule(context));
        environment.setPaymentModule(ModuleFactory.createCashPaymentModule(context, environment.getMenuItem(), new CashPaymentModule(context)));
        this.cm = this.getCardModule(environment, new LocalGuiListener(context, environment, this.log));
        if (this.cm != null) {
            CardConfirmHelper.showConfirm(environment, context, (ScreenListener)new LocalConfirmScreenListener(), this.log);
        } else {
            context.showDialog((DialogInterface)this.createNoCardModuleDialog());
        }
    }

    @Override
    protected void _restore() {
        this.log.info((Object)"CashToCardInputModule: _restore");
        ModuleHelper.invoke(this.cancelListener);
        this.context.showScreen(new ContentScreenAdapter(this.lastScreen));
    }

    private void toPreparePayments(AccountInfo ai, HashMap<String, Object> serverData) {
        this.log.info((Object)"CashToCardInputModule: toPreparePayments");
        this.log.info((Object)("    Account info: " + ai));
        this.log.info((Object)("    Server data: " + serverData));
        SumScreenDescription ssd = new SumScreenDescription();
        ssd.setType("sum");
        ssd.setDecor(AppDefaults.getInstance().getProperty("Module.cashtocard.payment.decor", null));
        if (serverData != null) {
            this.inputData.putAll(serverData);
        }
        if (ai != null) {
            this.inputData.put("id1", new InputElement("id1", B.get((String)"Module.card.account", (Locale)this.locale), ai.getNumber()));
            this.inputData.put("id2", new InputElement("id2", B.get((String)"Module.card.account.currency", (Locale)this.locale), ai.getCurrency() == null ? "" : ai.getCurrency().getDigitCode()));
            this.inputData.put("type", new InputElement("type", B.get((String)"Module.card.account.type", (Locale)this.locale), ai.getType().getStringCode(), String.valueOf(ai.getType()), 0));
        }
        this.inputData.put("#panmasked", new InputElement("#panmasked", B.get((String)"Module.card.account", (Locale)this.locale), this.panMasked));
        this._startPayment(this.environment, ssd, this.inputData);
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        @Override
        public void _onClosed() {
            CashToCardInputModule.this.baseCancel(null);
        }

        @Override
        public void onCashRequire(boolean isEmitent, AccountInfo ai, CashRequireListener cl) {
            CashToCardInputModule.this.log.info((Object)("CardToCard: require: isEmitent = " + isEmitent + "; ai = " + ai + "; cl = " + cl));
            CashToCardInputModule.this.invokeOperation = false;
            CashToCardInputModule.this.context.showWait(null);
            CardModuleStore.getInstance().setCashRequireListener(cl);
            if (AppDefaults.getInstance().getBooleanProperty("Module.cashtocard.comission.show", false)) {
                CashToCardInputModule.this.log.info((Object)"Show comission dialog");
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.commission", (Locale)CashToCardInputModule.this.locale), 10, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new LocalCommissionDialogListener(ai));
                CashToCardInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                CashToCardInputModule.this.log.info((Object)"Make online verify");
                MenuItem mi = CashToCardInputModule.this.environment.getMenuItem();
                CashToCardInputModule.this.helper.verify(mi.getService(), mi.getCommission(), mi.isVerify(), ai == null ? "" : ai.getNumber(), (ProviderHelperListener)new LocalHelperListener(ai), CashToCardInputModule.this.locale, mi.isIgnoreMinMaxCommission());
            }
        }
    }

    private class VerifyConfirmScreenListener
    extends ScreenAdapter {
        private final AccountInfo ai;
        private final HashMap<String, Object> data;

        public VerifyConfirmScreenListener(AccountInfo ai, HashMap<String, Object> data) {
            this.ai = ai;
            this.data = data;
        }

        public void onAction(String action, Map<String, Object> localData, Runnable cancelListener) {
            CashToCardInputModule.this.log.info((Object)("Action " + action + " on confirm screen"));
            CashToCardInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                CashToCardInputModule.this.toPreparePayments(this.ai, this.data);
            } else if (ActionType.isExit((String)action) || ActionType.isPrev((String)action)) {
                CashToCardInputModule.this.cancel(null);
            }
        }
    }

    private class LocalHelperListener
    implements ProviderHelperListener {
        private final AccountInfo ai;

        public LocalHelperListener(AccountInfo ai) {
            this.ai = ai;
        }

        @Override
        public void onVerifyComplete(VerifyResult result) {
            CashToCardInputModule.this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043d\u043e\u043c\u0435\u0440\u0430: " + result));
            if (result.getDataItems() != null && result.getDataItems().length > 0) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (VerifyDataItem vdi : result.getDataItems()) {
                    if (!ArgumentType.In.equals((Object)vdi.getType()) && !ArgumentType.InOut.equals((Object)vdi.getType())) continue;
                    data.put(vdi.getKey(), new InputElement(vdi.getKey(), vdi.getKeyTitle(), vdi.getValue(), vdi.getValueTitle(), vdi.getFlags() != null ? vdi.getFlags() : 0));
                }
                ConfirmScreenDescription sd = new ConfirmScreenDescription();
                sd.setButtons(InitModuleHelper.createKeyMap());
                sd.setTitle(result.getTitle());
                CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
                CashToCardInputModule.this.lastScreen = cs;
                cs.setListener((ScreenListener)new VerifyConfirmScreenListener(this.ai, data));
                try {
                    cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)false, (boolean)true), InitModuleHelper.buildScreenInit(CashToCardInputModule.this.environment, data));
                }
                catch (InitException ex) {
                    CashToCardInputModule.this.log.error((Object)ex, (Throwable)ex);
                    ModuleHelper.invoke(CashToCardInputModule.this.cancelListener);
                }
                CashToCardInputModule.this.context.showScreen(new ContentScreenAdapterKbr(cs));
            } else {
                CashToCardInputModule.this.toPreparePayments(this.ai, null);
            }
        }

        @Override
        public void toPayment() {
            CashToCardInputModule.this.log.debug((Object)"\u041e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f, \u043f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043a \u043e\u043f\u043b\u0430\u0442\u0435");
            CashToCardInputModule.this.toPreparePayments(this.ai, null);
        }

        @Override
        public void onVerifyError() {
            CashToCardInputModule.this.log.info((Object)"Erron on verify");
            ModuleHelper.invoke(CashToCardInputModule.this.cancelListener);
            CardModuleStore.getInstance().clearCashRequireListener();
        }
    }

    private class WrongPinDialogListener
    implements DialogListener {
        private WrongPinDialogListener() {
        }

        public void dialogClosed(UserCase userCase) {
            CashToCardInputModule.this.log.info((Object)"Wrong pin dialog closed. Start card operation");
            CashToCardInputModule.this.invokeOperation = true;
            CardModuleStore cmStore = CardModuleStore.getInstance();
            cmStore.getDepositProxy().setListener(new LocalDepositResultListener());
            CashToCardInputModule.this.cm.deposit((CardModuleResultListener)cmStore.getDepositProxy());
            CashToCardInputModule.this.log.info((Object)"Done");
        }
    }

    private class LocalDepositResultListener
    implements CardModuleResultListener<OperationDepositResult> {
        private LocalDepositResultListener() {
        }

        public void onError(CardModuleError cme, String message, CardInfo cardInfo) {
            DialogScreen dialog;
            CashToCardInputModule.this.invokeOperation = false;
            CashToCardInputModule.this.log.info((Object)(">>>onError " + cme + ", " + message + " CardInfo: " + cardInfo));
            UserAction.getInstance().update();
            Locale currentLocale = CashToCardInputModule.this.locale;
            if (cme == CardModuleError.ERROR_WRONG_PIN) {
                CashToCardInputModule.this.log.info((Object)"Wrong pin, show dialog");
                dialog = this.createDialog(B.get((String)"Provider.card.pin-wrong", (Locale)currentLocale), new WrongPinDialogListener());
            } else if (cme == CardModuleError.ERROR_USER_CANCEL) {
                CashToCardInputModule.this.log.info((Object)"Operation canceled by user, show dialog");
                dialog = this.createDialog(B.get((String)"Provider.card.topup.error1", (Locale)currentLocale), new ExitDialogListener(CashToCardInputModule.this));
            } else {
                String dialogMsg;
                if (message == null || message.isEmpty()) {
                    dialogMsg = B.get((String)"Provider.card.topup.error2", (Locale)currentLocale);
                } else {
                    String pattern = B.get((String)"Provider.card.topup.error3", (Locale)currentLocale);
                    dialogMsg = MessageFormat.format(pattern, B.get((String)message, (Locale)currentLocale, (String)message));
                }
                dialog = this.createDialog(dialogMsg, new ExitDialogListener(CashToCardInputModule.this));
            }
            CashToCardInputModule.this.context.showWait(null);
            CashToCardInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        public void onResult(OperationDepositResult t, CardInfo ci) {
        }

        public void onCardData(CardData cd) {
            CashToCardInputModule.this.log.info((Object)("onCardData: " + cd));
            CashToCardInputModule.this.panMasked = cd.getPan();
            CashToCardInputModule.this.log.info((Object)("panMasked: " + CashToCardInputModule.this.panMasked + " " + CashToCardInputModule.this.panMasked.hashCode()));
        }

        private DialogScreen createDialog(String dialogMsg, DialogListener listener) {
            AbstractComponentFactory componentFactory = ComponentFactory.getInstance();
            DialogScreen dialog = componentFactory.createDialog(DialogType.Question, dialogMsg, 20, DC.cases((int)8), UserCase.Ok);
            dialog.addListener(listener);
            return dialog;
        }
    }

    private class LocalCommissionDialogListener
    implements DialogListener {
        private final AccountInfo ai;

        public LocalCommissionDialogListener(AccountInfo ai) {
            this.ai = ai;
        }

        public void dialogClosed(UserCase userCase) {
            CashToCardInputModule.this.log.info((Object)("Comission dialog closed with result: " + userCase));
            MenuItem mi = CashToCardInputModule.this.environment.getMenuItem();
            CashToCardInputModule.this.log.info((Object)("Make online verify, ai=" + this.ai));
            CashToCardInputModule.this.helper.verify(mi.getService(), mi.getCommission(), mi.isVerify(), this.ai == null ? "" : this.ai.getNumber(), (ProviderHelperListener)new LocalHelperListener(this.ai), CashToCardInputModule.this.locale, mi.isIgnoreMinMaxCommission());
        }
    }

    private class LocalConfirmScreenListener
    extends ScreenAdapter {
        private LocalConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CashToCardInputModule.this.cancelListener = cancelListener;
            CashToCardInputModule.this.log.info((Object)("Action on confirm input screen: " + action));
            if (ActionType.isNext((String)action)) {
                CashToCardInputModule.this.log.info((Object)"Start card operation");
                CashToCardInputModule.this.invokeOperation = true;
                DepositListenerProxy depositProxy = CardModuleStore.getInstance().getDepositProxy();
                depositProxy.setListener(new LocalDepositResultListener());
                CashToCardInputModule.this.cm.deposit((CardModuleResultListener)depositProxy);
                CashToCardInputModule.this.log.info((Object)"Done");
            } else {
                CashToCardInputModule.this.cancel(null);
            }
        }
    }
}

