/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.advanced.hdw;

import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdw.dev.crd.CardStateListener;
import ru.softlogic.hdw.dev.crd.MagneticApi;
import ru.softlogic.hdw.dev.crd.TrackErrorException;
import ru.softlogic.input.model.advanced.actions.hdw.CardReaderHandler;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareException;

public class CardReaderHandlerImpl
implements CardReaderHandler {
    private CardReader cardReader;
    private CardStateListener listener;

    public CardReaderHandlerImpl(CardReader cardReader, CardStateListener listener) {
        if (cardReader == null) {
            throw new NullPointerException("CardReaderHandlerImpl");
        }
        if (listener == null) {
            throw new NullPointerException("CardStateListener");
        }
        this.cardReader = cardReader;
        this.listener = listener;
    }

    public void enable() throws HardwareException {
        this.cardReader.enableDevice(this.listener);
    }

    public void disable() throws HardwareException {
        this.cardReader.disableDevice();
    }

    public void eject() throws HardwareException {
        try {
            this.cardReader.ejectCard();
        }
        catch (CardReaderException ex) {
            throw new HardwareException((Throwable)ex);
        }
    }

    public void release() throws HardwareException {
        this.cardReader.release();
    }

    public String readTrack(int trackId) throws HardwareException {
        MagneticApi ma = this.cardReader.getMagneticApi();
        if (ma == null) {
            throw new HardwareException("Magnetic card is not support");
        }
        try {
            if (trackId == 1) {
                return ma.readTrack(1);
            }
            if (trackId == 2) {
                return ma.readTrack(2);
            }
            if (trackId == 3) {
                return ma.readTrack(3);
            }
            throw new HardwareException("Track number is wrong: " + trackId);
        }
        catch (CardReaderException ex) {
            throw new HardwareException((Throwable)ex);
        }
        catch (TrackErrorException ex) {
            throw new HardwareException((Throwable)ex);
        }
    }
}

