/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.advanced;

import i18n.B;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.OperationBalanceResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cards.v2.module.UserInterfaceEvent;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.input.model.advanced.actions.cardmodule.BalanceOperationResult;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardModuleRequestListener;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardModuleResponseData;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardOperation;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardOperationResult;
import ru.softlogic.io.utils.BU;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.DataProvider;
import ru.softlogic.module.card.DataProviderAdapter;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.advanced.AdvancedInputModule;
import ru.softlogic.module.utils.ExitDialogListener;

public class CardModuleService {
    private static final Logger log = Logger.getLogger((String)"pay");
    private final ApplicationContext context;
    private final Environment environment;
    private final AdvancedInputModule module;
    private final DataProvider dataProvider;
    private CardOperation operation;
    private CardModuleRequestListener listener;
    private CardModule cm;
    private LocalGuiListener guiListener;
    private boolean needRejectCard;
    private volatile boolean invokeOperation;

    public CardModuleService(ApplicationContext context, Environment environment, AdvancedInputModule module) {
        this.context = context;
        this.environment = environment;
        this.module = module;
        this.dataProvider = new DataProviderAdapter(){

            @Override
            public Map<String, Object> getData() {
                return CardModuleService.this.module.getDataContext();
            }
        };
    }

    public void setNeedRejectCard(boolean needRejectCard) {
        this.needRejectCard = needRejectCard;
    }

    public void setListener(CardModuleRequestListener listener) {
        this.listener = listener;
    }

    public void setOperation(CardOperation operation) {
        this.operation = operation;
    }

    public void run() {
        try {
            this.guiListener = new LocalGuiListener(this.context, this.environment, this.dataProvider);
            CardModule currentSession = CardModuleStore.getInstance().getCurrentSession();
            if (currentSession != null) {
                CardModuleStore.getInstance().setUserEventInterfaceListener(this.guiListener);
                this.cm = currentSession;
            } else {
                this.cm = CardModuleStore.getInstance().openSessionFromInputModule(this.guiListener);
            }
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            this.cm = null;
        }
        if (this.cm == null && this.listener != null) {
            this.listener.onError(null);
        } else {
            this.invokeOperation = true;
            if (this.operation == null || this.operation == CardOperation.OPERATION_BALANCE) {
                this.cm.balance((CardModuleResultListener)new LocalCardModuleResultListener());
            } else if (this.operation == CardOperation.OPERATION_STATEMENT) {
                this.cm.statement(null);
            }
        }
    }

    public boolean isNeedRejectCard() {
        return this.needRejectCard;
    }

    public void cancel() {
        CardModule tcm = CardModuleStore.getInstance().getCurrentSession();
        if (tcm != null) {
            try {
                if (this.invokeOperation) {
                    tcm.cancelOperation();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            CardModuleStore.getInstance().closeSessionSafe(true);
        }
    }

    private class LocalCardModuleResultListener
    implements CardModuleResultListener<OperationBalanceResult> {
        private String maskedPan;

        private LocalCardModuleResultListener() {
        }

        public void onError(CardModuleError cme, String message, CardInfo cardInfo) {
            CardModuleService.this.invokeOperation = false;
            Locale locale = CardModuleService.this.environment.getLocale();
            log.info((Object)(">>>onError " + cme + ", " + message + " CardInfo: " + cardInfo));
            UserAction.getInstance().update();
            if (cme == CardModuleError.ERROR_WRONG_PIN) {
                log.info((Object)"Wrong pin, show dialog");
                CardModuleService.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.pin-wrong", (Locale)locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        log.info((Object)"Wrong pin dialog closed. Start card operation");
                        CardModuleService.this.invokeOperation = true;
                        CardModuleService.this.cm.balance((CardModuleResultListener)new LocalCardModuleResultListener());
                        log.info((Object)"Done");
                    }
                });
                CardModuleService.this.context.showDialog((DialogInterface)dialog);
            } else if (cme == CardModuleError.ERROR_USER_CANCEL) {
                log.info((Object)"Operation canceled by user, show dialog");
                CardModuleService.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.statement.error1", (Locale)locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CardModuleService.this.module));
                CardModuleService.this.context.showDialog((DialogInterface)dialog);
            } else {
                CardModuleService.this.context.showWait(null);
                if (message == null || message.isEmpty()) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.statement.error2", (Locale)locale), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CardModuleService.this.module));
                    CardModuleService.this.context.showDialog((DialogInterface)dialog);
                } else {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Provider.card.statement.error3", (Locale)locale), B.get((String)message, (Locale)locale, (String)message)), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CardModuleService.this.module));
                    CardModuleService.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }

        public void onCardData(CardData cd) {
            this.maskedPan = cd.getPan();
        }

        public void onResult(OperationBalanceResult res, CardInfo ci) {
            if (CardModuleService.this.listener != null) {
                String value = Float.toString((float)res.getBalance() / 100.0f);
                String currencyCode = res.getCurrency().getAlphaCode();
                CardModuleResponseData cardModuleResponseData = new CardModuleResponseData(this.maskedPan, BU.toHexString((byte[])ci.getPanHash().getSha1()), ci.getExpirationDate(), (CardOperationResult)new BalanceOperationResult(value + " " + currencyCode));
                CardModuleService.this.listener.onResult(cardModuleResponseData);
            }
            CardModuleService.this.context.showWait(null);
            if (CardModuleService.this.needRejectCard) {
                CardModuleService.this.cm.closeSession(true);
            }
        }
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        private Runnable closedListener;

        public LocalGuiListener(ApplicationContext context, Environment environment, DataProvider dataProvider) {
            super(context, environment, log, dataProvider);
        }

        public void setClosedListener(Runnable closedListener) {
            this.closedListener = closedListener;
        }

        @Override
        public void onEvent(UserInterfaceEvent uie, Runnable r) {
            if (uie == UserInterfaceEvent.CARD_CAPTURED_BY_HOST || uie == UserInterfaceEvent.CARD_CAPTURED_BY_TIMEOUT || uie == UserInterfaceEvent.CARD_CAPTURE_FAIL) {
                CardModuleService.this.guiListener.setClosedListener(new Runnable(){

                    @Override
                    public void run() {
                        if (CardModuleService.this.listener != null) {
                            CardModuleService.this.listener.onError(null);
                        }
                    }
                });
            }
            super.onEvent(uie, r);
        }

        @Override
        public synchronized void _onClosed() {
            Runnable r = this.closedListener;
            if (r != null) {
                r.run();
                this.closedListener = null;
            } else {
                CardModuleService.this.module.cancel(null);
            }
        }
    }
}

