/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.advanced;

import java.util.Date;
import java.util.Set;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.DeviceSummary;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.input.model.advanced.AdvancedCommissionCalculator;
import ru.softlogic.input.model.advanced.Rounding;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;

public class AdvCommissionCalculatorImpl
implements AdvancedCommissionCalculator {
    private Environment env;

    public AdvCommissionCalculatorImpl(Environment env) {
        this.env = env;
    }

    public Double calculateIncomeSum(Double outcome, Rounding rounding) {
        CashUnit minUnits;
        Sum sum = new Sum((int)(outcome * 100.0));
        Sum summ = null;
        Service service = this.env.getMenuItem().getService();
        if (service.isGroupPaymentDividedCommission() && service.getDivideSum() != null && !service.getDivideSum().isEmpty()) {
            Sum min = service.getMinSum();
            if (min == null) {
                min = new Sum();
            }
            if (sum.compareTo(min) < 0) {
                min = sum;
            }
            summ = PayDetector.calculateRequierSum(null, sum, this.env.getMenuItem().getCommission(), service, this.env.getDateOfStartPayment(), this.env.getMenuItem().isIgnoreMinMaxCommission(), min, null);
        } else {
            summ = CommissionCalculator.calculate((Sum)sum, (Commission)this.env.getMenuItem().getCommission(), (Commission)this.env.getMenuItem().getService().getMinComm(), (Commission)this.env.getMenuItem().getService().getCommission(), (Date)new Date(), (String)"CASH", (boolean)false, null, (boolean)false);
        }
        int calcValue = summ != null ? summ.getBasicSum() : 0;
        double result = calcValue;
        if (rounding == Rounding.INTEGER) {
            result = AdvCommissionCalculatorImpl.roundUp(calcValue, 100);
        } else if (rounding == Rounding.NOMINAL && (minUnits = this.getMinNominal()) != null) {
            int minNomValue = minUnits.getNominal().getBasicSum();
            result = AdvCommissionCalculatorImpl.roundUp(calcValue, minNomValue);
        }
        return result / 100.0;
    }

    private static int roundUp(int sum, int roundValue) {
        if (sum % roundValue != 0) {
            return sum + roundValue - sum % roundValue;
        }
        return sum;
    }

    private CashUnit getMinNominal() {
        Set<CashUnit> notes;
        CashUnit min = null;
        Set<CashUnit> coins = this.env.getAllowedCoins();
        if (DeviceSummary.getCoinAcceptor() != null && coins != null) {
            for (CashUnit cu : coins) {
                if (min != null && min.getNominal().compareTo(cu.getNominal()) <= 0) continue;
                min = cu;
            }
        }
        if ((notes = this.env.getAllowedNotes()) != null) {
            for (CashUnit cu : notes) {
                if (min != null && min.getNominal().compareTo(cu.getNominal()) <= 0) continue;
                min = cu;
            }
        }
        if (min == null) {
            min = CashFactory.getDefaultInstance().getCashUnits()[0];
        }
        return min;
    }
}

