/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import i18n.B;
import java.awt.EventQueue;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.gui.GuiContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.updater.UpdateOptions;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.updater.HttpUpdateStore;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.UpdateSystem;

public class NetworkUpdater {
    private GuiContext context;
    private InputModule inputModule;
    private Locale locale;
    private Logger log;
    private JProgressBar progressBar;

    public NetworkUpdater(InputModuleContext context, InputModule inputModule, Locale locale, JProgressBar progressBar) {
        this.context = context;
        this.inputModule = inputModule;
        this.locale = locale;
        this.progressBar = progressBar;
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
    }

    public void checkUpdate() {
        try {
            Point point = ReferenceManager.getInstance().getPoint();
            UpdateOptions uo = ReferenceManager.getInstance().getUpdateOptions();
            if (point == null || uo == null) {
                this.showDialog("Provider.admin.update.reference-error");
                return;
            }
            if (uo.getUpdateUrl() == null || uo.getUpdateUrl().isEmpty()) {
                this.showDialog("Provider.admin.update.url-error");
                return;
            }
            UpdateRequest ur = new UpdateRequest((UpdateStore)new HttpUpdateStore(this.updateUrl(uo.getUpdateUrl()), uo.getUpdateLogin(), uo.getUpdatePassword(), point.getId(), AppDefaults.getInstance().getIntegerValue("system.update.socket.timeout")), (UpdateControl)new GuiUpdateControl(), new File(PathUtils.getAppHome()), new File(PathUtils.getAppHome(), "/update/"), (StateListener)new GuiStateListener());
            if (!UpdateSystem.getUpdateHandler().addUpdateRequest(ur)) {
                this.showDialog("Provider.admin.update.request.reject");
            } else {
                this.progressBar.setString(B.get((String)"Provider.admin.update.check", (Locale)this.locale));
                this.progressBar.setIndeterminate(true);
            }
        }
        catch (Exception ex) {
            this.showDialogMsg(ex.getMessage());
        }
    }

    private String updateUrl(String url) {
        String version = "v5";
        String v = SystemProp.getUpdateVersion();
        if (v != null && !v.isEmpty()) {
            version = v;
        }
        if (OsDetector.current() == 1) {
            return url + "/" + version + "/linux/";
        }
        return url + "/" + version + "/windows/";
    }

    private void showDialog(final String messageId) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)messageId, (Locale)NetworkUpdater.this.locale), 6, DC.cases((int)8, (Locale)NetworkUpdater.this.locale, (Object[])new Object[0]), UserCase.Ok);
                NetworkUpdater.this.context.showDialog((DialogInterface)dialog);
            }
        });
    }

    private void showDialogMsg(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, message, 6, DC.cases((int)8, (Locale)NetworkUpdater.this.locale, (Object[])new Object[0]), UserCase.Ok);
                NetworkUpdater.this.context.showDialog((DialogInterface)dialog);
            }
        });
    }

    private void stopProgress() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkUpdater.this.progressBar.setString("");
                NetworkUpdater.this.progressBar.setValue(0);
                NetworkUpdater.this.progressBar.setIndeterminate(false);
            }
        });
    }

    private class GuiStateListener
    implements StateListener {
        private GuiStateListener() {
        }

        public void onStart() {
            NetworkUpdater.this.log.info((Object)"Start update");
        }

        public void onSkip() {
            NetworkUpdater.this.stopProgress();
            NetworkUpdater.this.log.info((Object)"No update avaliable");
            NetworkUpdater.this.showDialog("Provider.admin.update.skip");
        }

        public void onConfirm(UpdateSize updateSize) {
            NetworkUpdater.this.stopProgress();
            NetworkUpdater.this.log.info((Object)"Update confirmed");
        }

        public void onSuccess(UpdateMetric updateMetric) {
            NetworkUpdater.this.stopProgress();
            NetworkUpdater.this.log.info((Object)("Update success: " + updateMetric));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.admin.update.success", (Locale)NetworkUpdater.this.locale), 20, DC.cases((int)8, (Locale)NetworkUpdater.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(NetworkUpdater.this.inputModule));
                    NetworkUpdater.this.context.showDialog((DialogInterface)dialog);
                }
            });
        }

        public void onCancel() {
            NetworkUpdater.this.stopProgress();
            NetworkUpdater.this.log.info((Object)"Update cancel");
        }

        public void onLocalError(Exception ex, UpdateMetric updateMetric) {
            NetworkUpdater.this.stopProgress();
            NetworkUpdater.this.log.info((Object)"Local error", (Throwable)ex);
            NetworkUpdater.this.showDialogMsg(MessageFormat.format(B.get((String)"Provider.admin.update.error.local", (Locale)NetworkUpdater.this.locale), ex.getMessage()));
        }

        public void onGlobalError(Exception ex) {
            NetworkUpdater.this.stopProgress();
            NetworkUpdater.this.log.info((Object)"Global error", (Throwable)ex);
            NetworkUpdater.this.showDialogMsg(MessageFormat.format(B.get((String)"Provider.admin.update.error.global", (Locale)NetworkUpdater.this.locale), ex.getMessage()));
        }

        public void onProgress(final String fileName, final int total, final int progress) {
            UserAction.getInstance().update();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkUpdater.this.progressBar.setString(fileName);
                    NetworkUpdater.this.progressBar.setMaximum(total);
                    NetworkUpdater.this.progressBar.setValue(progress);
                }
            });
        }
    }

    private class GuiUpdateControl
    implements UpdateControl {
        private UserCase confirmUpdate;

        private GuiUpdateControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean confirmUpdate(final int size) {
            NetworkUpdater.this.log.info((Object)("Update size=" + size + ", needs to confirm"));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Provider.admin.update.confirm"), String.format("%.2f", (double)size * 1.0 / 1024.0)), 20, DC.cases((int)2, (Locale)NetworkUpdater.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void dialogClosed(UserCase userCase) {
                            NetworkUpdater.this.log.info((Object)("Selected case: " + userCase));
                            GuiUpdateControl.this.confirmUpdate = userCase;
                            GuiUpdateControl guiUpdateControl = GuiUpdateControl.this;
                            synchronized (guiUpdateControl) {
                                GuiUpdateControl.this.notifyAll();
                            }
                        }
                    });
                    NetworkUpdater.this.context.showDialog((DialogInterface)dialog);
                }
            });
            try {
                GuiUpdateControl guiUpdateControl = this;
                synchronized (guiUpdateControl) {
                    this.wait();
                }
                return this.confirmUpdate == UserCase.Ok;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        public boolean confirmRetry(int errorCount, Exception ex) {
            return errorCount < 5;
        }

        public boolean confirmRestart() {
            return true;
        }
    }
}

