/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.ending;

import i18n.B;
import java.awt.EventQueue;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.gui.adv.AdvDescription;
import ru.softlogic.gui.adv.AdvExtractor;
import ru.softlogic.gui.adv.ContentType;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.BaseAdvtCustomPanel;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.advanced.AdvDialog;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPopupDialog;
import ru.softlogic.gui.utils.ImageStore;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ending.BaseEndingModule;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.print.BanneredPrintModule;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.service.comission.SumResult;

public class SimpleEndingModule
extends BaseEndingModule {
    private final Logger log = LoggerId.PAY;
    private Environment environment;

    public SimpleEndingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    public void _end(Environment environment) {
        this.environment = environment;
        Pack pack = Session.getInstance().getPack();
        String dealerName = environment.getDealer().getName();
        String support = environment.getDealer().getSupport();
        String name = environment.getPaymentSystem().getName();
        Locale locale = environment.getLocale();
        boolean isPayToProcessDialog = false;
        String message = "";
        Image image = null;
        ImageIcon gifImage = null;
        String skinCode = ComponentFactory.getInstance().getSkinCode();
        ImageStore imageStore = ComponentFactory.getInstance().getImageStore();
        int srvId = pack.getService() == null ? 0 : pack.getService().getId();
        AdvDescription desc = AdvExtractor.getInstance().extract(skinCode, "CLOSE", Integer.valueOf(srvId));
        if (desc != null && desc.getContentType() == ContentType.Image) {
            String url = desc.getBanner().getUrl();
            if (url != null && url.endsWith(".gif")) {
                gifImage = imageStore.getGIFBannerBySize(url, null, null);
            } else {
                image = imageStore.getBannerBySize(url, null, null);
            }
        }
        if (!(pack.isCancel() || image == null && gifImage == null)) {
            EventQueue.invokeLater(new BannerDialogRunner(image, gifImage, desc.getBanner().getIdReferService()));
            AppEnvironment.getInstance().addAdvEvent(desc.getBanner().getId(), AdvStatisticType.BannerShow);
        } else {
            String changeSum;
            SumResult sumResult = pack.getSumResult();
            String string = changeSum = sumResult.getChange() == null || sumResult.getChange().isEmpty() ? "" : String.format(B.get((String)"Module.ending.sumformat", (Locale)locale, (String)"%s"), sumResult.getChange());
            if (pack.isCancel()) {
                this.log.info((Object)"\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
                if (support != null && !support.isEmpty()) {
                    switch (pack.getPaybackType()) {
                        case 3: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.service", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        case 6: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.mobile", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        case 8: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.keeper", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        case 5: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.to-save-service", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        case 2: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.cash", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        case 4: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.deferred", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        case 7: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.cardRevers", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        default: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                    }
                } else {
                    switch (pack.getPaybackType()) {
                        case 3: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.service.general", (Locale)locale), String.format(B.get((String)"Module.ending.sumformat", (Locale)locale, (String)"%s"), changeSum));
                            break;
                        }
                        case 6: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.mobile.general", (Locale)locale), String.format(B.get((String)"Module.ending.sumformat", (Locale)locale, (String)"%s"), changeSum));
                            break;
                        }
                        case 8: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.keeper.general", (Locale)locale), String.format(B.get((String)"Module.ending.sumformat", (Locale)locale, (String)"%s"), changeSum));
                            break;
                        }
                        case 5: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.to-save-service.general", (Locale)locale), String.format(B.get((String)"Module.ending.sumformat", (Locale)locale, (String)"%s"), changeSum));
                            break;
                        }
                        case 2: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.cash.general", (Locale)locale), support, changeSum, dealerName);
                            break;
                        }
                        case 4: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.deferred.general", (Locale)locale), String.format(B.get((String)"Module.ending.sumformat", (Locale)locale, (String)"%s"), changeSum));
                            break;
                        }
                        default: {
                            message = MessageFormat.format(B.get((String)"Provider.payment.cancel.general", (Locale)locale), String.format(B.get((String)"Module.ending.sumformat", (Locale)locale, (String)"%s"), changeSum));
                            break;
                        }
                    }
                }
            } else if (pack.isUnknownProcessResult()) {
                message = !pack.getSumResult().getChange().isEmpty() ? (support != null && !support.isEmpty() ? MessageFormat.format(B.get((String)"Provider.payment.unknown.change", (Locale)locale), support, changeSum, dealerName) : MessageFormat.format(B.get((String)"Provider.payment.unknown.change.general", (Locale)locale), changeSum)) : (support != null && !support.isEmpty() ? MessageFormat.format(B.get((String)"Provider.payment.unknown", (Locale)locale), support, dealerName) : B.get((String)"Provider.payment.unknown.general", (Locale)locale));
            } else {
                isPayToProcessDialog = true;
                if (!pack.getSumResult().getChange().isEmpty()) {
                    if (name != null && !name.isEmpty()) {
                        switch (pack.getPaybackType()) {
                            case 3: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.service", (Locale)locale), name, changeSum, dealerName, support);
                                break;
                            }
                            case 6: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.mobile", (Locale)locale), name, changeSum, dealerName, support);
                                break;
                            }
                            case 8: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.keeper", (Locale)locale), name, changeSum, dealerName, support);
                                break;
                            }
                            case 5: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.to-save-service", (Locale)locale), name, changeSum, dealerName, support);
                                break;
                            }
                            case 2: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.cash", (Locale)locale), support, changeSum, dealerName);
                                break;
                            }
                            case 4: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.deferred", (Locale)locale), name, changeSum, dealerName, support);
                                break;
                            }
                            default: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.cbc", (Locale)locale), name, changeSum, dealerName, support);
                                break;
                            }
                        }
                    } else {
                        switch (pack.getPaybackType()) {
                            case 3: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.service.general", (Locale)locale), changeSum, support);
                                break;
                            }
                            case 6: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.mobile.general", (Locale)locale), changeSum, support);
                                break;
                            }
                            case 8: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.keeper.general", (Locale)locale), changeSum, support);
                                break;
                            }
                            case 5: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.to-save-service.general", (Locale)locale), changeSum, support);
                                break;
                            }
                            case 2: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.cash.general", (Locale)locale), support, changeSum, dealerName);
                                break;
                            }
                            case 4: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.deferred.general", (Locale)locale), changeSum, support);
                                break;
                            }
                            default: {
                                message = MessageFormat.format(B.get((String)"Provider.payment.complete.cbc.general", (Locale)locale), changeSum, support);
                                break;
                            }
                        }
                    }
                } else {
                    message = pack.isUndrawnFundsSum() ? B.get((String)"Provider.payment.complete.undrawnFundsSum", (Locale)locale, (String)support) : (name != null && !name.isEmpty() ? MessageFormat.format(B.get((String)"Provider.payment.complete", (Locale)locale), name, dealerName, support) : B.get((String)"Provider.payment.complete.general", (Locale)locale, (String)support));
                }
            }
            if (environment.getPrintOperation() != null && (environment.getPrintOperation().getFlags() & 0x200) > 0) {
                message = message + B.get((String)"Provider.payment.sms-check", (Locale)locale);
            }
            gifImage = null;
            image = null;
            Integer idReferServ = null;
            desc = AdvExtractor.getInstance().extract(skinCode, "ENDING", Integer.valueOf(srvId));
            if (desc != null && desc.getContentType() == ContentType.Image) {
                String url = desc.getBanner().getUrl();
                if (url != null && url.endsWith(".gif")) {
                    gifImage = imageStore.getGIFBannerBySize(url, null, null);
                } else {
                    image = imageStore.getBannerBySize(url, null, null);
                }
                idReferServ = desc.getBanner().getIdReferService();
            }
            if (image != null || gifImage != null) {
                EventQueue.invokeLater(new AdvDialogRunner(message, idReferServ, image, gifImage));
            } else if (environment.getPrintModule() instanceof BanneredPrintModule && isPayToProcessDialog && pack.getCbc() == null) {
                environment.getReinitModule().process(environment);
            } else {
                EventQueue.invokeLater(new DialogRunner(message));
            }
        }
    }

    private class AdvDialogRunner
    implements Runnable {
        private final String message;
        private final Integer idReferService;
        private final Image image;
        private final ImageIcon gifImage;

        public AdvDialogRunner(String message, Integer idReferService, Image image, ImageIcon gifImage) {
            this.message = message;
            this.idReferService = idReferService;
            this.image = image;
            this.gifImage = gifImage;
        }

        @Override
        public void run() {
            MediaPlayer.getInstance().play("complete.mp3");
            SimpleEndingModule.this.log.info((Object)"Show a grateful dialog with advt");
            boolean showMenuButton = AppDefaults.getInstance().getBooleanProperty("Module.ending.button.showMenu", false);
            int cases = showMenuButton ? 29 : 1;
            BaseAdvtCustomPanel advtCustomPanel = (BaseAdvtCustomPanel)ComponentFactory.getInstance().createDialogPanel("advt");
            advtCustomPanel.init(DialogType.Info, this.message, DC.cases((int)(this.idReferService != null ? 34 : cases)), this.image, this.gifImage);
            CustomPopupDialog cpd = new CustomPopupDialog((CustomPanel)advtCustomPanel, 10, (Object)UserCase.Ok, true);
            cpd.addListener(new CustomDialogListener(){

                public void onClose(Object type) {
                    SimpleEndingModule.this.log.info((Object)("UserCase=" + type));
                    SimpleEndingModule.this.log.info((Object)"Dialog closed");
                    if (type instanceof UserCase && (UserCase)type == UserCase.Cancel && AdvDialogRunner.this.idReferService != null) {
                        SimpleEndingModule.this.log.info((Object)"Need to redirect");
                        AdvDialogRunner.this._redirect(AdvDialogRunner.this.idReferService);
                    } else {
                        SimpleEndingModule.this.environment.getReinitModule().process(SimpleEndingModule.this.environment);
                    }
                }
            });
            SimpleEndingModule.this.context.showDialog((DialogInterface)cpd);
        }

        private void _redirect(int serviceId) {
            SimpleEndingModule.this.log.info((Object)("Requested redirect to service: " + serviceId));
            if (SimpleEndingModule.this.environment != null && SimpleEndingModule.this.environment.getRedirectProxy() != null) {
                SimpleEndingModule.this.environment.getRedirectProxy().redirect(serviceId, null);
            } else {
                MenuItem mi = null;
                try {
                    MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId, AppDefaults.getInstance().getBooleanProperty("Module.input.redirect.childs", true));
                    MenuUtils.processMenu((MenuVisitor)mbsiv);
                    mi = mbsiv.getMenuItem();
                }
                catch (Exception e) {
                    SimpleEndingModule.this.log.error((Object)e, (Throwable)e);
                }
                if (mi != null) {
                    SimpleEndingModule.this.log.info((Object)("Found service: " + mi.getService().getName()));
                    Keeper k = Session.getInstance().getPack().getKeeper();
                    SimpleEndingModule.this.log.info((Object)("Redirect with keeper: " + k));
                    AppEnvironment.getInstance().open(mi, null);
                } else {
                    ProblemNotifier.getDefaultNotifier().onProblem("Redirect to service " + serviceId + " not found");
                    SimpleEndingModule.this.log.info((Object)"Service not found, show dialog");
                    Locale locale = SimpleEndingModule.this.environment != null ? SimpleEndingModule.this.environment.getLocale() : null;
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.redirect.notfound", (Locale)locale), 10, DC.cases((int)8, (Locale)locale, (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            SimpleEndingModule.this.context.toMainMenu();
                        }
                    });
                    SimpleEndingModule.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }
    }

    private class BannerDialogRunner
    implements Runnable {
        private final Image image;
        private final ImageIcon gifImage;
        private final Integer targetId;

        public BannerDialogRunner(Image image, ImageIcon gifImage, Integer targetId) {
            this.image = image;
            this.gifImage = gifImage;
            this.targetId = targetId;
        }

        @Override
        public void run() {
            MediaPlayer.getInstance().play("complete.mp3");
            SimpleEndingModule.this.log.info((Object)"Show a grateful-banner dialog");
            AdvDialog advDialog = new AdvDialog(UserCase.Cancel);
            advDialog.setComplete(false);
            if (this.image != null) {
                advDialog.getDialogPanel().showBanner(this.image);
            } else {
                advDialog.getDialogPanel().showBanner(this.gifImage);
            }
            advDialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        SimpleEndingModule.this.environment.setTargetServiceId(BannerDialogRunner.this.targetId);
                    }
                    SimpleEndingModule.this.log.info((Object)"Dialog closed");
                    SimpleEndingModule.this.environment.getReinitModule().process(SimpleEndingModule.this.environment);
                }
            });
            SimpleEndingModule.this.context.showDialog((DialogInterface)advDialog);
        }
    }

    private class DialogRunner
    implements Runnable {
        private final String message;

        public DialogRunner(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            MediaPlayer.getInstance().play("complete.mp3");
            SimpleEndingModule.this.log.info((Object)"Show a grateful dialog");
            boolean showMenuButton = AppDefaults.getInstance().getBooleanProperty("Module.ending.button.showMenu", false);
            DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Info, this.message, 10, DC.cases((int)(showMenuButton ? 29 : 1)), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    SimpleEndingModule.this.log.info((Object)"Dialog closed");
                    SimpleEndingModule.this.environment.getReinitModule().process(SimpleEndingModule.this.environment);
                }
            });
            SimpleEndingModule.this.context.showDialog((DialogInterface)dialog);
        }
    }
}

