/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module;

import i18n.B;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.app.session.CashBackCard;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.PrefillItem;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.module.Module;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.advanced.CardProcessorStore;
import ru.softlogic.module.reinit.redirect.Rule;
import ru.softlogic.module.reinit.redirect.RulesParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.PinCodeGenerator;

public class ModuleHelper {
    public static final String DIFF_SUM_KEY = "diff-sum";
    private static final Logger log = Logger.getLogger((String)"pay");

    public static Locale getDefaultLocale() {
        try {
            PointOptions po = ReferenceManager.getInstance().getPointOptions();
            if (po != null) {
                return new Locale(po.getLanguage(), Locale.getDefault().getCountry());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Locale.getDefault();
    }

    public static Dealer getDealer() {
        try {
            Dealer dealer = ReferenceManager.getInstance().getDealer();
            if (dealer != null) {
                return dealer;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Dealer("", "", "", "", "");
    }

    public static Point getPoint() {
        try {
            Point point = ReferenceManager.getInstance().getPoint();
            if (point != null) {
                return point;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Point(0, "", "");
    }

    public static PaymentSystem getPaymentSystem() {
        try {
            PaymentSystem system = ReferenceManager.getInstance().getPaymentSystem();
            if (system != null) {
                return system;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new PaymentSystem("", "");
    }

    public static boolean isOnlineProcessing(Pack pack) {
        if (pack == null) {
            return false;
        }
        ProcessingType processingType = pack.getService().getProcessingType();
        return (processingType == ProcessingType.Online || processingType == ProcessingType.HalfOnline) && !pack.getSumResult().getOut().isEmpty();
    }

    public static boolean isOnlineProcessingIgnoreOutcome(Pack pack) {
        if (pack == null) {
            return false;
        }
        Service s = pack.getService();
        return s.getProcessingType() == ProcessingType.Online || s.getProcessingType() == ProcessingType.HalfOnline;
    }

    public static boolean isDeferredPayout(Pack pack) {
        return ModuleHelper.isOnlineProcessing(pack);
    }

    public static boolean isPINPayoutOnly(Pack pack) {
        return pack != null && pack.getService() != null && (pack.getService().getChangeType() | 1) == 1;
    }

    public static void prefillStore(Map<String, PrefillItem> items, Environment env, Map<String, Object> store) {
        if (items == null || items.isEmpty()) {
            return;
        }
        if (store == null) {
            return;
        }
        for (String key : items.keySet()) {
            PrefillItem rule = items.get(key);
            try {
                String value = PropertyUtils.getProperty((Object)env, (String)key).toString();
                log.info((Object)("Add value: " + key + "->" + rule + ", result: " + value));
                store.put(rule.getKey(), new InputElement(rule.getKey(), rule.getTitle(), value));
            }
            catch (Exception ex) {
                ProblemNotifier.getDefaultNotifier().onProblem("Prefill error: " + rule + "->" + key + ", result: " + ex.getMessage());
                log.error((Object)"Prefill error", (Throwable)ex);
            }
        }
    }

    public static void fillStore(Map<String, Object> items, Map<String, Object> store) {
        if (items == null || items.isEmpty()) {
            return;
        }
        if (store == null) {
            return;
        }
        for (String key : items.keySet()) {
            if (items.get(key) != null && items.get(key) instanceof String) {
                store.put(key, new InputElement(key, "", (String)items.get(key)));
                continue;
            }
            if (items.get(key) == null) continue;
            store.put(key, items.get(key));
        }
    }

    public static Map<String, Object> getPaymentParams(Pack pack, String to) {
        if (pack == null || pack.getPayments() == null || pack.getPayments().isEmpty()) {
            return null;
        }
        try {
            List<Rule> rules = RulesParser.getRules(new File(PathUtils.getAppHome() + "/resources/reinit/rules.xml"), "" + pack.getService().getId(), to);
            Map data = ((Payment)pack.getPayments().get(0)).getData();
            if (rules != null && data != null) {
                HashMap<String, Object> params = new HashMap<String, Object>(data);
                for (Rule r : rules) {
                    r.execute(params);
                }
                return params;
            }
            return null;
        }
        catch (ParseException ex) {
            log.error((Object)ex);
            return null;
        }
    }

    public static String getMessage(String key, Locale locale, String defaultValue) {
        String str = B.get((String)key, (Locale)locale);
        if (str.contains(key)) {
            return defaultValue;
        }
        return str;
    }

    public static void cancelPack(Pack pack) {
        SumResult sumResult = pack.getSumResult();
        sumResult.setChange(sumResult.getIncome());
        sumResult.setCommission(new Sum());
        sumResult.setOut(new Sum());
        sumResult.setOutProv(new Sum());
        if (pack.getPayments() != null) {
            for (Payment p : pack.getPayments()) {
                p.setSumOut(new Sum());
            }
        }
        pack.setSumResult(sumResult);
        pack.setCancel(true);
        if (ModuleHelper.toSavePayout(pack)) {
            pack.setPaybackType(5);
        } else {
            pack.setPaybackType(1);
            pack.setCbc(new CashBackCard(PinCodeGenerator.generate(), pack.getSumResult().getChange()));
        }
    }

    public static Map<String, Object> clearSum(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>(data);
        d.remove("#sum");
        return d;
    }

    public static void showDiffSumScreen(ScreenListener listener, CommonScreen cs, Environment env, ApplicationContext context, Sum sum, Sum requireSum, Module module) throws InitException {
        if (requireSum == null) {
            requireSum = new Sum();
        }
        UniScreenDescription isd = new UniScreenDescription();
        isd.setTitle(B.get((String)"Provider.screen.sum.diff.title", (Locale)env.getLocale()));
        isd.setDecor(DIFF_SUM_KEY);
        isd.setId("diff");
        NumericField nf = new NumericField();
        nf.setId(DIFF_SUM_KEY);
        if (AppDefaults.getInstance().getBooleanProperty("Payment.sum.diff.allow-decimals", false)) {
            nf.setKeyboard(new Keyboard(KeyboardType.Digital, Character.valueOf('.')));
        } else {
            nf.setKeyboard(new Keyboard(KeyboardType.Digital));
        }
        nf.setDecimalCount(2);
        nf.setUnitCount(5);
        nf.setDefaultValue(null);
        Sum maxSum = sum;
        Sum minSum = requireSum;
        if (env.getMenuItem().getService().getMinSum() != null && minSum.compareTo(env.getMenuItem().getService().getMinSum()) < 0) {
            minSum = env.getMenuItem().getService().getMinSum();
        }
        if (env.getMenuItem().getService().getMaxSum() != null && maxSum.compareTo(env.getMenuItem().getService().getMaxSum()) > 0) {
            maxSum = env.getMenuItem().getService().getMaxSum();
        }
        if (minSum.compareTo(maxSum) > 0) {
            maxSum = minSum;
        }
        if (maxSum.getBasicSum() % 100 == 0) {
            nf.setDefaultValue(String.valueOf(maxSum.getBasicSum() / 100));
        } else {
            nf.setDefaultValue(String.valueOf(maxSum.getSum()));
        }
        nf.setHelp(MessageFormat.format(B.get((String)"Provider.screen.sum.diff.help", (Locale)env.getLocale()), sum, maxSum, minSum));
        nf.setValidator((Validator)new NumericRangeValidator(Collections.singletonList(new Range((float)minSum.getSum(), (float)maxSum.getSum()))));
        isd.setSequence(new FieldSequence(Collections.singletonList(nf)));
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Prev", new ButtonInit(null));
        buttons.put("Next", new ButtonInit(null));
        isd.setButtons(buttons);
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            data.put("id1", ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().get("id1"));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        cs.setListener(listener);
        cs.init(ScreenHelper.processBack((ScreenDescription)isd, (boolean)true, (boolean)true), InitModuleHelper.buildScreenInit(env, data));
        context.showScreen(new ContentScreenAdapterKbr(cs));
    }

    public static boolean toSavePayout(Pack pack) {
        return pack != null && ModuleHelper.toSavePayout(pack.getService());
    }

    public static boolean toSavePayout(Service s) {
        return s != null && (s.getChangeType() & 0x10) > 0;
    }

    public static boolean toKeeperPayout(Pack pack) {
        return pack != null && ModuleHelper.toKeeperPayout(pack.getService());
    }

    public static boolean toKeeperPayout(Service s) {
        return s != null && (s.getChangeType() & 0x20) > 0;
    }

    public static void invoke(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    public static String formatKeeper(Keeper k) {
        if (k == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry cu : k.getCashUnits().entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(((CashUnit)cu.getKey()).getNominal()).append("=>").append(cu.getValue());
        }
        return sb.toString();
    }

    public static boolean isCardRevert() {
        return AppDefaults.getInstance().getBooleanProperty("Module.processing.revertCard", false);
    }

    public static void clearCardData(Payment p) {
        if (p != null && p.getData() != null) {
            p.getData().remove("auth");
            p.getData().remove("rrn");
            p.getData().remove("curr");
            p.getData().remove("merchant");
            p.getData().remove("stan");
            p.getData().remove("terminal");
            p.getData().remove("is-cashless");
            p.getData().remove("account-client");
        }
    }

    public static void clearNotPrinted(Map<String, InputElement> data, Map<String, String> form, Map<String, String> view, Map<String, String> title) {
        Iterator<Map.Entry<String, InputElement>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            InputElement ie = it.next().getValue();
            if (!ie.hasFlag(2)) continue;
            it.remove();
            form.remove(ie.getKey());
            view.remove(ie.getKey());
            title.remove(ie.getKey());
        }
    }

    public static void releaseDevices() {
        try {
            CardModule tcm;
            CardReader cr = CardProcessorStore.getInstance().getCardReader();
            if (cr != null && cr.isEnabled()) {
                ModuleHelper.releaseCardreder(cr);
            }
            if ((tcm = CardModuleStore.getInstance().getCurrentSession()) != null) {
                ModuleHelper.releaseCardModule(tcm);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseCardreder(CardReader cr) {
        try {
            cr.ejectCard();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            cr.disableDevice();
            cr.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseCardModule(CardModule tcm) {
        try {
            tcm.cancelOperation();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CardModuleStore.getInstance().closeSessionSafe(true);
    }

    public static FraudControlRule getFraudControlRule(int serviceId) {
        FraudControlRule pointFcr = null;
        try {
            List fcrs = ReferenceManager.getInstance().getFraudControlRules();
            if (fcrs == null) {
                return null;
            }
            for (FraudControlRule fcr : fcrs) {
                if (fcr.getIdService() == null) {
                    pointFcr = fcr;
                    continue;
                }
                if (fcr.getIdService().intValue() != serviceId) continue;
                return fcr;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pointFcr;
    }

    public static boolean redirect(int serviceId, Map<String, Object> params, Environment env, InputModuleContext context) {
        try {
            log.info((Object)("Requested redirect to service: " + serviceId));
            if (env.getRedirectProxy() != null) {
                env.getRedirectProxy().redirect(serviceId, params);
                return true;
            }
            MenuItem mi = null;
            try {
                MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId, AppDefaults.getInstance().getBooleanProperty("Module.input.redirect.childs", true));
                MenuUtils.processMenu((MenuVisitor)mbsiv);
                mi = mbsiv.getMenuItem();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            if (mi != null) {
                log.info((Object)("Found service: " + mi.getService().getName()));
                Keeper k = Session.getInstance().getPack().getKeeper();
                log.info((Object)("Redirect with keeper: " + k));
                AppEnvironment.getInstance().open(mi, params);
                return true;
            }
            ProblemNotifier.getDefaultNotifier().onProblem("Redirect to service " + serviceId + " not found");
            log.info((Object)"Service not found, show dialog");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.redirect.notfound", (Locale)env.getLocale()), 10, DC.cases((int)8, (Locale)env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            context.showDialog((DialogInterface)dialog);
            return false;
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            log.error((Object)Arrays.toString(ex.getStackTrace()), (Throwable)ex);
            return false;
        }
    }

    public static void showModuleErrorDialog(ApplicationContext context, int timeout, String message, DisplayedUserCase[] cases) {
        DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, message, timeout, cases, UserCase.Ok);
        context.showDialog((DialogInterface)dlg);
    }
}

