/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash.manager;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.acceptor.CashAcceptor;
import ru.softlogic.cash.acceptor.ManagedCashAcceptor;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.SessionCashStorage;
import ru.softlogic.cash.manager.observer.FraudListener;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.manager.observer.UpdateFirmwareListener;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticListener;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;

public class BaseCashManager
extends CashManager {
    private Set<CashAcceptor> acceptors;
    private Keeper keeper;
    private SessionCashStorageImpl cashStorage;
    private boolean enable;
    private Set<CashUnit> cashUnits;
    private Set<CashUnit> coinUnits;
    private Sum max;
    private Sum firstMinNominal;
    private Map<CashAcceptor, Boolean> connErrors;
    private CashBox cashBox;
    private CashBox coinBox;
    private Logger log;
    private KeeperObserver observer;
    private int deviceMask;
    private final Object observerSync = new Object();
    private LocalFraudController fraudcontroller;
    private FraudListener currentFraudListener;
    private boolean notTakeBills;
    private int fraudOfflineErrorCount;
    private PermitListener listener;

    public BaseCashManager(CashBox cashBox, CashBox coinBox, PermitListener listener) {
        if (cashBox == null) {
            throw new NullPointerException("CashBox");
        }
        if (coinBox == null) {
            throw new NullPointerException("CoinBox");
        }
        this.cashBox = cashBox;
        this.coinBox = coinBox;
        this.listener = listener;
        this.acceptors = new HashSet<CashAcceptor>();
        this.cashStorage = new SessionCashStorageImpl();
        this.connErrors = Collections.synchronizedMap(new HashMap());
        this.log = Logger.getLogger((String)"cashin-observer");
        this.log.setAdditivity(false);
        this.fraudcontroller = new LocalFraudController();
    }

    public final void addCashDevice(ManagedCashAcceptor acceptor) {
        if (acceptor == null) {
            return;
        }
        boolean result = this.acceptors.add((CashAcceptor)acceptor);
        if (result) {
            acceptor.setCashStorage((SessionCashStorage)this.cashStorage);
            if (acceptor instanceof Validator) {
                Validator val = (Validator)acceptor;
                val.addStatusObserver((ValidatorStatusListener)new LocalValidatorListener((CashAcceptor)val));
                val.addStatisticObserver((StatisticListener)this.fraudcontroller);
            }
        }
    }

    public final synchronized void enable(Keeper parent, Sum max, Set<CashUnit> cashUnits, Set<CashUnit> coinUnits, KeeperObserver observer, int deviceMask, Integer fraudRejectKol, Integer fraudMinNominalNote, Integer fraudTimeout, Boolean fraudNoNeedMin, FraudListener listener, boolean notTakeBills, Sum firstMinNominal) {
        this.max = max;
        this.cashUnits = cashUnits;
        this.coinUnits = coinUnits;
        this.observer = observer;
        this.deviceMask = deviceMask;
        this.notTakeBills = notTakeBills;
        this.firstMinNominal = firstMinNominal;
        UserAction.getInstance().update();
        this.log.info((Object)"-------------------------------------------------------------------");
        this.log.info((Object)("Enable cash devices with max sum=" + this.max));
        this.log.info((Object)("Allowed cash units: " + cashUnits));
        this.log.info((Object)("Allowed coin units: " + coinUnits));
        this.keeper = parent == null ? new Keeper() : parent;
        if (this.fraudcontroller.enable(fraudRejectKol, fraudMinNominalNote, fraudTimeout, fraudNoNeedMin)) {
            this.currentFraudListener = listener;
            this.addFraudListener(listener);
        }
        this.notifyKeeperObservers(this.keeper, new Sum());
        this.enable = true;
        if (deviceMask > 0) {
            Sum maxSum = max == null ? null : max.sub(this.keeper.getSum());
            for (CashAcceptor device : this.acceptors) {
                if (Boolean.TRUE.equals(this.connErrors.get(device))) {
                    this.log.info((Object)("Device " + device + " is deactivated. Skip"));
                    continue;
                }
                this.log.info((Object)("Enable " + device));
                device.enable(cashUnits, coinUnits);
                device.setMaxSum(maxSum);
            }
        }
    }

    public void enable(Keeper parent, Sum max, Set<CashUnit> cashUnits, Set<CashUnit> coinUnits, KeeperObserver observer, int deviceMask, boolean notTakeBills) {
        this.enable(parent, max, cashUnits, coinUnits, observer, deviceMask, null, null, null, null, null, notTakeBills, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Keeper disable() {
        Keeper result = null;
        this.log.info((Object)"Disable the devices");
        int extraTimeout = 0;
        Object object = this;
        synchronized (object) {
            this.enable = false;
            this.fraudOfflineErrorCount = 0;
            this.fraudcontroller.disable();
            this.removeFraudListener(this.currentFraudListener);
            this.currentFraudListener = null;
            for (CashAcceptor device : this.acceptors) {
                int dt = device.getExtraTimeout();
                if (dt > extraTimeout) {
                    extraTimeout = dt;
                }
                if (Boolean.TRUE.equals(this.connErrors.get(device))) {
                    this.log.info((Object)("Device " + device + " is deactivated. Skip"));
                    continue;
                }
                this.log.info((Object)("Disable " + device));
                device.disable();
                this.log.info((Object)"Ready");
            }
        }
        this.log.info((Object)("Devices are disabled, extra timeout: " + extraTimeout));
        if (extraTimeout > 0) {
            try {
                Thread.sleep(extraTimeout);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Remove observer");
        object = this.observerSync;
        synchronized (object) {
            this.observer = null;
            result = this.keeper;
            this.keeper = new Keeper();
        }
        return result;
    }

    public Keeper current() {
        return this.keeper;
    }

    public void setNotTakeBills(boolean notTakeBills) {
        this.notTakeBills = notTakeBills;
    }

    public void addFraudListener(FraudListener listener) {
        if (listener != null) {
            this.fraudcontroller.addListener(listener);
        }
    }

    public void removeFraudListener(FraudListener listener) {
        if (listener != null) {
            this.fraudcontroller.removeListener(listener);
        }
    }

    public void updateFirmware(File updateFolder, UpdateFirmwareListener listener) {
        for (CashAcceptor device : this.acceptors) {
            this.log.info((Object)("Send command for update firmware to " + device));
            device.updateFirmware(updateFolder, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyKeeperObservers(Keeper keeper, Sum sum) {
        this.log.info((Object)("New keeper state: " + keeper));
        Object object = this.observerSync;
        synchronized (object) {
            if (this.observer != null) {
                this.observer.update(keeper, sum);
                this.fraudcontroller.update(keeper, sum);
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Lost bill: " + sum);
            }
        }
    }

    public int getFraudOfflineErrorCount() {
        return this.fraudOfflineErrorCount;
    }

    public static interface PermitListener {
        public void onPermit();
    }

    public class LocalFraudController
    implements StatisticListener,
    KeeperObserver {
        private boolean enable;
        private Integer fraudRejectKol;
        private Integer fraudMinNominalNote;
        private Integer fraudTimeout;
        private Boolean noNeedMin;
        private int attempts;
        private Set<FraudListener> listeners;
        protected final Object sync = new Object();
        private long insertTime;

        public LocalFraudController() {
            this.listeners = Collections.synchronizedSet(new HashSet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(FraudListener listener) {
            Object object = this.sync;
            synchronized (object) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(FraudListener listener) {
            Object object = this.sync;
            synchronized (object) {
                this.listeners.remove(listener);
            }
        }

        public boolean enable(Integer fraudRejectKol, Integer fraudMinNominalNote, Integer fraudTimeout, Boolean noNeedMin) {
            if (fraudRejectKol != null && fraudMinNominalNote != null) {
                BaseCashManager.this.log.info((Object)"Enable FraudController");
                this.enable = true;
                this.fraudRejectKol = fraudRejectKol;
                this.fraudMinNominalNote = fraudMinNominalNote;
                this.fraudTimeout = fraudTimeout;
                this.noNeedMin = noNeedMin;
            }
            return this.enable;
        }

        public void disable() {
            if (this.enable) {
                BaseCashManager.this.log.info((Object)"Disable FraudController");
                this.enable = false;
                this.attempts = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(Event event) {
            if (this.enable) {
                if (event != Event.Insert) {
                    ++this.attempts;
                    if (this.enable && this.attempts >= this.fraudRejectKol && this.contains(this.fraudMinNominalNote)) {
                        BaseCashManager.this.log.error((Object)("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0447\u0438\u0441\u043b\u043e \u043d\u0435\u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0445 \u043a\u0443\u043f\u044e\u0440 \u0438 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u0443\u043f\u044e\u0440\u0430 >= \u043c\u0438\u043d.\u043d\u043e\u043c\u0438\u043d\u0430\u043b\u0430. \u0427\u0438\u0441\u043b\u043e \u043d\u0435\u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0445 \u043a\u0443\u043f\u044e\u0440: " + this.attempts + ", \u043c\u0438\u043d. \u043d\u043e\u043c\u0438\u043d\u0430\u043b:" + this.fraudMinNominalNote));
                        Object object = this.sync;
                        synchronized (object) {
                            for (FraudListener listener : this.listeners) {
                                if (listener == null) continue;
                                listener.fraudDetected(this.fraudTimeout);
                            }
                        }
                    }
                } else {
                    this.insertTime = System.currentTimeMillis();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Keeper keeper, Sum sum) {
            long l;
            if (this.fraudRejectKol != null && this.fraudMinNominalNote != null && this.enable && this.attempts >= this.fraudRejectKol && this.contains(this.fraudMinNominalNote)) {
                BaseCashManager.this.log.error((Object)("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0447\u0438\u0441\u043b\u043e \u043d\u0435\u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0445 \u043a\u0443\u043f\u044e\u0440 \u0438 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u0443\u043f\u044e\u0440\u0430 >= \u043c\u0438\u043d.\u043d\u043e\u043c\u0438\u043d\u0430\u043b\u0430. \u0427\u0438\u0441\u043b\u043e \u043d\u0435\u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0445 \u043a\u0443\u043f\u044e\u0440: " + this.attempts + ", \u043c\u0438\u043d. \u043d\u043e\u043c\u0438\u043d\u0430\u043b:" + this.fraudMinNominalNote));
                Object object = this.sync;
                synchronized (object) {
                    for (FraudListener listener : this.listeners) {
                        if (listener == null) continue;
                        listener.fraudDetected(this.fraudTimeout);
                    }
                }
            }
            if (this.enable && (l = System.currentTimeMillis() - this.insertTime) > 0L && l < 1500L) {
                BaseCashManager.this.log.info((Object)"Emulator cheat detected");
                Object object = this.sync;
                synchronized (object) {
                    for (FraudListener listener : this.listeners) {
                        if (listener == null) continue;
                        listener.fraudDetected(this.fraudTimeout);
                    }
                }
            }
        }

        private boolean contains(Integer minnominal) {
            if (Boolean.TRUE.equals(this.noNeedMin)) {
                return true;
            }
            if (BaseCashManager.this.keeper.getCashUnits() == null || BaseCashManager.this.keeper.getCashUnits().isEmpty() || minnominal == null) {
                return false;
            }
            for (Map.Entry cu : BaseCashManager.this.keeper.getCashUnits().entrySet()) {
                if (new Sum(minnominal.intValue()).compareTo(((CashUnit)cu.getKey()).getNominal()) > 0) continue;
                return true;
            }
            return false;
        }

        public void notifyNoMoreNeed() {
        }
    }

    private class LocalValidatorListener
    implements ValidatorStatusListener {
        private CashAcceptor ca;
        private int errorCount = 0;
        private boolean error = false;

        public LocalValidatorListener(CashAcceptor ca) {
            this.ca = ca;
        }

        public void update(ValidatorStatus status) {
            if (this.isFraudError(status)) {
                BaseCashManager.this.fraudOfflineErrorCount++;
            }
            if (ValidatorStatus.ConnectionError.equals((Object)status)) {
                ++this.errorCount;
                if (this.errorCount > 10) {
                    this.errorCount = 0;
                    if (!this.error) {
                        this.error = true;
                        BaseCashManager.this.log.info((Object)("Device " + this.ca + " deactivate because i/o error was detected"));
                        BaseCashManager.this.connErrors.put(this.ca, true);
                    }
                }
            } else {
                if (this.error) {
                    BaseCashManager.this.log.info((Object)("Device " + this.ca + " activate"));
                }
                this.errorCount = 0;
                this.error = false;
                BaseCashManager.this.connErrors.put(this.ca, false);
            }
        }

        private boolean isFraudError(ValidatorStatus status) {
            return ValidatorStatus.AlignMotorError.equals((Object)status) || ValidatorStatus.CapacitanceCanalError.equals((Object)status) || ValidatorStatus.JammInHead.equals((Object)status) || ValidatorStatus.JammInStack.equals((Object)status) || ValidatorStatus.MagneticCanalError.equals((Object)status) || ValidatorStatus.OpticCanalError.equals((Object)status) || ValidatorStatus.StackMotorError.equals((Object)status) || ValidatorStatus.TransportMotorError.equals((Object)status);
        }
    }

    private class SessionCashStorageImpl
    implements SessionCashStorage {
        private SessionCashStorageImpl() {
        }

        public synchronized boolean cashPermit(CashUnit cashUnit) {
            UserAction.getInstance().update();
            BaseCashManager.this.log.info((Object)("Cash permit: " + cashUnit));
            if (cashUnit == null) {
                BaseCashManager.this.log.error((Object)"Reject: cashUnit is null");
                return false;
            }
            if (!BaseCashManager.this.enable) {
                BaseCashManager.this.log.info((Object)"Reject: cash manager is disabled");
                return false;
            }
            if (BaseCashManager.this.notTakeBills) {
                BaseCashManager.this.log.info((Object)("Reject: The total amount more than need to pay" + BaseCashManager.this.max));
                if (cashUnit.getType() == 3) {
                    BaseCashManager.this.observer.notifyNoMoreNeed();
                }
                return false;
            }
            if (cashUnit.getType() == 3 && BaseCashManager.this.cashUnits != null && !BaseCashManager.this.cashUnits.contains(cashUnit)) {
                BaseCashManager.this.log.info((Object)"Reject: cash unit not found in cash list");
                if (BaseCashManager.this.listener != null) {
                    BaseCashManager.this.listener.onPermit();
                }
                return false;
            }
            if (BaseCashManager.this.firstMinNominal != null && BaseCashManager.this.keeper.getSum().isEmpty() && cashUnit.getNominal().compareTo(BaseCashManager.this.firstMinNominal) < 0) {
                BaseCashManager.this.log.info((Object)("Reject: " + cashUnit + " - first bill is less than the authorized nominal " + BaseCashManager.this.firstMinNominal));
                return false;
            }
            if (cashUnit.getType() == 4 && BaseCashManager.this.coinUnits != null && !BaseCashManager.this.coinUnits.contains(cashUnit)) {
                BaseCashManager.this.log.info((Object)"Reject: cash unit not found in coin list");
                return false;
            }
            if (BaseCashManager.this.max != null && !BaseCashManager.this.max.isEmpty() && BaseCashManager.this.max.compareTo(BaseCashManager.this.keeper.getSum().add(cashUnit.getNominal())) < 0) {
                BaseCashManager.this.log.info((Object)("Reject: The total amount exceeds the maximum allowable, max=" + BaseCashManager.this.max));
                return false;
            }
            BaseCashManager.this.log.info((Object)"Permit");
            return true;
        }

        public synchronized boolean sumPermit(Sum sum) {
            UserAction.getInstance().update();
            if (sum == null) {
                return false;
            }
            if (!BaseCashManager.this.enable) {
                return false;
            }
            return BaseCashManager.this.keeper.getSum().add(sum).compareTo(BaseCashManager.this.max) <= 0;
        }

        public synchronized void addCbc(CashBackCard cbc) {
            UserAction.getInstance().update();
            BaseCashManager.this.keeper.addCashBackCard(cbc);
            BaseCashManager.this.notifyKeeperObservers(BaseCashManager.this.keeper, cbc.getNominal());
        }

        public synchronized void addCash(CashUnit moneyUnit) {
            BaseCashManager.this.log.info((Object)("Add " + moneyUnit));
            UserAction.getInstance().update();
            CashUnit cu = moneyUnit;
            BaseCashManager.this.keeper.addCash(cu);
            if (cu.getType() == 3) {
                BaseCashManager.this.cashBox.addCash(cu);
            } else {
                BaseCashManager.this.coinBox.addCash(cu);
            }
            BaseCashManager.this.notifyKeeperObservers(BaseCashManager.this.keeper, moneyUnit.getNominal());
            for (CashAcceptor device : BaseCashManager.this.acceptors) {
                if (Boolean.TRUE.equals(BaseCashManager.this.connErrors.get(device))) continue;
                device.setMaxSum(this.getAllowedSum());
            }
        }

        public Sum getCurrentSum() {
            return BaseCashManager.this.keeper.getSum();
        }

        public Sum getMaximumSum() {
            return BaseCashManager.this.max;
        }

        public Sum getAllowedSum() {
            if (BaseCashManager.this.max == null) {
                return new Sum(0);
            }
            return BaseCashManager.this.max.sub(BaseCashManager.this.keeper.getSum());
        }
    }
}

