/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.statistic.adv;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.application.statistic.adv.StoreData;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;

public class AdvStatisticStore {
    private File file;
    private StoreData sd;
    private Logger log;

    public AdvStatisticStore(String fileName) throws FileUtilException {
        this.file = FileUtil.checkFile((String)fileName);
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
        this.readData();
    }

    public synchronized void addStatistic(int id, AdvStatisticType type) {
        String key;
        Map<String, AdvStatistic> stat = this.sd.getStat();
        if (stat.get(key = "" + id + type) == null) {
            AdvStatistic st = new AdvStatistic();
            st.setId(id);
            st.setType(type);
            st.setCount(1);
            stat.put(key, st);
        } else {
            stat.get(key).setCount(stat.get(key).getCount() + 1);
        }
        this.saveData();
    }

    void addStatistic(List<Integer> bi, AdvStatisticType type) {
        if (bi != null && !bi.isEmpty()) {
            for (Integer id : bi) {
                String key;
                Map<String, AdvStatistic> stat = this.sd.getStat();
                if (stat.get(key = "" + id + type) == null) {
                    AdvStatistic st = new AdvStatistic();
                    st.setId(id.intValue());
                    st.setType(type);
                    st.setCount(1);
                    stat.put(key, st);
                    continue;
                }
                stat.get(key).setCount(stat.get(key).getCount() + 1);
            }
            this.saveData();
        }
    }

    public synchronized List<AdvStatistic> resetStatistics() {
        this.log.info((Object)"\u041e\u0431\u043d\u0443\u043b\u044f\u044e adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443");
        StoreData newSd = new StoreData();
        Map<String, AdvStatistic> stat = this.sd.getStat();
        LinkedList<AdvStatistic> st = new LinkedList<AdvStatistic>();
        for (AdvStatistic as : stat.values()) {
            as.setFrom(this.sd.getFrom());
            as.setTo(newSd.getFrom());
            st.add(as);
        }
        this.sd = newSd;
        this.saveData();
        return st;
    }

    public Date getFrom() {
        return this.sd.getFrom();
    }

    private void readData() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.file));
            Object obj = ois.readObject();
            if (obj instanceof StoreData) {
                this.sd = (StoreData)obj;
            }
        }
        catch (EOFException obj) {
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.sd == null) {
            this.sd = new StoreData();
        }
    }

    private void saveData() {
        ObjectOutputStream oos = null;
        this.log.debug((Object)("save new data: " + this.sd));
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.file));
            oos.writeObject(this.sd);
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

