/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.disk;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.application.disk.BadPermissionWalker;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.TimeUtil;

public class DiskObserver
implements Runnable {
    private final long DAY = 86400000L;
    private ClientInterface clientInterface;
    private Logger log;

    public DiskObserver(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ClientInterface");
        }
        this.clientInterface = clientInterface;
        this.log = Logger.getLogger((String)"maintenance");
        this.log.setAdditivity(false);
    }

    @Override
    public void run() {
        try {
            this.log.info((Object)"Sleep 10 minutes");
            Thread.sleep(600000L);
            try {
                this.log.info((Object)"Check permissions");
                BadPermissionWalker bpw = new BadPermissionWalker();
                LinkedList<File> files = bpw.getFiles(new File(PathUtils.getAppHome()));
                this.log.info((Object)"Check complete");
                if (files.size() > 0) {
                    this.log.info((Object)"Wrong permission: ");
                    for (File f : files) {
                        this.log.info((Object)("    " + f.getAbsolutePath()));
                    }
                    this.log.info((Object)"-");
                    ProblemNotifier.getDefaultNotifier().onProblem("Wrong permission: " + files);
                } else {
                    this.log.info((Object)"System has no problem");
                }
            }
            catch (IOException ex) {
                this.log.info((Object)"Error on process files", (Throwable)ex);
            }
            this.processDirs();
            while (!Thread.currentThread().isInterrupted()) {
                long interval = TimeUtil.untilMidnight();
                Thread.sleep(interval);
                Date dt = new Date();
                Enumeration en = Logger.getRootLogger().getLoggerRepository().getCurrentLoggers();
                while (en.hasMoreElements()) {
                    Logger l = (Logger)en.nextElement();
                    l.info((Object)("New day has come: " + dt));
                }
                this.processDirs();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void processDirs() {
        this.log.info((Object)"Process dirs");
        this.log.info((Object)"Send free space");
        File file = new File(PathUtils.getAppHome());
        this.clientInterface.sendSpace((int)(file.getUsableSpace() / 0x100000L));
        this.log.info((Object)"Clean");
        this.cleanDirectory(PathUtils.getAppHome() + "/log/card/");
        this.cleanDirectory(PathUtils.getAppHome() + "/log/add/");
        this.cleanDirectory(PathUtils.getAppHome() + "/log/");
        this.cleanDirectory(Configuration.getInstance().getMppkPath() + File.separator + "PathToUploadData" + File.separator);
        this.log.info((Object)"Compress");
        this.compressFiles(PathUtils.getAppHome() + "/log/card/");
        this.compressFiles(PathUtils.getAppHome() + "/log/add/");
        this.compressFiles(PathUtils.getAppHome() + "/log/");
        this.log.info((Object)"Job well done!");
    }

    private void cleanDirectory(String path) {
        File[] fs;
        long now = System.currentTimeMillis();
        int count = 0;
        File dir = new File(path);
        if (dir.isDirectory() && (fs = dir.listFiles()) != null) {
            for (File f : fs) {
                if (f == null || !f.isFile() || now - f.lastModified() <= 7776000000L) continue;
                f.delete();
                ++count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compressFiles(String dir) {
        byte[] buf = new byte[1000];
        File[] files = new File(dir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getAbsolutePath().contains(".log.") && !pathname.getAbsolutePath().endsWith(".zip") && System.currentTimeMillis() - pathname.lastModified() > 172800000L;
            }
        });
        if (files == null) return;
        if (files.length <= 0) return;
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            ZipOutputStream zos = null;
            try {
                block18: {
                    zos = new ZipOutputStream(new FileOutputStream(f.getAbsolutePath() + ".zip"));
                    zos.setLevel(9);
                    ZipEntry ze = new ZipEntry(f.getName() + ".txt");
                    BufferedInputStream is = null;
                    try {
                        int read;
                        zos.putNextEntry(ze);
                        is = new BufferedInputStream(new FileInputStream(f));
                        while ((read = ((InputStream)is).read(buf)) >= 0) {
                            zos.write(buf, 0, read);
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    catch (IOException ex) {
                        this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430", (Throwable)ex);
                        break block18;
                    }
                    try {
                        zos.closeEntry();
                    }
                    catch (Exception exception) {}
                    break block18;
                    finally {
                        IOUtils.closeQuietly(is);
                        try {
                            zos.closeEntry();
                        }
                        catch (Exception exception) {}
                    }
                }
                f.delete();
                IOUtils.closeQuietly((OutputStream)zos);
            }
            catch (Exception ex) {
                this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u04302", (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly(zos);
            }
            ++n2;
        }
    }
}

