/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.collection;

import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.state.AddStateListener;
import ru.softlogic.application.collection.MoneyCollectionProxy;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.encashment.EncashmentStore;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.module.Module;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ws.stub.Encashment;
import ru.softlogic.srv.connector.ws.stub.EncashmentEntred;
import ru.softlogic.srv.connector.ws.stub.EncashmentResult;
import ru.softlogic.system.util.ThreadUtil;

public class EncashmentSynch
implements Runnable {
    private static final short SUCCESS = 1;
    private static final short NO_NEED = 2;
    private static final short FAILED = 3;
    private final CashBox noteBox;
    private final CashBox coinBox;
    private final ClientInterface clientInterface;
    private final Logger log = Logger.getLogger((String)"maintenance");
    private final ApplicationContext context;
    private final AddStateListener listener;
    private final MoneyCollectionProxy mcProxy;

    public EncashmentSynch(CashBox noteBox, CashBox coinBox, ApplicationContext context, AddStateListener asl, MoneyCollectionProxy mcProxy) {
        this.noteBox = noteBox;
        this.coinBox = coinBox;
        this.clientInterface = context.getServerConnector();
        this.context = context;
        this.listener = asl;
        this.mcProxy = mcProxy;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            Encashment[] encashments;
            ThreadUtil.sleep((long)10000L);
            if (!this.canEncash()) continue;
            for (Encashment enc : encashments = EncashmentStore.getInstance().getEncashments()) {
                EncashmentResult result;
                if (enc.isFinished() || new Date().before(enc.getMoneyCollection().getDate())) continue;
                try {
                    DeviceClass deviceClass = DeviceClass.getValueByCode((Short)enc.getMoneyCollection().getDeviceClass());
                    Date last = this.getCashBox(deviceClass).getKeeper().getCreated();
                    if (last == null) {
                        throw new CashProfileException("Last Money Collection date unknown");
                    }
                    if (!last.before(enc.getMoneyCollection().getDate()) || !this.mcProxy.canEncash()) {
                        this.log.info((Object)("Encashment alredy processed. id: " + enc.getMoneyCollection().getId()));
                        result = this.abortProcessing((short)2, enc);
                    } else {
                        if (enc.isStarted()) {
                            throw new CashProfileException("Encashment has been incorrectly finished. Send failed.");
                        }
                        this.log.info((Object)("Processing remote encashment: " + enc));
                        this.log.info((Object)"Locking money collection proxy.");
                        this.mcProxy.lock();
                        this.listener.onAddState(13);
                        this.context.toMainMenu();
                        result = this.processEncashment(enc, deviceClass);
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)("Can't to process remote encashment. encashment id: " + enc.getMoneyCollection().getId()), (Throwable)ex);
                    result = this.abortProcessing((short)3, enc);
                }
                this.log.info((Object)"Unlocking money collection proxy.");
                this.mcProxy.unlock();
                this.listener.onAddState(0);
                this.clientInterface.sendEncashmentResult(result);
                this.log.info((Object)"Marking encashment as finished.");
                enc.setFinished();
                EncashmentStore.getInstance().update(enc);
                this.log.info((Object)"Sending event to server.");
                this.clientInterface.sendEvent(new Event(EventType.RemoteCollectionProcessed, this.toString(result)));
            }
        }
    }

    private boolean canEncash() {
        Module module = this.context.getModuleStore().getModule();
        return module != null && (module.getType() == 1 || module.getType() == 0);
    }

    private EncashmentResult abortProcessing(short status, Encashment encashment) {
        this.log.info((Object)"Abort processing encashment.");
        EncashmentResult encashmentResult = new EncashmentResult();
        encashmentResult.setId(encashment.getMoneyCollection().getId());
        encashmentResult.setStatus(status);
        return encashmentResult;
    }

    private EncashmentResult processEncashment(Encashment encashment, DeviceClass deviceClass) throws CashProfileException {
        Keeper keeper = new Keeper();
        EncashmentResult result = new EncashmentResult();
        result.setId(encashment.getMoneyCollection().getId());
        this.log.info((Object)"Mark encashment as started.");
        encashment.setStarted();
        EncashmentStore.getInstance().update(encashment);
        CashBox cashBox = this.getCashBox(deviceClass);
        Map availableCashUnits = cashBox.getKeeper().getCashUnits();
        for (EncashmentEntred ecen : encashment.getEncasmentEntreds()) {
            short idMoneyUnit = ecen.getIdMoneyUnit();
            short remoteAmount = ecen.getAmount();
            CashUnit cashUnit = this.toCashUnit(idMoneyUnit, ecen.getCurrency(), deviceClass);
            Integer localAmount = (Integer)availableCashUnits.get(cashUnit);
            if (localAmount != null && localAmount >= remoteAmount) {
                keeper.addCash(cashUnit, (int)remoteAmount);
                continue;
            }
            throw new CashProfileException("Insufficient cashunits at local keeper. cashunit: " + idMoneyUnit);
        }
        this.log.info((Object)"Reducing cashbox rest.");
        cashBox.sub(keeper);
        cashBox.getKeeper().setCreated(encashment.getMoneyCollection().getDate());
        result.setStatus((short)1);
        return result;
    }

    private CashBox getCashBox(DeviceClass deviceClass) throws CashProfileException {
        if (DeviceClass.CoinAcceptor.equals((Object)deviceClass)) {
            return this.coinBox;
        }
        if (DeviceClass.CashAcceptor.equals((Object)deviceClass)) {
            return this.noteBox;
        }
        throw new CashProfileException("incorrect device class at remote encashment: " + deviceClass);
    }

    private CashUnit toCashUnit(short id, String currency, DeviceClass deviceClass) throws CashProfileException {
        CashUnit[] cus;
        CashFactory cashFactory = CashFactory.getInstance((String)currency);
        if (cashFactory == null) {
            throw new CashProfileException("Unknown currency at remote encashment: " + currency);
        }
        if (DeviceClass.CoinAcceptor == deviceClass) {
            cus = cashFactory.getCoinUnits();
        } else if (DeviceClass.CashAcceptor == deviceClass) {
            cus = cashFactory.getCashUnits();
        } else {
            throw new CashProfileException("incorrect device class at remote encashment: " + deviceClass);
        }
        for (CashUnit cu : cus) {
            if (cu.getId() != id) continue;
            return cu;
        }
        throw new CashProfileException("Unknown cash unit " + id + " for device class " + deviceClass);
    }

    private String toString(EncashmentResult result) {
        short status = result.getStatus();
        switch (status) {
            case 1: {
                return "success";
            }
            case 2: {
                return "no need";
            }
            case 3: {
                return "failed";
            }
        }
        return "unknown status: " + status;
    }
}

