/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.state.AddStateListener;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoFile;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoKkm;
import ru.softlogic.hardware.device.print.kkm.leokas.ZRInfo;
import ru.softlogic.hardware.device.print.kkm.leokas.reports.ReportReader;
import ru.softlogic.module.Module;
import ru.softlogic.module.ModuleStore;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

public class ZReportCloseThread
implements Runnable {
    private static final String KKM_FOLDER = PathUtils.getAppHome() + File.separator + "data" + File.separator + "kkm";
    private final Logger log;
    private final LeoKkm printer;
    private final ModuleStore store;
    private final AddStateListener addStateListener;
    private final ApplicationContext context;

    public ZReportCloseThread(LeoKkm printer, ApplicationContext context, AddStateListener asl) {
        if (printer == null) {
            throw new NullPointerException("Printer is null");
        }
        if (context == null) {
            throw new NullPointerException("Application context is null");
        }
        if (context.getModuleStore() == null) {
            throw new NullPointerException("Module store is null");
        }
        if (asl == null) {
            throw new NullPointerException("State listener is null");
        }
        this.printer = printer;
        this.context = context;
        this.store = context.getModuleStore();
        this.addStateListener = asl;
        this.log = Logger.getLogger((String)"zrep");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start ZReportCloseThread thread");
        try {
            FileUtil.checkDir((String)KKM_FOLDER);
        }
        catch (FileUtilException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            this.log.info((Object)"Stop ZReportCloseThread thread");
            return;
        }
        ThreadUtil.sleep((long)30000L);
        ZRInfo zrinfo = ZRInfo.readData();
        this.log.info((Object)("Last report info: " + zrinfo));
        if (zrinfo.getLastZRDate() == null || zrinfo.getLastZRDate().before(this.getCurrDayStart()) || zrinfo.isError()) {
            try {
                ReportResult r = this.printer.closeReportZToMem();
                if (!r.isError()) {
                    zrinfo.update(r.getResult(), new Date());
                    List<LeoFile> files = this.copyReports(this.printer, zrinfo.getReports());
                    this.notifyReportResult(files, (BaseKkm)this.printer);
                    zrinfo.flush();
                } else {
                    zrinfo.update(r.getResult(), new Date());
                }
            }
            catch (IOException ex) {
                zrinfo.update(-1, new Date());
                this.log.error((Object)ex, (Throwable)ex);
            }
            this.log.info((Object)("Current report result: " + zrinfo));
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ReportResult r;
                Module m;
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                Date timeBlock = po.getzReportTimeBlock();
                Date timeCreate = po.getzReportTimeCreate();
                if (timeBlock == null || timeCreate == null) {
                    this.log.info((Object)"Scheduled z-report is disabled");
                    break;
                }
                Thread.sleep(this.getSleepTime(timeBlock));
                this.log.info((Object)"Try to lock terminal");
                long l = timeCreate.getTime() - timeBlock.getTime() - 1000L;
                long start = System.currentTimeMillis();
                boolean canLock = true;
                while ((m = this.store.getModule()) == null || m.getType() != 1 && m.getType() != 0) {
                    if (System.currentTimeMillis() - start >= l) {
                        canLock = false;
                        break;
                    }
                    Thread.sleep(1000L);
                }
                this.addStateListener.onAddState(13);
                if (canLock) {
                    this.context.toMainMenu();
                    this.log.info((Object)"Terminal locked");
                } else {
                    this.log.info((Object)"Terminal can't be locked now");
                }
                if (System.currentTimeMillis() - start < l) {
                    this.log.info((Object)"Wait report time");
                    Thread.sleep(l - (System.currentTimeMillis() - start));
                }
                if (!(r = this.printer.closeReportZToMem()).isError()) {
                    zrinfo.update(r.getResult(), new Date());
                    List<LeoFile> files = this.copyReports(this.printer, zrinfo.getReports());
                    this.notifyReportResult(files, (BaseKkm)this.printer);
                    zrinfo.flush();
                } else {
                    zrinfo.update(r.getResult(), new Date());
                }
            }
            catch (InterruptedException ex) {
                this.log.info((Object)"Thread is interrupted");
                Thread.currentThread().interrupt();
            }
            catch (IOException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                zrinfo.update(-1, new Date());
            }
            catch (ReferenceException ex) {
                this.log.info((Object)"Error references, sleep 10 seconds");
            }
            finally {
                this.addStateListener.onAddState(0);
                this.log.info((Object)"Terminal unlocked");
                ThreadUtil.sleep((long)10000L);
            }
            this.log.info((Object)("Report result: " + zrinfo));
        }
        this.log.info((Object)"Stop ZReportCloseThread thread");
    }

    private Date getCurrDayStart() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    private long getSleepTime(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        long timeNow = (long)(c.get(11) * 60 * 60) * 1000L;
        timeNow += (long)(c.get(12) * 60 * 1000);
        c.setTime(d);
        long timeTo = (long)(c.get(11) * 60 * 60) * 1000L;
        timeTo += (long)(c.get(12) * 60 * 1000);
        long sleep = (timeTo += (long)(c.get(13) * 1000)) - (timeNow += (long)(c.get(13) * 1000));
        if (sleep < 0L) {
            sleep += 86400000L;
        }
        this.log.info((Object)("Sleep " + sleep / 1000L + "s"));
        return sleep;
    }

    private List<LeoFile> copyReports(LeoKkm leo, List<LeoFile> currReports) throws IOException {
        List files = leo.getReportFiles();
        if (!files.isEmpty()) {
            for (LeoFile file : files) {
                int idx = currReports.indexOf(file);
                LeoFile exist = null;
                if (idx >= 0) {
                    exist = currReports.get(idx);
                }
                if (exist != null && exist.isFlagExist(1)) continue;
                this.log.info((Object)("Copy file: " + file.getFullName()));
                try {
                    if (leo.copyReport(file.getFullName(), KKM_FOLDER, (int)file.getSize()) == null) continue;
                    if (exist == null) {
                        file.addFlag(1);
                        currReports.add(file);
                    } else {
                        exist.addFlag(1);
                    }
                    this.log.info((Object)"Success");
                }
                catch (IOException ex) {
                    this.log.error((Object)("Fail on copy file '" + file.getFullName() + "', " + ex.getMessage()));
                }
            }
        }
        return currReports;
    }

    private void notifyReportResult(List<LeoFile> files, BaseKkm kkm) {
        Date firstDate = null;
        try {
            String paramDate = AppDefaults.getInstance().getProperty("printer.kkm.firstzdate", "");
            firstDate = new SimpleDateFormat("dd.MM.yyyy").parse(paramDate);
        }
        catch (ParseException ex) {
            this.log.error((Object)"incorrect date of first z report param. Process all reports");
        }
        for (LeoFile f : files) {
            try {
                if (firstDate != null && firstDate.after(f.getcDate())) {
                    this.log.info((Object)"first report z date after file creation date. Skip file");
                    continue;
                }
                if (!f.isFlagExist(1) || f.isFlagExist(2)) continue;
                ReportReader reader = new ReportReader(new File(KKM_FOLDER + File.separator + f.getFullName()));
                kkm.notifyZReportInfo(reader.read());
                f.addFlag(2);
            }
            catch (Exception ex) {
                this.log.error((Object)("can't parse Zreport file: " + f.getFullName()), (Throwable)ex);
            }
        }
    }
}

