/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import ru.softlogic.application.SafeReboot;
import ru.softlogic.module.utils.managerpl.ManagerPL;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateSize;

public class SystemUpdateListener
implements StateListener,
RemoteStatusObserver {
    private ClientInterface client;
    private Short currentStatus;

    public SystemUpdateListener(ClientInterface client) {
        if (client == null) {
            throw new NullPointerException("ClientInterface");
        }
        this.client = client;
    }

    public void update(int remoteStatus) {
        if ((remoteStatus & 2) == 0 && (this.currentStatus == null || this.currentStatus == 2 || this.currentStatus == 3)) {
            this.process((short)0);
        }
    }

    public void onStart() {
        this.process((short)1);
    }

    public void onSkip() {
        this.process((short)2);
    }

    public void onConfirm(UpdateSize updateSize) {
        this.client.sendEvent(new Event(EventType.Update, "Confirm update: size=" + updateSize.getSize() / 1024 + " kB, count=" + updateSize.getCount()));
    }

    public void onProgress(String fileName, int total, int progress) {
    }

    public void onSuccess(UpdateMetric updateMetric) {
        this.process((short)2);
        String duration = String.format("%.2f", (double)updateMetric.getDuration() * 1.0 / 1000.0);
        String speed = String.format("%.2f", (double)updateMetric.getSize() * 1.0 / 1024.0 * 1000.0 / (double)updateMetric.getDuration());
        this.client.sendEvent(new Event(EventType.Update, "Update success: size=" + updateMetric.getSize() / 1024 + " kB, count=" + updateMetric.getCount() + ", duration=" + duration + " s, speed=" + speed + " kBps"));
        ManagerPL.getInstance().onExit();
        SafeReboot.getInstance().restart(17);
    }

    public void onCancel() {
        this.process((short)3);
    }

    public void onLocalError(Exception ex, UpdateMetric updateMetric) {
        this.process((short)3);
        this.client.sendEvent(new Event(EventType.UpdateFault, "Update error: " + ex.getMessage()));
    }

    public void onGlobalError(Exception ex) {
        this.process((short)3);
        this.client.sendEvent(new Event(EventType.UpdateFault, "Update failure: " + ex.getMessage()));
    }

    private synchronized void process(short status) {
        if (this.currentStatus == null || this.currentStatus != status) {
            this.currentStatus = status;
            this.client.sendUpdateStatus(new UpdateState(status, 0));
        }
    }
}

