/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import i18n.B;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.menu.MenuListener;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.MenuItem;

public class PrinterMenuListener
implements MenuListener {
    private ApplicationContext context;
    private MenuListener listener;
    private Logger log;
    private MenuItem mi;
    private Map<String, Object> initData;

    public PrinterMenuListener(ApplicationContext context, MenuListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 context");
        }
        if (listener == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 listener");
        }
        this.context = context;
        this.listener = listener;
        this.log = Logger.getLogger((String)"pay");
    }

    public void init(Locale locale) {
    }

    public void onUserAction(final MenuItem menuItem, Map<String, Object> data) {
        this.mi = menuItem;
        this.initData = data;
        this.log.debug((Object)"----------------------------------------------------------");
        this.log.debug((Object)("Select service: " + menuItem.getService()));
        TerminalState terminalStatus = StateFacade.getState();
        this.log.debug((Object)("Terminal state: " + terminalStatus));
        if ((terminalStatus.getWarningMask() & 1) > 0) {
            this.log.info((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043b\u0438 \u0431\u0443\u043c\u0430\u0433\u0430 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443: " + menuItem.getService().getPaperRequire()));
            if (menuItem.getService().getPaperRequire() == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Dialog.payment.printer.error"), menuItem.getService().getName()), 10, DC.cases((int)1), UserCase.Ok);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                PrinterMenuListener.this.context.toMainMenu();
                            }
                        });
                        PrinterMenuListener.this.context.showDialog((DialogInterface)dialog);
                    }
                });
            } else if (menuItem.getService().getPaperRequire() == 0) {
                this.log.info((Object)"\u0421\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u043e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u0435\u0437 \u0432\u044b\u0434\u0430\u0447\u0438 \u0447\u0435\u043a\u0430");
                boolean showWarning = true;
                try {
                    showWarning = ReferenceManager.getInstance().getPointOptions().getPaperWarning() == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (showWarning) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Warning, B.get((String)"Dialog.payment.printer.warning"), 10, DC.cases((int)12), UserCase.Ok);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    PrinterMenuListener.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                                    if (userCase == UserCase.Ok) {
                                        PrinterMenuListener.this.toNextListener();
                                    } else {
                                        PrinterMenuListener.this.context.toMainMenu();
                                    }
                                }
                            });
                            PrinterMenuListener.this.context.showDialog((DialogInterface)dialog);
                        }
                    });
                } else {
                    this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
                    this.toNextListener();
                }
            } else {
                this.toNextListener();
            }
        } else {
            this.toNextListener();
        }
    }

    void toNextListener() {
        this.listener.onUserAction(this.mi, this.initData);
    }

    public void onLangSelection(String lang) {
        this.listener.onLangSelection(lang);
    }

    public void onRedirect(int serviceId) {
        this.listener.onRedirect(serviceId);
    }

    public void onProvider(ProviderType type) {
        this.listener.onProvider(type);
    }

    public void onUserAction(String action) {
        this.listener.onUserAction(action);
    }
}

