/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.File;
import org.apache.log4j.Logger;
import ru.softlogic.system.util.EventNotifier;

public class OpenFileWatcher
implements Runnable {
    private static final int LIMIT = 300;
    private final File dir = new File("/proc/self/fd/");
    private final Logger log = Logger.getLogger((String)"app");

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                File[] files;
                Thread.sleep(1800000L);
                if (!this.dir.isDirectory() || (files = this.dir.listFiles()) == null) continue;
                this.log.info((Object)("Count of open files: " + files.length));
                if (files.length <= 300) continue;
                EventNotifier.notifyErrorOnce("Too many open files, count=" + files.length);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

