/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.service.Service;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class JammInformer
implements ValidatorStatusListener {
    private ClientInterface client;
    private Service service;
    private Map<String, String> form;
    private ValidatorStatus lastStatus;

    public JammInformer(ClientInterface client) {
        if (client == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ClientInterface");
        }
        this.client = client;
    }

    public void clear() {
        this.service = null;
        this.form = null;
    }

    public void setData(Service service, Map<String, String> form) {
        this.service = service;
        this.form = form;
    }

    public void update(ValidatorStatus status) {
        if (this.lastStatus != null && status == this.lastStatus) {
            return;
        }
        this.lastStatus = status;
        if (status == ValidatorStatus.JammInHead || status == ValidatorStatus.JammInStack) {
            if (this.service == null || this.form == null) {
                this.fillData();
            }
            if (this.service != null && this.form != null) {
                this.client.sendEvent(new Event(EventType.Jamm, (this.service.equals((Object)new Service()) ? "-" : this.service.getName()) + ": " + (!this.form.containsKey("id1") ? "-" : this.form.get("id1"))));
                this.clear();
            }
        }
    }

    private void fillData() {
        Pack pack = Session.getInstance().getCorrectPack();
        Operation lastPayment = Session.getInstance().getLastPayment();
        if (pack == null) {
            pack = Session.getInstance().getPack();
        }
        List payments = pack == null ? null : pack.getPayments();
        LinkedHashMap<String, String> forms = new LinkedHashMap();
        Service s = null;
        if (payments != null && !payments.isEmpty()) {
            for (InputElement ie : StoreHelper.clear((Map)((Payment)payments.get(0)).getData()).values()) {
                forms.put(ie.getKey(), ie.getValue());
            }
        } else if (lastPayment != null) {
            forms = lastPayment.getForm();
        }
        s = pack != null && pack.getService() != null ? pack.getService() : (lastPayment != null && lastPayment.getService() != null ? lastPayment.getService() : new Service());
        this.setData(s, forms);
    }
}

