/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import i18n.B;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.hopper.DispenseAdapter;
import ru.softlogic.hardware.device.hopper.DispenseListener;
import ru.softlogic.hardware.device.hopper.Hopper;
import ru.softlogic.hardware.device.hopper.IHopper;
import ru.softlogic.module.Module;
import ru.softlogic.system.util.ThreadUtil;

public class HopperThrowDownThread
implements Runnable {
    private final ApplicationContext context;
    private final CashBox box;
    private final Logger log = Logger.getLogger((String)"app");
    private static final long TIMEOUT = 120000L;
    private final WaitScreen waitScreen;

    public HopperThrowDownThread(ApplicationContext context, CashBox box) {
        this.context = context;
        this.box = box;
        this.waitScreen = ComponentFactory.getInstance().createWaitScreen("");
    }

    @Override
    public void run() {
        CashUnit[] coinUnits = CashFactory.getDefaultInstance().getCoinUnits();
        if (coinUnits == null || coinUnits.length == 0) {
            return;
        }
        Keeper target = new Keeper();
        for (CashUnit cu : coinUnits) {
            int lim = AppDefaults.getInstance().getIntegerValue("hopper.flowdown.limit" + cu.getNominal().getBasicSum(), 0);
            if (lim <= 0) continue;
            target.addCash(cu, AppDefaults.getInstance().getIntegerValue("hopper.flowdown.limit" + cu.getNominal().getBasicSum(), 0).intValue());
        }
        IHopper hopper = Hopper.getDefaultHopper();
        int flowCount = AppDefaults.getInstance().getIntegerValue("hopper.flowdown.count", 0);
        if (hopper != null && flowCount > 0) {
            while (!Thread.currentThread().isInterrupted()) {
                if (this.isNeedFlowDown(target, flowCount)) {
                    Module module = this.context.getModuleStore().getModule();
                    if (module != null && module.getType() == 1 && UserAction.getInstance().isElapsed(20)) {
                        try {
                            this.waitScreen.setText(B.get((String)"Dialog.wait.hopper-service"));
                            this.context.showWait(this.waitScreen);
                            hopper.flowDownCoins(target, (DispenseListener)new LocalDispenseListner());
                            ThreadUtil.sleep((long)120000L);
                        }
                        catch (Throwable ex) {
                            this.log.error((Object)ex, ex);
                        }
                    } else {
                        this.log.info((Object)"Wait MainMenu and timeout 20 sec");
                        ThreadUtil.sleep((long)10000L);
                        continue;
                    }
                }
                ThreadUtil.sleep((long)120000L);
            }
        }
    }

    private boolean isNeedFlowDown(Keeper target, int limit) {
        this.log.info((Object)"is need");
        Keeper keeper = this.box.getKeeper();
        if (keeper == null || keeper.getSum().isEmpty()) {
            return false;
        }
        for (CashUnit cu : keeper.getCashUnits().keySet()) {
            Integer count = (Integer)target.getCashUnits().get(cu);
            this.log.info((Object)("c " + count + " " + keeper.getCashUnits().get(cu)));
            if (count == null || (Integer)keeper.getCashUnits().get(cu) < count + limit) continue;
            this.log.info((Object)("CoinBox contains " + keeper.getCashUnits().get(cu) + " coins of " + cu.getNominal() + ". Need to flow down."));
            return true;
        }
        return false;
    }

    private class LocalDispenseListner
    extends DispenseAdapter {
        private LocalDispenseListner() {
        }

        public void onError() {
            HopperThrowDownThread.this.context.showWait(null);
        }

        public void onProcess(int sumDispensed) {
            UserAction.getInstance().update();
        }

        public void onResult(Keeper keeper) {
            HopperThrowDownThread.this.context.showWait(null);
        }
    }
}

