/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.awt.Frame;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class FrameMaximizer
implements Runnable {
    private JFrame frame;
    private boolean top;
    private Logger log;
    private boolean minimized;

    public FrameMaximizer(JFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 JFrame");
        }
        this.frame = frame;
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
        this.top = true;
        this.minimized = false;
        frame.addFocusListener(new LocalFocusListener());
    }

    public boolean isTop() {
        return this.top;
    }

    public void setTop(boolean top) {
        this.top = top;
        this.log.info((Object)("\u041d\u0430 \u0432\u0435\u0440\u0445\u0443=" + top));
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
        this.log.info((Object)("\u041c\u0438\u043d\u0438\u043c\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d=" + minimized));
    }

    public void setIconified(boolean iconified) {
        if (iconified) {
            this.frame.setState(1);
        } else {
            this.frame.setState(0);
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"Start FrameMaximizer thread");
        try {
            Thread.sleep(10000L);
            while (!Thread.currentThread().isInterrupted()) {
                boolean inFocus = false;
                for (Frame f : JFrame.getFrames()) {
                    if (!f.isFocused()) continue;
                    inFocus = true;
                    break;
                }
                if (!inFocus && this.top && !this.minimized) {
                    this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043e\u043a\u043d\u043e");
                    this.frame.setVisible(false);
                    System.gc();
                    Thread.sleep(4000L);
                    this.frame.setAlwaysOnTop(true);
                    this.frame.setVisible(true);
                    this.frame.requestFocus();
                    System.gc();
                    Thread.sleep(4000L);
                    this.frame.setState(0);
                    this.frame.setAlwaysOnTop(false);
                }
                Thread.sleep(7000L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop FrameMaximizer thread");
    }

    private class LocalFocusListener
    implements FocusListener {
        private LocalFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            FrameMaximizer.this.log.info((Object)"\u0424\u043e\u043a\u0443\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d");
            FrameMaximizer.this.minimized = false;
        }

        @Override
        public void focusLost(FocusEvent e) {
            FrameMaximizer.this.log.info((Object)"\u0424\u043e\u043a\u0443\u0441 \u043f\u043e\u0442\u0435\u0440\u044f\u043d");
        }
    }
}

