/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import i18n.B;
import java.awt.EventQueue;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.menu.MenuListener;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;

public class DelayMenuListener
implements MenuListener {
    private ApplicationContext context;
    private MenuListener listener;
    private MenuItem mi;
    private Logger log;
    private Map<String, Object> initData;

    public DelayMenuListener(ApplicationContext context, MenuListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435");
        }
        if (listener == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043b\u0438\u0441\u0442\u0435\u043d\u0435\u0440\u0435");
        }
        this.context = context;
        this.listener = listener;
        this.log = Logger.getLogger((String)"pay");
    }

    public void init(Locale locale) {
    }

    public void onUserAction(MenuItem menuItem, Map<String, Object> data) {
        this.mi = menuItem;
        this.initData = data;
        MenuItemState mis = null;
        try {
            mis = StateUtil.getState((MenuItem)menuItem, (MenuItemState[])ReferenceManager.getInstance().getMenuItemStates());
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432", (Throwable)ex);
        }
        if (mis != null && mis.isDelay()) {
            this.log.info((Object)"Show message about payment delay");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Warning, B.get((String)"Dialog.payment.delay"), 10, DC.cases((int)12), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            DelayMenuListener.this.log.info((Object)("User make choise " + userCase));
                            if (userCase == UserCase.Ok) {
                                DelayMenuListener.this.toNextListener();
                            } else {
                                DelayMenuListener.this.context.toMainMenu();
                            }
                        }
                    });
                    DelayMenuListener.this.context.showDialog((DialogInterface)dialog);
                }
            });
        } else {
            this.toNextListener();
        }
    }

    void toNextListener() {
        this.listener.onUserAction(this.mi, this.initData);
    }

    public void onLangSelection(String lang) {
        this.listener.onLangSelection(lang);
    }

    public void onRedirect(int serviceId) {
        this.listener.onRedirect(serviceId);
    }

    public void onProvider(ProviderType type) {
        this.listener.onProvider(type);
    }

    public void onUserAction(String action) {
        this.listener.onUserAction(action);
    }
}

