/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.app.ApplicationException;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.module.input.mobile.DefectorsVersion;
import ru.softlogic.module.input.mobile.MobileDefectorsManager;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.updater.UpdateOptions;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.HashUtils;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.update.updater.HttpUpdateStore;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateLocks;
import ru.softlogic.update.updater.exceptions.CreateStoreException;
import ru.softlogic.update.updater.exceptions.InvalidStoreException;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;

public class BDPNUpdater
implements Runnable,
RemoteStatusObserver {
    private Logger log;
    private long lastCheck;
    private boolean allowUpdate;
    private int attemptsCount;
    private ClientInterface clientInterface;
    private Short lastState;
    private boolean isSkipUpdate;
    private String errorMessage;

    public BDPNUpdater(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new NullPointerException("ClientInteface is null");
        }
        this.clientInterface = clientInterface;
        this.log = Logger.getLogger((String)"update");
        this.log.setAdditivity(false);
        this.attemptsCount = AppDefaults.getInstance().getIntegerValue("bdpn.download.attempts.count", 5);
    }

    public void update(int remoteStatus) {
        this.allowUpdate = (remoteStatus & 0x20) > 0;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.sendUpdateStatus((short)0);
        ThreadUtil.sleep((long)60000L);
        int hours = AppDefaults.getInstance().getIntegerValue("update.bdpn.timeout", 12);
        while (!Thread.currentThread().isInterrupted()) {
            if (this.allowUpdate && (this.lastCheck == 0L || System.currentTimeMillis() - this.lastCheck > (long)(hours * 60 * 60 * 1000))) {
                if (!UpdateLocks.getInstance().isSoftwareLocked()) {
                    UpdateLocks.getInstance().setBdpnLocked(true);
                    try {
                        File defectorsDir = new File(Configuration.getInstance().getApplicationDir() + "/resources/mobile/");
                        FileUtil.checkDir((String)defectorsDir.getAbsolutePath());
                        UpdateOptions options = ReferenceManager.getInstance().getUpdateOptions();
                        if (options != null && options.getUpdateUrl() != null && options.getUpdateUrl().length() > 0) {
                            boolean isErrorStatus;
                            this.sendUpdateStatus((short)1);
                            boolean bl = isErrorStatus = !this.checkDefectors(options);
                            if (isErrorStatus) {
                                this.sendUpdateStatus((short)3);
                                if (!this.errorMessage.isEmpty()) {
                                    this.clientInterface.sendEvent(new Event(EventType.UpdateFault, "Update " + this.errorMessage));
                                } else {
                                    this.clientInterface.sendEvent(new Event(EventType.UpdateFault, "Update BDPN error: for more details see logs"));
                                }
                            } else {
                                this.sendUpdateStatus((short)2);
                                DefectorsVersion dv = MobileDefectorsManager.getInstance().getLocalDefectorsVersion();
                                if (dv != null && !this.isSkipUpdate) {
                                    this.clientInterface.sendEvent(new Event(EventType.Update, "Update BDPN success: current version=" + dv.getVersion()));
                                }
                            }
                        } else {
                            this.log.error((Object)("BDPN: \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c\u0441\u044f, \u043d\u043e \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043e\u043f\u0446\u0438\u0439: " + options));
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"BDPN: \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438", (Throwable)e);
                        this.sendUpdateStatus((short)3);
                        this.clientInterface.sendEvent(new Event(EventType.UpdateFault, "Update BDPN failure: " + e.getMessage()));
                    }
                    this.lastCheck = System.currentTimeMillis();
                    UpdateLocks.getInstance().setBdpnLocked(false);
                }
            } else {
                this.sendUpdateStatus((short)0);
            }
            ThreadUtil.sleep((long)300000L);
        }
        this.log.info((Object)"Stop thread");
    }

    private void makeEasySSL(HttpsURLConnection conn) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            conn.setSSLSocketFactory(sc.getSocketFactory());
            conn.setHostnameVerifier(verifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDefectors(UpdateOptions options) throws ApplicationException, CreateStoreException {
        this.isSkipUpdate = false;
        this.errorMessage = "";
        String mPath = "/mobile/";
        if (!options.getUpdateUrl().endsWith("/")) {
            mPath = "/" + mPath;
        }
        File file = new File(PathUtils.getAppHome() + "/resources/mobile/" + "defectors.csv");
        File zipFile = new File(PathUtils.getAppHome() + "/resources/mobile/" + "defectors.csv.gz");
        DefectorsVersion lv = MobileDefectorsManager.getInstance().getLocalDefectorsVersion();
        DefectorsVersion rv = this.getRemoteDefectorsVersion(options.getUpdateUrl() + mPath + "crc", options.getUpdateLogin(), options.getUpdatePassword());
        this.log.info((Object)("BDPN: Local ver: " + lv + " Remote ver:" + rv));
        if (lv.getVersion() < rv.getMinVersion() - 1L) {
            this.log.info((Object)"BDPN: \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0437\u0430\u043a\u0430\u0447\u043a\u0430 defectors.csv");
            boolean res = this.downloadDefectorsFile(zipFile, options.getUpdateUrl() + mPath, options, rv.getCrc());
            if (res) {
                FileOutputStream out = null;
                GzipCompressorInputStream gzIn = null;
                try {
                    out = new FileOutputStream(file);
                    gzIn = new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(zipFile)));
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    while (-1 != (n = gzIn.read(buffer))) {
                        out.write(buffer, 0, n);
                    }
                }
                catch (Exception e) {
                    try {
                        res = false;
                        this.log.error((Object)("BDPN: Can't unpack file. " + e.getMessage()));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        IOUtils.closeQuietly(gzIn);
                        zipFile.delete();
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    IOUtils.closeQuietly((InputStream)gzIn);
                    zipFile.delete();
                }
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)gzIn);
                zipFile.delete();
            }
            if (!res && !UpdateLocks.getInstance().isSoftwareLocked()) {
                res = this.downloadDefectorsFile(file, options.getUpdateUrl() + mPath, options, rv.getCrc());
            }
            if (res) {
                lv.setVersion(rv.getVersion());
                MobileDefectorsManager.getInstance().writeLocalDefectorsVersion(lv);
                if (lv.getVersion() < rv.getMinVersion() - 1L) {
                    this.errorMessage = "BDPN: \u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 defectors \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435";
                    this.log.error((Object)this.errorMessage);
                    return false;
                }
                this.log.info((Object)"BDPN: \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0437\u0430\u043a\u0430\u0447\u043a\u0430 defectors.csv patch");
                for (long i = lv.getVersion() + 1L; i <= rv.getMaxVersion(); ++i) {
                    File p = new File(PathUtils.getAppHome() + "/resources/mobile/" + "patch" + String.valueOf(i) + ".gz");
                    DefectorsVersion rvp = this.getRemoteDefectorsVersion(options.getUpdateUrl() + mPath + "crc" + String.valueOf(i), options.getUpdateLogin(), options.getUpdatePassword());
                    boolean result = this.downloadDefectorsFile(p, options.getUpdateUrl() + mPath, options, rvp.getCrc());
                    if (result && MobileDefectorsManager.getInstance().patchDefectorsFile(p)) {
                        lv.setVersion(i);
                        p.delete();
                        MobileDefectorsManager.getInstance().writeLocalDefectorsVersion(lv);
                        continue;
                    }
                    p.delete();
                    p = new File(PathUtils.getAppHome() + "/resources/mobile/" + "patch" + String.valueOf(i));
                    result = this.downloadDefectorsFile(p, options.getUpdateUrl() + mPath, options, rvp.getCrc());
                    if (result && MobileDefectorsManager.getInstance().patchDefectorsFile(p)) {
                        lv.setVersion(i);
                        p.delete();
                        MobileDefectorsManager.getInstance().writeLocalDefectorsVersion(lv);
                        continue;
                    }
                    this.errorMessage = "BDPN: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u043f\u0430\u0442\u0447 " + i;
                    this.log.error((Object)this.errorMessage);
                    p.delete();
                    return false;
                }
                this.log.info((Object)"BDPN: \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u0440\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u0435");
                MobileDefectorsManager.getInstance().processDefectors();
                return true;
            }
            this.errorMessage = "BDPN: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u0430\u0447\u0430\u0442\u044c defectors.csv";
            this.log.error((Object)this.errorMessage);
            return false;
        }
        if (lv.getVersion() < rv.getMaxVersion()) {
            this.log.info((Object)"BDPN: \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0437\u0430\u043a\u0430\u0447\u043a\u0430 defectors.csv patch");
            for (long i = lv.getVersion() + 1L; i <= rv.getMaxVersion(); ++i) {
                File p = new File(PathUtils.getAppHome() + "/resources/mobile/" + "patch" + String.valueOf(i) + ".gz");
                DefectorsVersion rvp = this.getRemoteDefectorsVersion(options.getUpdateUrl() + mPath + "crc" + String.valueOf(i), options.getUpdateLogin(), options.getUpdatePassword());
                boolean result = this.downloadDefectorsFile(p, options.getUpdateUrl() + mPath, options, rvp.getCrc());
                if (result && MobileDefectorsManager.getInstance().patchDefectorsFile(p)) {
                    lv.setVersion(i);
                    p.delete();
                    MobileDefectorsManager.getInstance().writeLocalDefectorsVersion(lv);
                    continue;
                }
                p.delete();
                p = new File(PathUtils.getAppHome() + "/resources/mobile/" + "patch" + String.valueOf(i));
                result = this.downloadDefectorsFile(p, options.getUpdateUrl() + mPath, options, rvp.getCrc());
                if (result && MobileDefectorsManager.getInstance().patchDefectorsFile(p)) {
                    lv.setVersion(i);
                    p.delete();
                    MobileDefectorsManager.getInstance().writeLocalDefectorsVersion(lv);
                    continue;
                }
                this.errorMessage = "BDPN: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u043f\u0430\u0442\u0447 " + i;
                this.log.error((Object)this.errorMessage);
                p.delete();
                return false;
            }
            this.log.info((Object)"BDPN: \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u0440\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u0435");
            MobileDefectorsManager.getInstance().processDefectors();
            return true;
        }
        this.log.info((Object)"BDPN: \u0417\u0430\u043a\u0430\u0447\u043a\u0430 defectors.csv \u0438 \u043f\u0430\u0442\u0447\u0435\u0439 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
        long localCrc = HashUtils.calculateCRC32Checksum((File)file);
        if (localCrc != lv.getCrc()) {
            this.log.info((Object)"BDPN: \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u0440\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u0435");
            MobileDefectorsManager.getInstance().processDefectors();
        }
        this.isSkipUpdate = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefectorsVersion getRemoteDefectorsVersion(String url, String login, String password) {
        URLConnection conn = null;
        int code = 0;
        int number = 0;
        boolean cnt = false;
        long result = 0L;
        while (number++ < 3 && code != 200 && code != 206 && code != 404) {
            try {
                conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setRequestProperty("X-PayLogic-Update", "Pay-logic " + (ReferenceManager.getInstance().getPoint() == null ? 0 : ReferenceManager.getInstance().getPoint().getId()));
                ((HttpURLConnection)conn).setRequestMethod("POST");
                conn.setUseCaches(false);
                conn.setConnectTimeout(40000);
                if (conn instanceof HttpsURLConnection) {
                    this.makeEasySSL((HttpsURLConnection)conn);
                }
                if (login != null && password != null && login.length() > 0) {
                    String authorization = login + ":" + password;
                    String encodedAuthorization = new String(Base64.encodeBase64((byte[])authorization.getBytes()));
                    conn.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
                }
                code = ((HttpURLConnection)conn).getResponseCode();
            }
            catch (Exception e) {
                this.log.error((Object)("BDPN: \u041f\u043e\u043f\u044b\u0442\u043a\u0430 " + number + ", \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0435 " + url + ", \u0441\u043f\u0438\u043c 5 \u0441\u0435\u043a\u0443\u043d\u0434"), (Throwable)e);
                ThreadUtil.sleep((long)5000L);
            }
        }
        DefectorsVersion version = new DefectorsVersion();
        if (code == 200 || code == 206) {
            InputStream is = null;
            try {
                is = conn.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                version.setCrc(Long.parseLong(br.readLine()));
                version.setVersion(Long.parseLong(br.readLine()));
                version.setMinVersion(Long.parseLong(br.readLine()));
                version.setMaxVersion(Long.parseLong(br.readLine()));
            }
            catch (Exception exception) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        } else {
            this.log.error((Object)("BDPN: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + url + ", \u043a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 " + code));
        }
        if (conn != null) {
            ((HttpURLConnection)conn).disconnect();
        }
        return version;
    }

    private boolean downloadDefectorsFile(File file, String url, UpdateOptions options, long crc) throws CreateStoreException {
        boolean firstTime = true;
        int number = 1;
        do {
            boolean res;
            HttpUpdateStore us;
            block12: {
                int point = 0;
                try {
                    point = ReferenceManager.getInstance().getPoint() == null ? 0 : ReferenceManager.getInstance().getPoint().getId();
                }
                catch (ReferenceException referenceException) {
                    // empty catch block
                }
                us = new HttpUpdateStore(url, options.getUpdateLogin(), options.getUpdatePassword(), point, AppDefaults.getInstance().getIntegerValue("system.update.socket.timeout"));
                this.log.info((Object)("BDPN: \u041f\u043e\u043f\u044b\u0442\u043a\u0430 " + number + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043a\u0430\u0447\u0430\u0442\u044c: " + file.getName()));
                try {
                    if (!file.exists()) {
                        FileUtil.mkParentDirs((File)file);
                        break block12;
                    }
                    if (!firstTime) break block12;
                    res = file.delete();
                    this.log.info((Object)("BDPN: Delete file result: " + res));
                }
                catch (FileUtilException fue) {
                    this.log.error((Object)fue.getMessage(), (Throwable)fue);
                    continue;
                }
            }
            res = true;
            try {
                file.setLastModified(0L);
                us.download(new UpdateItem(file.getName(), crc, 0, 0L), file, null, null);
            }
            catch (RemoteFileNotFoundException ex) {
                this.log.error((Object)("Error: remote file not found, " + ex.getMessage()));
                res = false;
            }
            catch (IOException | InvalidStoreException ex) {
                this.log.error((Object)ex);
                res = false;
            }
            this.log.info((Object)("BDPN: \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if (!res) {
                this.log.info((Object)("BDPN: \u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 " + number + ". \u0421\u043f\u0438\u043c 20 \u0441\u0435\u043a\u0443\u043d\u0434"));
                ThreadUtil.sleep((long)20000L);
            } else if (HashUtils.calculateCRC32Checksum((File)file) == crc) {
                return true;
            }
            firstTime = false;
            UpdateLocks locks = UpdateLocks.getInstance();
            if (!locks.isSoftwareLocked()) continue;
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u0431\u043e\u043b\u0435\u0435 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442\u043d\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f. \u041f\u0440\u0435\u0440\u044b\u0432\u0430\u044e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0411\u0414\u041f\u041d.");
            break;
        } while (number++ < this.attemptsCount);
        return false;
    }

    private void sendUpdateStatus(short state) {
        if (this.lastState == null || this.lastState != state) {
            this.lastState = state;
            this.clientInterface.sendUpdateStatus(new UpdateState(state, 2));
        }
    }
}

