/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.hopper.HopperStateListener;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;

public class AppHopperStateListener
implements HopperStateListener {
    private ClientInterface server;
    private int prevState = -1;
    private Logger log = Logger.getLogger((String)"app");

    public AppHopperStateListener(ClientInterface server) {
        if (server == null) {
            throw new NullPointerException("ClientInterface is not set");
        }
        this.server = server;
    }

    public void onState(int state) {
        if (state != this.prevState) {
            this.log.info((Object)("Hopper state is change, new state: " + state));
            this.prevState = state;
            this.server.sendStatus(new DeviceStatus(Short.valueOf(DeviceClass.Hopper.getCode()), state));
            this.server.sendEvent(new Event(EventType.SoftwareFault, "Hopper : " + (state == 0 ? "OK" : "Error")));
        }
    }
}

