/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.task;

import i18n.B;
import java.awt.EventQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.useraction.UserAction;

public class TaskExecutor {
    private WaitScreen waitScreen;
    private ApplicationContext applicationContext;
    private ExecutorService executorService;
    private Logger log;

    public TaskExecutor(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ApplicationContext");
        }
        this.applicationContext = applicationContext;
        this.waitScreen = ComponentFactory.getInstance().createWaitScreen("");
        this.executorService = Executors.newFixedThreadPool(3);
        this.log = Logger.getLogger((String)"pay");
    }

    public TaskExecutor(ApplicationContext applicationContext, WaitScreen waitScreen) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ApplicationContext");
        }
        this.applicationContext = applicationContext;
        this.waitScreen = waitScreen;
        this.executorService = Executors.newFixedThreadPool(3);
        this.log = Logger.getLogger((String)"pay");
    }

    public void execute(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Task");
        }
        this.waitScreen.setText(task.getMessage() != null ? task.getMessage() : B.get((String)"Dialog.wait"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskExecutor.this.applicationContext.showWait(TaskExecutor.this.waitScreen);
            }
        });
        ActiveRunnable ar = new ActiveRunnable();
        this.executorService.submit(ar);
        this.executorService.submit(new ExecutorThread(task, ar));
    }

    public Future submit(Callable callable) {
        return this.executorService.submit(callable);
    }

    private class ActiveRunnable
    implements Runnable {
        private boolean quit;

        private ActiveRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            ActiveRunnable activeRunnable = this;
            synchronized (activeRunnable) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.quit) {
                    TaskExecutor.this.log.info((Object)"||||  Make user action");
                    UserAction.getInstance().update();
                    ActiveRunnable activeRunnable = this;
                    synchronized (activeRunnable) {
                        this.wait(10000L);
                    }
                }
                UserAction.getInstance().update();
                TaskExecutor.this.log.info((Object)"||||  Stop activity emulator");
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class ResultRunnable
    implements Runnable {
        private final Object result;
        private final Task task;

        public ResultRunnable(Object result, Task task) {
            this.result = result;
            this.task = task;
        }

        @Override
        public void run() {
            this.task.onResult(this.result);
        }
    }

    private class ExecutorThread
    implements Runnable {
        private final Task task;
        private final ActiveRunnable ar;

        public ExecutorThread(Task task, ActiveRunnable ar) {
            this.task = task;
            this.ar = ar;
        }

        @Override
        public void run() {
            Object obj;
            UserAction.getInstance().update();
            try {
                obj = this.task.execute();
            }
            catch (Throwable ex) {
                obj = ex;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskExecutor.this.applicationContext.showWait(null);
                }
            });
            this.ar.quit();
            EventQueue.invokeLater(new ResultRunnable(obj, this.task));
        }
    }
}

