/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html.connector.websocket;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import ru.softlogic.app.html.connector.websocket.WebSocketMessageListener;

public class WebSocketServer {
    private static WebSocketServer server;
    private Channel channel;
    private Channel clientChannel;
    private final Logger log = Logger.getLogger((String)"gui");
    private WebSocketMessageListener messageListener;

    public static synchronized WebSocketServer getInstance() {
        if (server == null) {
            server = new WebSocketServer();
        }
        return server;
    }

    private WebSocketServer() {
    }

    public synchronized void addMessageListener(WebSocketMessageListener wml) {
        this.messageListener = wml;
    }

    public synchronized void start(int port) {
        if (this.channel == null) {
            this.log.debug((Object)"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u0443\u0435\u043c WebSocketServer");
            ServerBootstrap bootstrap = new ServerBootstrap();
            try {
                ((ServerBootstrap)bootstrap.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebSocketServerInitialize());
                this.log.debug((Object)("\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c WebSocketServer \u043d\u0430 \u043f\u043e\u0440\u0442 " + port));
                this.channel = bootstrap.bind(port).sync().channel();
            }
            catch (Exception e) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 WebSocketServer:", (Throwable)e);
                this.stop();
            }
        }
    }

    public synchronized void stop() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
            this.clientChannel = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        this.log.debug((Object)"WebSocketServer \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
    }

    public synchronized boolean sendMessage(String message) {
        if (this.clientChannel == null) {
            return false;
        }
        this.clientChannel.write((Object)new TextWebSocketFrame(message));
        this.log.debug((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 (chanelID: " + this.clientChannel.id() + ", response: " + message + ")"));
        return true;
    }

    private class WebSocketServerHandler
    extends ChannelInboundMessageHandlerAdapter<Object> {
        private static final String WEBSOCKET_PATH = "/telepay";
        private WebSocketServerHandshaker handshaker;

        private WebSocketServerHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof FullHttpRequest) {
                this.handleHttpRequest(ctx, (FullHttpRequest)msg);
            } else if (msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            }
        }

        private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
            if (!req.getDecoderResult().isSuccess()) {
                this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            } else if (req.getMethod() != HttpMethod.GET) {
                this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            } else if (WEBSOCKET_PATH.equals(req.getUri())) {
                WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(req), null, false);
                this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
                if (this.handshaker == null) {
                    WebSocketServerHandshakerFactory.sendUnsupportedWebSocketVersionResponse((Channel)ctx.channel());
                } else {
                    this.handshaker.handshake(ctx.channel(), req);
                }
            } else {
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                this.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            }
        }

        private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
            if (frame instanceof CloseWebSocketFrame) {
                frame.retain();
                this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame);
                return;
            }
            if (frame instanceof PingWebSocketFrame) {
                frame.data().retain();
                ctx.channel().write((Object)new PongWebSocketFrame(frame.data()));
                return;
            }
            if (!(frame instanceof TextWebSocketFrame)) {
                throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
            }
            WebSocketServer.this.clientChannel = ctx.channel();
            String request = ((TextWebSocketFrame)frame).text();
            WebSocketServer.this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0437\u0430\u043f\u0440\u043e\u0441 (chanelID: " + WebSocketServer.this.clientChannel.id() + ", request: " + request + ")"));
            WebSocketServer.this.messageListener.onMessage(request);
        }

        private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
            if (res.getStatus().code() != 200) {
                res.data().writeBytes(Unpooled.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
                HttpHeaders.setContentLength((HttpMessage)res, (long)res.data().readableBytes());
            }
            ChannelFuture f = ctx.channel().write((Object)res);
            if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        private String getWebSocketLocation(FullHttpRequest req) {
            return "ws://" + req.headers().get("Host") + WEBSOCKET_PATH;
        }
    }

    private class WebSocketServerInitialize
    extends ChannelInitializer<SocketChannel> {
        private WebSocketServerInitialize() {
        }

        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("handler", (ChannelHandler)new WebSocketServerHandler());
        }
    }
}

