/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html.connector.card;

import i18n.B;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import ru.softlogic.app.html.connector.InterfaceNotifier;
import ru.softlogic.app.html.connector.card.CardModuleHelper;
import ru.softlogic.app.html.connector.card.CardPaymentHtmlGL;
import ru.softlogic.app.html.connector.card.ConnectorListener;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.FinanceOperation;
import ru.softlogic.cards.v2.connector.model.OperationPurchaseResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.operation.CashlessData;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class HTMLCardPaymentModule {
    private CardPaymentHtmlGL guiListener;
    private CardModule cm;
    private volatile boolean invokeOperation;
    private Sum sumIncome;
    private Sum sumOutcome;
    private InterfaceNotifier notifier;
    private Logger log;

    public HTMLCardPaymentModule(Logger log, InterfaceNotifier notifier) {
        this.log = log;
        this.notifier = notifier;
        CardModuleStore.getInstance().isInit();
    }

    public boolean isInit() {
        return CardModuleStore.getInstance().isInit();
    }

    public boolean isReady() {
        return CardModuleStore.getInstance().isReady();
    }

    public boolean isCardReaderOnly() {
        return CardModuleStore.getInstance().isCardReaderOnly();
    }

    public void setNewCardPaymentHtmlGL() {
        this.guiListener = new CardPaymentHtmlGL(this.log, this.notifier);
    }

    public void setIntent(Intent intent) {
        if (this.guiListener != null) {
            this.guiListener.setIntent(intent);
        }
    }

    public void setPoint(Point p) {
        CardModuleStore.getInstance().setReference(p);
    }

    public void openSession() {
        this.cm = CardModuleStore.getInstance().getCurrentSession();
        if (this.cm != null) {
            CardModuleStore.getInstance().setUserEventInterfaceListener(this.guiListener);
        } else {
            this.cm = CardModuleStore.getInstance().openSession(this.guiListener);
        }
    }

    public CardModule getCm() {
        return this.cm;
    }

    public void setCm(CardModule cm) {
        this.cm = cm;
    }

    public void cancelSession(boolean reversSave) {
        CardModuleHelper.cancelSession(this.cm, reversSave, this.invokeOperation);
        this.setCm(null);
    }

    public boolean isNeedReverse() {
        return CardModuleStore.getInstance().isNeedReverse();
    }

    public FinanceOperation createFinanceOperation() {
        Pack pack = Session.getInstance().getCorrectPack();
        return new FinanceOperation(StoreHelper.convertDep(PackUtility.getData(pack)), (long)this.sumIncome.getBasicSum(), (long)this.sumIncome.sub(this.sumOutcome).getBasicSum(), null, this.getProperty("mcc"), this.getProperty("merchant-id") == null ? this.getProperty("vendor") : this.getProperty("merchant-id"));
    }

    public void purchase(FinanceOperation fo, ClientInterface ci, ConnectorListener cl, Service s) {
        this.cm.purchase(fo, (CardModuleResultListener)new LocalPurchaseListener(ci, cl, s));
    }

    public void setSumIncome(Sum sumIncome) {
        this.sumIncome = sumIncome;
    }

    public void setSumOutcome(Sum sumOutcome) {
        this.sumOutcome = sumOutcome;
    }

    public void setInvokeOperation(boolean invokeOperation) {
        this.invokeOperation = invokeOperation;
    }

    private String getProperty(String key) {
        return (String)Session.getInstance().getCorrectPack().getService().getProperties().get(key);
    }

    private void fillCardInfo(Map<String, Object> data, OperationPurchaseResult t, CardInfo ci, Locale locale) {
        this.log.info((Object)("OperationPurchaseResult: " + t));
        if (t.getAuthIdentResponse() != null) {
            data.put("auth", new InputElement("auth", B.get((String)"Module.card.cardinfo.auth", (Locale)locale), t.getAuthIdentResponse()));
        }
        if (t.getRrn() != null) {
            data.put("rrn", new InputElement("rrn", B.get((String)"Module.card.cardinfo.rrn", (Locale)locale), t.getRrn()));
        }
        InputElement curr = new InputElement("curr", B.get((String)"Module.card.account.currency", (Locale)locale), B.get((String)("Module.card.currency.code." + t.getCurrency().getDigitCode()), (Locale)locale, (String)(t.getCurrency() == null ? "" : t.getCurrency().getDigitCode())));
        InputElement merchant = new InputElement("merchant", B.get((String)"Module.card.cardinfo.merchant", (Locale)locale), t.getMerchant());
        InputElement stan = new InputElement("stan", B.get((String)"Module.card.cardinfo.stan", (Locale)locale), t.getStan());
        InputElement terminal = new InputElement("terminal", B.get((String)"Module.card.cardinfo.terminal", (Locale)locale), t.getTerminal());
        InputElement cashless = new InputElement("is-cashless", B.get((String)"Module.card.cashless", (Locale)locale, (String)"\u0411\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u0430\u044f \u043e\u043f\u043b\u0430\u0442\u0430 "), "true");
        InputElement pan = new InputElement("account-client", B.get((String)"Module.card.pan", (Locale)locale, (String)"PAN"), ci.getPan());
        data.put("curr", curr);
        data.put("merchant", merchant);
        data.put("stan", stan);
        data.put("terminal", terminal);
        data.put("is-cashless", cashless);
        data.put("account-client", pan);
    }

    private class LocalPurchaseListener
    implements CardModuleResultListener<OperationPurchaseResult> {
        private final ClientInterface clientInterface;
        private final ConnectorListener connectorListener;
        private Service service;

        public LocalPurchaseListener(ClientInterface ci, ConnectorListener cl, Service s) {
            this.clientInterface = ci;
            this.connectorListener = cl;
            this.service = s;
        }

        public void onError(CardModuleError cme, String message, CardInfo ci) {
            HTMLCardPaymentModule.this.setInvokeOperation(false);
            HTMLCardPaymentModule.this.log.info((Object)(">>>onError " + cme + ", " + message));
            UserAction.getInstance().update();
            this.clientInterface.sendEvent(new Event(EventType.Warning, "CardPaymentError(initiator=" + message + ")"));
            if (cme == CardModuleError.ERROR_USER_CANCEL) {
                HTMLCardPaymentModule.this.log.info((Object)"*  \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c, \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435: 1");
                HTMLCardPaymentModule.this.notifier.onCMEvent(1, null);
                CardModuleHelper.closeSessionAndReverse(false);
                this.connectorListener.onCancel(1);
            } else {
                if ((this.service.getPaymentSchemaFlags() & 1) > 0) {
                    this.connectorListener.menuItemRevert();
                    HTMLCardPaymentModule.this.log.info((Object)"*  \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435: 2");
                    if (message == null || message.isEmpty()) {
                        HTMLCardPaymentModule.this.notifier.onCMEvent(2, null);
                    } else {
                        HTMLCardPaymentModule.this.notifier.onCMEvent(2, MessageFormat.format(B.get((String)"Provider.card.error3.tocash", (Locale)Locale.getDefault()), B.get((String)message, (Locale)Locale.getDefault(), (String)message)));
                    }
                } else if (message == null || message.isEmpty()) {
                    this.connectorListener.menuItemRevert();
                    HTMLCardPaymentModule.this.log.info((Object)"*  \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435: 3");
                    HTMLCardPaymentModule.this.notifier.onCMEvent(3, null);
                } else {
                    this.connectorListener.menuItemRevert();
                    HTMLCardPaymentModule.this.log.info((Object)"*  \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435: 3");
                    HTMLCardPaymentModule.this.notifier.onCMEvent(3, MessageFormat.format(B.get((String)"Provider.card.error3", (Locale)Locale.getDefault()), B.get((String)message, (Locale)Locale.getDefault(), (String)message)));
                }
                CardModuleHelper.closeSessionAndReverse(false);
            }
        }

        public void onResult(OperationPurchaseResult t, CardInfo ci) {
            HTMLCardPaymentModule.this.setInvokeOperation(false);
            UserAction.getInstance().update();
            HTMLCardPaymentModule.this.log.info((Object)">>>onSuccess");
            Pack pack = Session.getInstance().getCorrectPack();
            Keeper keeper = new Keeper();
            if (pack.getKeeper() != null) {
                keeper = pack.getKeeper();
            }
            keeper.addPayback(HTMLCardPaymentModule.this.sumIncome);
            Payment p = (Payment)Session.getInstance().getCorrectPack().getPayments().get(0);
            p.setSumOut(HTMLCardPaymentModule.this.sumOutcome);
            HTMLCardPaymentModule.this.fillCardInfo(p.getData(), t, ci, Locale.getDefault());
            pack.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), HTMLCardPaymentModule.this.sumOutcome, HTMLCardPaymentModule.this.sumOutcome, HTMLCardPaymentModule.this.sumIncome.sub(HTMLCardPaymentModule.this.sumOutcome), keeper.getSum().sub(HTMLCardPaymentModule.this.sumIncome), pack.getProviderFee(), null));
            pack.setKeeper(keeper);
            pack.setPaymentTool(ci.isIinCard() ? 2 : 3);
            pack.setCashlessData(new CashlessData(ci.getPan(), ci.getCardholderName() == null ? "-" : ci.getCardholderName(), "" + ModuleHelper.getPoint().getId(), "", "", "", t.getRrn(), t.getAuthIdentResponse()));
            if (ModuleHelper.isCardRevert()) {
                ExecutorService es = Executors.newSingleThreadExecutor();
                es.submit(new Callable(){

                    public Object call() throws Exception {
                        LocalPurchaseListener.this.connectorListener.processCardPayment(false);
                        CardModuleStore.getInstance().closeSessionSafe(true);
                        return null;
                    }
                });
                es.shutdown();
            } else {
                Intent i = new Intent(){

                    @Override
                    public void process() {
                        LocalPurchaseListener.this.connectorListener.processCardPayment(false);
                    }

                    @Override
                    public int getType() {
                        return 1;
                    }
                };
                HTMLCardPaymentModule.this.guiListener.setIntent(i);
                CardModuleStore.getInstance().closeSessionSafe(true);
            }
        }

        public void onCardData(CardData cd) {
        }
    }
}

