/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.app.FrameStore;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.ReturnService;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.app.task.TaskExecutor;
import ru.softlogic.application.CurrentModuleTypeStore;
import ru.softlogic.application.JammInformer;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.gui.GuiContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.ContentScreen;
import ru.softlogic.gui.screen.popup.PopupScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.screen.shell.Shell;
import ru.softlogic.gui.utils.menu.GroupByLabelVisitor;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.hardware.device.print.queue.PrinterQueue;
import ru.softlogic.hardware.device.watchdog.WatchDog;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.Module;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.ModuleStore;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.module.completive.MainCompletiveModule;
import ru.softlogic.module.ending.EndingModule;
import ru.softlogic.module.ending.SimpleEndingModule;
import ru.softlogic.module.entry.EntryModule;
import ru.softlogic.module.entry.MenuEntryModule;
import ru.softlogic.module.lock.GuiLockModule;
import ru.softlogic.module.lock.LockModule;
import ru.softlogic.module.payment.DispatchPaymentModule;
import ru.softlogic.module.payment.PaymentModule;
import ru.softlogic.module.payout.PayoutModule;
import ru.softlogic.module.payout.PayoutModuleDispatcher;
import ru.softlogic.module.present.MainPresentModule;
import ru.softlogic.module.print.ObsoletePrintModule;
import ru.softlogic.module.print.PrintModule;
import ru.softlogic.module.processing.ProcessingModule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.BannerNotifier;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.fraud.FraudQueue;

public class BaseApplicationContext
implements ApplicationContext {
    private Shell shell;
    private PrinterQueue printerQueue;
    private FraudQueue fraudQueue;
    private ClientInterface clientInterface;
    private Logger log;
    private ExecutorService contextExecutor;
    private WatchDog watchDog;
    private TaskExecutor taskExecutor;
    private ModuleStore moduleStore;
    private EntryModule entryModule;
    private LockModule lockModule;
    private PaymentModule paymentModule;
    private PayoutModule payoutModule;
    private ProcessingModule processingModule;
    private PrintModule printModule;
    private EndingModule endingModule;

    public BaseApplicationContext(PrinterQueue printerQueue, ClientInterface clientInterface, FraudQueue fraudQueue, JammInformer jammInformer, WatchDog watchDog, ScheduledExecutorService scheduler) {
        if (printerQueue == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 PrinterQueue");
        }
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ServerConnector");
        }
        if (jammInformer == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 JammInformer");
        }
        this.log = Logger.getLogger((String)"gui");
        this.log.setAdditivity(false);
        this.printerQueue = printerQueue;
        this.clientInterface = clientInterface;
        this.fraudQueue = fraudQueue;
        this.watchDog = watchDog;
        this.shell = ComponentFactory.getInstance().createShell();
        this.shell.setGuiContext((GuiContext)this);
        FrameStore.getFrame().getContentPane().add(this.shell.getPanel());
        BannerNotifier.setDefaultInstance(new BannerNotifier(this.shell));
        this.taskExecutor = new TaskExecutor(this);
        this.contextExecutor = Executors.newFixedThreadPool(3);
        this.paymentModule = new DispatchPaymentModule(this);
        this.payoutModule = new PayoutModuleDispatcher(this);
        this.processingModule = ModuleFactory.getDefaultProcessingModule(this);
        this.printModule = new ObsoletePrintModule(this);
        this.endingModule = new SimpleEndingModule(this);
        this.entryModule = new MenuEntryModule(this, this.paymentModule, this.payoutModule, this.processingModule, this.printModule, this.endingModule, new MainPresentModule(this), new MainCompletiveModule(this));
        this.lockModule = new GuiLockModule(this);
        this.moduleStore = new ModuleStore();
        this.moduleStore.addListener(SafeReboot.getInstance());
        this.moduleStore.addListener(((MenuEntryModule)this.entryModule).getEmptyUserActionsListener());
        this.moduleStore.addListener(BannerNotifier.getDefaultInstance());
        this.moduleStore.addListener(CurrentModuleTypeStore.getInstance());
        this.initModulesChanges();
        scheduler.scheduleAtFixedRate(new ReturnService(this, this.moduleStore), 10L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public ClientInterface getServerConnector() {
        return this.clientInterface;
    }

    @Override
    public PrinterQueue getPrinterQueue() {
        return this.printerQueue;
    }

    @Override
    public FraudQueue getFraudQueue() {
        return this.fraudQueue;
    }

    @Override
    public ModuleStore getModuleStore() {
        return this.moduleStore;
    }

    public ExecutorService getContextExecutor() {
        return this.contextExecutor;
    }

    public void setContextExecutor(ExecutorService contextExecutor) {
        this.contextExecutor = contextExecutor;
    }

    @Override
    public void toMainMenu() {
        this.toMainMenu(null, null);
    }

    @Override
    public void toMainMenu(Intent intent) {
        this.toMainMenu(null, null, intent);
    }

    public void showScreen(ContentScreen screen) {
        this.shell.showContent(screen);
    }

    public void showWait(WaitScreen waitScreen) {
        this.shell.showPopup((PopupScreen)waitScreen);
    }

    public void showDialog(DialogInterface dialogScreen) {
        dialogScreen.show(this.shell);
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public WatchDog getWatchDog() {
        return this.watchDog;
    }

    @Override
    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    public void setModule(Module module) {
        this.moduleStore.setModule(module);
    }

    public void toMainMenu(ServiceType st, MenuItem mi) {
        this.toMainMenu(st, mi, null);
    }

    public void toMainMenu(ServiceType st, MenuItem mi, Intent intent) {
        this.log.info((Object)"Return to main menu");
        this.shell.showPopup(null);
        TerminalState state = StateFacade.getState();
        this.log.info((Object)("Current terminal state: " + state + (state.getErrorCode() != 0 ? "(fatal)" : "")));
        if (state.getErrorCode() != 0) {
            this.lockModule.start();
        } else {
            this.entryModule.start(st, mi, intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModulesChanges() {
        FileInputStream fis = null;
        try {
            String className;
            fis = new FileInputStream(new File(PathUtils.getAppHome() + "/resources/modules.properties"));
            Properties prop = new Properties();
            prop.load(fis);
            this.log.info((Object)"Load module change listeners");
            for (int i = 0; i < 10 && (className = prop.getProperty("module.change." + i + ".class")) != null; ++i) {
                this.log.info((Object)("  Load class: " + className));
                try {
                    Object obj = Class.forName(className).newInstance();
                    if (!(obj instanceof ModuleTypeListener)) {
                        throw new Exception("Class is not implement ModuleTypeListener");
                    }
                    ModuleTypeListener mtl = (ModuleTypeListener)obj;
                    this.log.info((Object)("  Add listener: " + mtl.getClass().getCanonicalName()));
                    this.moduleStore.addListener(mtl);
                    continue;
                }
                catch (Exception ex) {
                    this.log.error((Object)("Can't create class: " + ex.getMessage()));
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        catch (FileNotFoundException prop) {
            IOUtils.closeQuietly(fis);
        }
        catch (IOException ex) {
            this.log.info((Object)ex, (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    @Override
    public void toMainMenu(int targetId) {
        MenuByServiceIdVisitor v = new MenuByServiceIdVisitor(targetId);
        MenuUtils.processMenu((MenuVisitor)v);
        this.toMainMenu(null, v.getMenuItem());
    }

    @Override
    public void toMainMenuGroup(int label) {
        GroupByLabelVisitor visitor = new GroupByLabelVisitor(label);
        MenuUtils.processMenu((MenuVisitor)visitor);
        this.toMainMenu(visitor.getServiceType(), null);
    }

    public boolean isCanRedirect() {
        return this.getModuleStore().getModule().getType() == 1 || this.getModuleStore().getModule().getType() == 2;
    }
}

