/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import ru.softlogic.app.Application;
import ru.softlogic.app.ApplicationException;
import ru.softlogic.system.util.ThreadUtil;

public class Commander {
    private static final int port = 10555;
    private static final String cmdStop = "stop";
    private Application application;
    private ServerSocket serverSocket;
    private Logger log;

    public Commander(Application application) throws ApplicationException {
        this.application = application;
        this.log = Logger.getLogger((String)"start");
        this.log.setAdditivity(false);
        try {
            this.serverSocket = new ServerSocket(10555);
            Thread th = new Thread((Runnable)new SocketListener(), "NetworkCommandListener");
            th.setDaemon(true);
            th.start();
        }
        catch (IOException ex) {
            throw new ApplicationException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a 10555 \u043f\u043e\u0440\u0442\u0443. ", ex);
        }
    }

    public static void shutdown() throws ApplicationException {
        Socket socket = null;
        try {
            socket = new Socket("127.0.0.1", 10555);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            bw.write("stop\n");
            bw.flush();
        }
        catch (IOException ex) {
            throw new ApplicationException(ex);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private class SocketListener
    implements Runnable {
        private SocketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Commander.this.log.info((Object)"Start thread");
            while (!Thread.currentThread().isInterrupted()) {
                Socket socket = null;
                try {
                    Commander.this.log.info((Object)"\u041e\u0436\u0438\u0434\u0430\u044e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                    socket = Commander.this.serverSocket.accept();
                    Commander.this.log.info((Object)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
                    socket.setSoTimeout(10000);
                    BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    String cmd = br.readLine();
                    if (cmd != null) {
                        if (cmd.equals(Commander.cmdStop)) {
                            bw.write("Stoping application");
                            Commander.this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
                            if (Commander.this.application != null) {
                                Commander.this.application.stop();
                            }
                        } else {
                            Commander.this.log.error((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u0430: " + cmd));
                        }
                    } else {
                        Commander.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445");
                    }
                }
                catch (Exception ex) {
                    Commander.this.log.error((Object)ex);
                }
                finally {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                ThreadUtil.sleep((long)1000L);
            }
            try {
                Commander.this.serverSocket.close();
            }
            catch (Exception ex) {
                Commander.this.log.error((Object)ex, (Throwable)ex);
            }
            Commander.this.log.info((Object)"Stop thread");
        }
    }
}

