/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.panels.present;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.configurator.Application;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.present.ExternalPresentPanel;
import ru.softlogic.configurator.panels.present.InternalPresentPanel;
import ru.softlogic.configurator.panels.present.NetworkPresentPanel;

public class PresentPanel
extends JPanel {
    private final LazyInitializator initializator;
    private final NetworkPresentPanel npp;
    private final ExternalPresentPanel epp;
    private final InternalPresentPanel ipp;
    private JPanel actionPanel;
    private JPanel contentPanel;
    private JButton exitButton;
    private JButton saveButton;
    private JComboBox typeComboBox;
    private JLabel typeLabel;

    public PresentPanel(LazyInitializator initializator) {
        this.initializator = initializator;
        this.initComponents();
        ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.jdesktop.application.Application.class).getContext().getResourceMap(PresentPanel.class);
        LinkedList<ComboBoxItem> items = new LinkedList<ComboBoxItem>();
        items.add(new ComboBoxItem(null, NameExtractor.getUndefinedName()));
        items.add(new ComboBoxItem("NetworkModule", NameExtractor.getComboBoxTitle(resourceMap.getString("PrinterPanel.type.network", new Object[0]))));
        items.add(new ComboBoxItem("InternalModule", NameExtractor.getComboBoxTitle(resourceMap.getString("PrinterPanel.type.internal", new Object[0]))));
        items.add(new ComboBoxItem("ExternalModule", NameExtractor.getComboBoxTitle(resourceMap.getString("PrinterPanel.type.external", new Object[0]))));
        this.typeComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(items.toArray(new ComboBoxItem[items.size()])));
        this.typeComboBox.setSelectedIndex(0);
        this.npp = new NetworkPresentPanel();
        this.epp = new ExternalPresentPanel();
        this.ipp = new InternalPresentPanel();
    }

    public NetworkPresentPanel getNetworkPresentPanel() {
        return this.npp;
    }

    public ExternalPresentPanel getExternalPresentPanel() {
        return this.epp;
    }

    public InternalPresentPanel getInternalPresentPanel() {
        return this.ipp;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getExitButton() {
        return this.exitButton;
    }

    public JComboBox getTypeComboBox() {
        return this.typeComboBox;
    }

    private void initComponents() {
        this.actionPanel = new JPanel();
        this.saveButton = new JButton();
        this.exitButton = new JButton();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.contentPanel = new JPanel();
        ResourceMap resourceMap = ((Application)org.jdesktop.application.Application.getInstance(Application.class)).getContext().getResourceMap(PresentPanel.class);
        this.actionPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("actions.title", new Object[0]), 0, 0, new Font("Tahoma", 0, 15)));
        this.saveButton.setFont(new Font("Tahoma", 0, 15));
        this.saveButton.setText(resourceMap.getString("actions.saveButton.text", new Object[0]));
        this.exitButton.setFont(new Font("Tahoma", 0, 15));
        this.exitButton.setText(resourceMap.getString("actions.exitButton.text", new Object[0]));
        GroupLayout actionPanelLayout = new GroupLayout(this.actionPanel);
        this.actionPanel.setLayout(actionPanelLayout);
        actionPanelLayout.setHorizontalGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, actionPanelLayout.createSequentialGroup().addContainerGap().addGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveButton, GroupLayout.Alignment.LEADING, -2, 228, -2).addComponent(this.exitButton, GroupLayout.Alignment.LEADING, -1, 228, Short.MAX_VALUE)).addContainerGap()));
        actionPanelLayout.setVerticalGroup(actionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, actionPanelLayout.createSequentialGroup().addContainerGap(374, Short.MAX_VALUE).addComponent(this.saveButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton, -2, 35, -2).addContainerGap()));
        this.typeLabel.setFont(new Font("Tahoma", 0, 15));
        this.typeLabel.setText(resourceMap.getString("PresentPanel.typeLabel.text", new Object[0]));
        this.typeComboBox.setFont(new Font("Tahoma", 0, 15));
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PresentPanel.this.typeComboBoxItemStateChanged(evt);
            }
        });
        this.contentPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.actionPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 418, Short.MAX_VALUE).addComponent(this.typeComboBox, 0, 418, Short.MAX_VALUE).addComponent(this.typeLabel, -1, 418, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, -2, 35, -2).addGap(18, 18, 18).addComponent(this.contentPanel, -1, 411, Short.MAX_VALUE)).addComponent(this.actionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void typeComboBoxItemStateChanged(ItemEvent evt) {
        if (evt != null && evt.getStateChange() == 1) {
            String type;
            this.contentPanel.setVisible(false);
            this.contentPanel.removeAll();
            ComboBoxItem cbi = (ComboBoxItem)evt.getItem();
            if (cbi != null && (type = (String)cbi.getObject()) != null) {
                if ("NetworkModule".equals(type)) {
                    this.contentPanel.add(this.npp);
                } else if ("InternalModule".equals(type)) {
                    this.contentPanel.add(this.ipp);
                } else if ("ExternalModule".equals(type)) {
                    this.contentPanel.add(this.epp);
                }
            }
            this.initializator.updateGui();
            this.contentPanel.setVisible(true);
        }
    }
}

