/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.panels.barcode;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.configurator.Application;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.barcode.SerialBarcodePanel;
import ru.softlogic.hardware.device.scanner.BarcodeScannerType;

public class BarcodePanel
extends JPanel {
    private final LazyInitializator initializator;
    private final SerialBarcodePanel serialBarcodePanel;
    private JPanel actionsPanel;
    private JPanel contentPanel;
    private JButton exitButton;
    private JSeparator jSeparator1;
    private JButton portConfButton;
    private JButton saveButton;
    private JButton scanButton;
    private JButton scanPortsButton;
    private JComboBox typeComboBox;
    private JLabel typeLabel;

    public BarcodePanel(LazyInitializator initializator) {
        this.initializator = initializator;
        this.initComponents();
        ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.jdesktop.application.Application.class).getContext().getResourceMap(BarcodePanel.class);
        LinkedList<ComboBoxItem> items = new LinkedList<ComboBoxItem>();
        items.add(new ComboBoxItem(null, NameExtractor.getUndefinedName()));
        items.add(new ComboBoxItem(BarcodeScannerType.Serial, NameExtractor.getComboBoxTitle(resourceMap.getString("BarcodePanel.type.serial", new Object[0]))));
        items.add(new ComboBoxItem(BarcodeScannerType.Keyboard, NameExtractor.getComboBoxTitle(resourceMap.getString("BarcodePanel.type.keyboard", new Object[0]))));
        this.typeComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(items.toArray(new ComboBoxItem[items.size()])));
        this.typeComboBox.setSelectedIndex(0);
        this.contentPanel.setVisible(false);
        this.serialBarcodePanel = new SerialBarcodePanel();
        this.contentPanel.add(this.serialBarcodePanel);
    }

    public JButton getExitButton() {
        return this.exitButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getScanButton() {
        return this.scanButton;
    }

    public JButton getScanPortsButton() {
        return this.scanPortsButton;
    }

    public SerialBarcodePanel getSerialBarcodePanel() {
        return this.serialBarcodePanel;
    }

    public JComboBox getTypeComboBox() {
        return this.typeComboBox;
    }

    public JButton getPortConfButton() {
        return this.portConfButton;
    }

    private void initComponents() {
        this.actionsPanel = new JPanel();
        this.scanButton = new JButton();
        this.exitButton = new JButton();
        this.saveButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.portConfButton = new JButton();
        this.scanPortsButton = new JButton();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.contentPanel = new JPanel();
        ResourceMap resourceMap = ((Application)org.jdesktop.application.Application.getInstance(Application.class)).getContext().getResourceMap(BarcodePanel.class);
        this.actionsPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("actions.title", new Object[0]), 0, 0, new Font("Tahoma", 0, 15)));
        this.scanButton.setFont(new Font("Tahoma", 0, 15));
        this.scanButton.setText(resourceMap.getString("BarcodePanel.scanButton.text", new Object[0]));
        this.exitButton.setFont(new Font("Tahoma", 0, 15));
        this.exitButton.setText(resourceMap.getString("actions.exitButton.text", new Object[0]));
        this.saveButton.setFont(new Font("Tahoma", 0, 15));
        this.saveButton.setText(resourceMap.getString("actions.saveButton.text", new Object[0]));
        this.portConfButton.setFont(new Font("Tahoma", 0, 15));
        this.portConfButton.setText(resourceMap.getString("actions.portConfButton.text", new Object[0]));
        this.scanPortsButton.setFont(new Font("Tahoma", 0, 15));
        this.scanPortsButton.setText(resourceMap.getString("actions.scanPortsButton.text", new Object[0]));
        GroupLayout actionsPanelLayout = new GroupLayout(this.actionsPanel);
        this.actionsPanel.setLayout(actionsPanelLayout);
        actionsPanelLayout.setHorizontalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 228, Short.MAX_VALUE).addComponent(this.exitButton, GroupLayout.Alignment.TRAILING, -1, 228, Short.MAX_VALUE).addComponent(this.saveButton, -1, 228, Short.MAX_VALUE).addComponent(this.scanButton, -1, 228, Short.MAX_VALUE).addComponent(this.portConfButton, -1, 228, Short.MAX_VALUE).addComponent(this.scanPortsButton, -1, 228, Short.MAX_VALUE)).addContainerGap()));
        actionsPanelLayout.setVerticalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, actionsPanelLayout.createSequentialGroup().addComponent(this.scanButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portConfButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanPortsButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 155, Short.MAX_VALUE).addComponent(this.saveButton, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton, -2, 35, -2).addContainerGap()));
        this.typeLabel.setFont(new Font("Tahoma", 0, 15));
        this.typeLabel.setText(resourceMap.getString("BarcodePanel.systemTypeLabel.text", new Object[0]));
        this.typeComboBox.setFont(new Font("Tahoma", 0, 15));
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BarcodePanel.this.typeComboBoxItemStateChanged(evt);
            }
        });
        this.contentPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.actionsPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 386, Short.MAX_VALUE).addComponent(this.typeLabel, -1, 386, Short.MAX_VALUE).addComponent(this.typeComboBox, 0, 386, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, -2, 35, -2).addGap(18, 18, 18).addComponent(this.contentPanel, -1, 322, Short.MAX_VALUE)).addComponent(this.actionsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void typeComboBoxItemStateChanged(ItemEvent evt) {
        if (evt != null && evt.getStateChange() == 1) {
            BarcodeScannerType bst;
            this.contentPanel.setVisible(false);
            ComboBoxItem cbi = (ComboBoxItem)evt.getItem();
            if (cbi != null && (bst = (BarcodeScannerType)cbi.getObject()) == BarcodeScannerType.Serial) {
                this.contentPanel.setVisible(true);
            }
            this.initializator.updateGui();
        }
    }
}

