/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.keyboard;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.configurator.keyboard.KeyBoardListener;
import ru.softlogic.configurator.keyboard.ScreenKeyboard;
import ru.softlogic.configurator.utils.DialogUtils;

public class LetterKeyboardDialog
extends ScreenKeyboard {
    private String text;
    private KeyBoardListener keyBoardListener;
    private int maxLen;
    private JButton buttonCaps;
    private JButton buttonX;
    private JButton buttonC;
    private JButton buttonOk;
    private JButton buttonCancel;
    private List<JButton> buttons;
    private JPanel actionPanel;
    private JPanel keyPanel;
    private JLabel titleLabel;
    private JTextField valueTextField;

    public LetterKeyboardDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.postInit();
    }

    public LetterKeyboardDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.postInit();
    }

    private void postInit() {
        this.initComponents();
        this.setSize(790, 360);
        this.setMaximumSize(new Dimension(790, 450));
        this.text = "0123456789abcdefghijklmnopqrstuvwxyz-.~/";
        this.buttons = new LinkedList<JButton>();
        LocalActionListener al = new LocalActionListener();
        for (int i = 0; i < this.text.length(); ++i) {
            JButton button = new JButton("" + this.text.charAt(i));
            button.setFont(this.valueTextField.getFont());
            button.addActionListener(al);
            button.setBorder(null);
            button.setMargin(new Insets(0, 0, 0, 0));
            this.buttons.add(button);
            this.keyPanel.add(button);
        }
        this.buttonCaps = new JButton("Caps");
        this.buttonCaps.setFont(this.valueTextField.getFont());
        this.buttonCaps.addActionListener(al);
        this.actionPanel.add(this.buttonCaps);
        this.buttonX = new JButton("X");
        this.buttonX.setFont(this.valueTextField.getFont());
        this.buttonX.addActionListener(al);
        this.actionPanel.add(this.buttonX);
        this.buttonC = new JButton("\u2190");
        this.buttonC.setFont(this.valueTextField.getFont());
        this.buttonC.addActionListener(al);
        this.actionPanel.add(this.buttonC);
        ResourceMap resourceMap = Application.getInstance(Application.class).getContext().getResourceMap(LetterKeyboardDialog.class);
        this.buttonOk = new JButton(resourceMap.getString("KeyBoardPanel.saveButton.text", new Object[0]));
        this.buttonOk.setFont(this.valueTextField.getFont());
        this.buttonOk.addActionListener(new LocalSaveListener());
        this.buttonOk.setMargin(new Insets(0, 0, 0, 0));
        this.actionPanel.add(this.buttonOk);
        this.buttonCancel = new JButton(resourceMap.getString("KeyBoardPanel.exitButton.text", new Object[0]));
        this.buttonCancel.setFont(this.valueTextField.getFont());
        this.buttonCancel.addActionListener(new LocalExitListener());
        this.buttonCancel.setMargin(new Insets(0, 0, 0, 0));
        this.actionPanel.add(this.buttonCancel);
        DialogUtils.setEscapeAction(this);
    }

    @Override
    public void setKeyBoardListener(KeyBoardListener keyBoardListener) {
        this.keyBoardListener = keyBoardListener;
    }

    @Override
    public void init(String value, int maxLen, boolean showExtSymbols, String title) {
        this.valueTextField.setText(value);
        this.titleLabel.setText(title);
        this.maxLen = maxLen;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.valueTextField = new JTextField();
        this.keyPanel = new JPanel();
        this.actionPanel = new JPanel();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.titleLabel.setFont(new Font("Tahoma", 0, 20));
        this.titleLabel.setText("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
        this.valueTextField.setEditable(false);
        this.valueTextField.setFont(new Font("Arial", 0, 22));
        this.valueTextField.setText("1");
        this.keyPanel.setLayout(new GridLayout(4, 10, 5, 5));
        this.actionPanel.setLayout(new GridLayout(5, 1, 5, 5));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.valueTextField, GroupLayout.Alignment.LEADING).addComponent(this.titleLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.keyPanel, -2, 603, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.actionPanel, -2, 157, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueTextField, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionPanel, -2, 213, -2).addComponent(this.keyPanel, -2, 213, -2)).addContainerGap()));
        this.pack();
    }

    private class LocalSaveListener
    implements ActionListener {
        private LocalSaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LetterKeyboardDialog.this.keyBoardListener != null) {
                LetterKeyboardDialog.this.keyBoardListener.onResult(LetterKeyboardDialog.this.valueTextField.getText());
            } else {
                LetterKeyboardDialog.this.setVisible(false);
            }
        }
    }

    private class LocalExitListener
    implements ActionListener {
        private LocalExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LetterKeyboardDialog.this.setVisible(false);
        }
    }

    private class LocalActionListener
    implements ActionListener {
        private boolean capsPressed;

        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LetterKeyboardDialog.this.buttonC) {
                if (LetterKeyboardDialog.this.valueTextField.getText().length() > 0) {
                    LetterKeyboardDialog.this.valueTextField.setText(LetterKeyboardDialog.this.valueTextField.getText().substring(0, LetterKeyboardDialog.this.valueTextField.getText().length() - 1));
                }
            } else if (e.getSource() == LetterKeyboardDialog.this.buttonX) {
                LetterKeyboardDialog.this.valueTextField.setText("");
            } else if (e.getSource() == LetterKeyboardDialog.this.buttonCaps) {
                if (this.capsPressed) {
                    for (JButton b : LetterKeyboardDialog.this.buttons) {
                        b.setText(b.getText().toLowerCase());
                    }
                } else {
                    for (JButton b : LetterKeyboardDialog.this.buttons) {
                        b.setText(b.getText().toUpperCase());
                    }
                }
                this.capsPressed = !this.capsPressed;
            } else {
                String newVal = LetterKeyboardDialog.this.valueTextField.getText() + ((JButton)e.getSource()).getText();
                if (newVal.length() <= LetterKeyboardDialog.this.maxLen) {
                    LetterKeyboardDialog.this.valueTextField.setText(newVal);
                }
            }
        }
    }
}

