/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.tasks;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import ru.softlogic.configurator.TerminalKey;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.keyclient.GenerateException;
import ru.softlogic.keyclient.KeyClient;
import ru.softlogic.keyclient.KeyClientException;
import ru.softlogic.keyclient.KeyClientMessageExtractor;
import ru.softlogic.keyclient.PointKeyResult;
import ru.softlogic.keyclient.X509Generator;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.hwd.SerialExtractorApi;

public class LoadKeyTask
extends Task {
    private final String login;
    private final String password;
    private final LazyInitializator initializator;

    public LoadKeyTask(String login, String password, LazyInitializator initializator) {
        this.login = login;
        this.password = password;
        this.initializator = initializator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() {
        try {
            Properties properties = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(PathUtils.getAppHome() + "/resources/key-server.properties");
                properties.load(fis);
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(fis);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            String url = properties.getProperty("url");
            if (url == null || url.isEmpty()) {
                throw new Exception(B.get("LoadKeyDialog.error.config.url"));
            }
            X509Generator.EncodedKeyPair pair = X509Generator.generatePrivateKey();
            KeyClient client = new KeyClient(url, Long.valueOf(SerialExtractorApi.getInstance().getConfigurationId()));
            PointKeyResult pkr = client.sendPointKey(this.login, this.password, pair.getPublicKey());
            if (pkr.getError() != 0) {
                throw new Exception(KeyClientMessageExtractor.getMessage((int)pkr.getError()));
            }
            TerminalKey tk = new TerminalKey(pair.getPrivateKey(), pair.getPublicKey(), pkr.getOpenServerKey(), pkr.getServerAddress(), pkr.getHttpPort(), pkr.getHttpsPort(), Integer.parseInt(this.login));
            return tk;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        if (object instanceof Exception) {
            Exception ex = (Exception)object;
            if (object instanceof IOException) {
                this.initializator.getDialog(B.get("LoadKeyDialog.error.config"), true);
            } else if (object instanceof GenerateException) {
                this.initializator.getDialog(B.get("LoadKeyDialog.error.generate"), true);
            } else if (object instanceof KeyClientException) {
                this.initializator.getDialog(B.get("LoadKeyDialog.error.network") + ": " + ex.getMessage(), true);
            } else {
                this.initializator.getDialog(ex.getMessage(), true);
            }
            this.initializator.getLoadKeyDialog().setVisible(true);
        } else {
            this.initializator.loadTerminalKey((TerminalKey)object);
        }
    }
}

