/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.tasks;

import java.awt.GraphicsEnvironment;
import java.util.LinkedList;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.print.IppPrinterPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;

public class IppInitTask
extends Task {
    private final IppPrinterPanel panel;
    private final Logger log;

    public IppInitTask(IppPrinterPanel panel) {
        super(B.get("task.ipp.title"));
        this.panel = panel;
        panel.getPrintersComboBox().setEnabled(false);
        this.log = Logger.getLogger((String)"scanner");
    }

    @Override
    public Object execute() {
        this.log.info((Object)B.get("task.ipp.start"));
        return new Result(PrintServiceLookup.lookupPrintServices(null, null), PrintServiceLookup.lookupDefaultPrintService());
    }

    @Override
    public void onResult(Object object) {
        this.log.info((Object)B.get("task.ipp.finish"));
        if (object != null) {
            Result result = (Result)object;
            PrintService[] ps = result.getServices();
            LinkedList<ComboBoxItem> model = new LinkedList<ComboBoxItem>();
            model.add(new ComboBoxItem(null, NameExtractor.getComboBoxTitle(NameExtractor.getUndefinedName())));
            for (PrintService p : ps) {
                model.add(new ComboBoxItem(p.getName(), NameExtractor.getComboBoxTitle(p.getName())));
            }
            ComboBoxItem[] items = model.toArray(new ComboBoxItem[model.size()]);
            this.panel.getPrintersComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
            if (result.getDefaultService() != null) {
                this.panel.setDefaultPrinter(result.getDefaultService().getName());
            }
        }
        this.panel.getPrintersComboBox().setEnabled(true);
        LinkedList<ComboBoxItem> model = new LinkedList<ComboBoxItem>();
        model.add(new ComboBoxItem(null, NameExtractor.getComboBoxTitle(NameExtractor.getUndefinedName())));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] names = ge.getAvailableFontFamilyNames();
        if (names != null) {
            for (String name : names) {
                model.add(new ComboBoxItem(name, NameExtractor.getComboBoxTitle(name)));
            }
        }
        this.panel.getFontsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model.toArray(new ComboBoxItem[model.size()])));
    }

    private class Result {
        private final PrintService[] services;
        private final PrintService defaultService;

        public Result(PrintService[] services, PrintService defaultService) {
            this.services = services;
            this.defaultService = defaultService;
        }

        public PrintService getDefaultService() {
            return this.defaultService;
        }

        public PrintService[] getServices() {
            return this.services;
        }
    }
}

