/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.application.kkm.SimpleKkmControl;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.configurator.app.Helper;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.panels.print.IppPrinterPanel;
import ru.softlogic.configurator.panels.print.PrinterPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.hardware.api.ApiFactory;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterFactory;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterDeviceApi;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderHelper;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionType;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.system.util.ThreadUtil;

public class TestPrinterListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final TaskExecutor executor;
    private final PrinterPanel panel;

    public TestPrinterListener(LazyInitializator initializator, TaskExecutor executor, PrinterPanel panel) {
        this.initializator = initializator;
        this.executor = executor;
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ComboBoxItem cbi = (ComboBoxItem)this.panel.getTypeComboBox().getSelectedItem();
        DeviceClass cl = (DeviceClass)cbi.getObject();
        if (cl == null) {
            return;
        }
        if (cl == DeviceClass.IppPrinter) {
            IppPrinterPanel ipp = this.panel.getIppPrinterPanel();
            cbi = (ComboBoxItem)ipp.getPrintersComboBox().getSelectedItem();
            String name = null;
            if (cbi != null && cbi.getObject() != null) {
                name = (String)cbi.getObject();
            }
            IppPrinterOptions opt = new IppPrinterOptions();
            cbi = (ComboBoxItem)ipp.getFontsComboBox().getSelectedItem();
            if (cbi != null && cbi.getObject() != null) {
                opt.setFontFamily((String)cbi.getObject());
            }
            if (ipp.getFontSizeTextField().getText().matches("^\\d+$")) {
                opt.setFontSize(Integer.parseInt(ipp.getFontSizeTextField().getText()));
            }
            if (ipp.getScrollTextField().getText().matches("^\\d+$")) {
                opt.setScroll(Integer.parseInt(ipp.getScrollTextField().getText()));
            }
            this.executor.execute(new IppTask(name, opt));
        } else if (cl == DeviceClass.PosPrinter) {
            DeviceType dt = this.initializator.getDeviceTypes().get(DeviceClass.PosPrinter);
            String portName = this.initializator.getDevicePorts().get(DeviceClass.PosPrinter);
            PrinterDeviceApi api = null;
            if (PortScanner.suggestType((String)portName) == PortType.SerialPort) {
                api = (PrinterDeviceApi)ApiFactory.createDeviceApi((DeviceType)dt, (SerialPort)this.initializator.getSerialPort(cl));
            } else if (PortScanner.suggestType((String)portName) == PortType.ParallelPort) {
                api = (PrinterDeviceApi)ApiFactory.createDeviceApi((DeviceType)dt, (ParallelPort)new ParallelPort(portName));
            } else if (PortScanner.suggestType((String)portName) == PortType.UsbPort) {
                api = (PrinterDeviceApi)ApiFactory.createDeviceApi((DeviceType)dt, (UsbPort)new UsbPort(portName));
            }
            if (api != null) {
                this.executor.execute(new PosPrinterTask(api, Helper.extractPosPrinterOptions(this.panel.getPosPrinterPanel())));
            } else {
                this.initializator.getDialog(B.get("listener.printer.pos.error"), true);
            }
        } else if (cl == DeviceClass.FiscalPrinter) {
            DeviceType dt = this.initializator.getDeviceTypes().get(DeviceClass.FiscalPrinter);
            SerialPort sp = this.initializator.getSerialPort(DeviceClass.FiscalPrinter);
            KkmOptions options = Helper.extractOption(this.panel.getFiscalPrinterPanel());
            Printer prn = PrinterFactory.createFiscalPrinterInstance((DeviceType)dt, (Port)sp, (boolean)this.panel.getFiscalPrinterPanel().getPrinterModeCheckBox().isSelected(), (KkmOptions)options, (KkmControl)new SimpleKkmControl());
            if (prn != null) {
                this.executor.execute(new FiscalPrinterTask(prn));
            } else {
                this.initializator.getDialog(B.get("listener.printer.kkm.error"), true);
            }
        }
    }

    private class FiscalPrinterTask
    extends Task {
        private final Printer printer;

        public FiscalPrinterTask(Printer printer) {
            this.printer = printer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute() {
            Operation operation = new Operation();
            operation.setCheckNumber(9999);
            operation.setCommission(new Commission(0, "5%", CommissionType.Direct, 5.0, new Sum(0)));
            operation.setIdOperation(123456);
            Keeper keeper = new Keeper();
            keeper.addCash(new CashUnit(0, new Sum(0.01), 3));
            operation.setKeeper(keeper);
            Service service = new Service();
            service.setId(0);
            service.setName(B.get("listener.printer.doc.service"));
            service.setPrintName(B.get("listener.printer.doc.service"));
            service.setPrintText(B.get("listener.printer.doc.text"));
            service.setProvider(new Dealer(B.get("listener.printer.doc.agent"), B.get("listener.printer.doc.agent.inn"), B.get("listener.printer.doc.agent.address"), B.get("listener.printer.doc.agent.support"), B.get("listener.printer.doc.agent.support-work-time")));
            operation.setService(service);
            operation.setSumResult(new SumResult(new Sum(0.01), new Sum(0.0), new Sum(0.01), new Sum(0.0), new Sum(0.0), new Sum(0), null, null));
            operation.getForm().put("id1", B.get("listener.printer.doc.number"));
            operation.getTitles().put("id1", B.get("listener.printer.doc.number.title"));
            operation.getViews().put("id1", B.get("listener.printer.doc.number.view"));
            operation.getInputElements().put("id1", new InputElement("id1", B.get("listener.printer.doc.number.title"), B.get("listener.printer.doc.number"), B.get("listener.printer.doc.number.view"), 0));
            operation.setDealer(new Dealer(B.get("listener.printer.doc.agent"), B.get("listener.printer.doc.agent.inn"), B.get("listener.printer.doc.agent.address"), B.get("listener.printer.doc.agent.support"), B.get("listener.printer.doc.agent.support-work-time")));
            operation.setPoint(new Point(1, B.get("listener.printer.doc.point"), B.get("listener.printer.doc.point.address")));
            RenderData data = new RenderData();
            data.setAdvertisement(B.get("listener.printer.doc.adv"));
            data.setDeviceType(DeviceType.IppPrinter);
            data.setDeviceClass(DeviceClass.IppPrinter);
            try {
                this.printer.open();
                this.printer.init();
                this.printer.print(operation, data);
                Object var5_5 = null;
                return var5_5;
            }
            catch (Exception ex) {
                Exception exception = ex;
                return exception;
            }
            finally {
                this.printer.close();
            }
        }

        @Override
        public void onResult(Object object) {
            if (object == null) {
                TestPrinterListener.this.initializator.getDialog(B.get("listener.printer.exec.succsess"), true);
            } else {
                TestPrinterListener.this.initializator.getDialog(B.get("listener.printer.exec.fail"), true);
            }
        }
    }

    private class PosPrinterTask
    extends Task {
        private final PrinterDeviceApi api;
        private final PosPrinterOptions options;

        public PosPrinterTask(PrinterDeviceApi api, PosPrinterOptions options) {
            this.api = api;
            this.options = options;
        }

        @Override
        public Object execute() {
            try {
                this.api.open();
                this.api.getEquipmentApi().reset();
                this.api.getEquipmentApi().init(this.options);
                String data = RenderHelper.getTemplateFromJar((String)"/i18n/docs/pos/custom", (Locale)Locale.getDefault());
                this.api.getEquipmentApi().print(data);
                this.api.getEquipmentApi().scroll(this.options.getScroll());
                this.api.getEquipmentApi().fullCut();
                if (this.options.getDispense() != null) {
                    this.api.getEquipmentApi().dispense(this.options.getDispense().intValue());
                }
                ThreadUtil.sleep((long)1000L);
                Object var2_3 = null;
                return var2_3;
            }
            catch (Exception ex) {
                Exception exception = ex;
                return exception;
            }
            finally {
                this.api.close();
            }
        }

        @Override
        public void onResult(Object object) {
            if (object == null) {
                TestPrinterListener.this.initializator.getDialog(B.get("listener.printer.exec.succsess"), true);
            } else {
                TestPrinterListener.this.initializator.getDialog(B.get("listener.printer.exec.fail"), true);
            }
        }
    }

    private class IppTask
    extends Task {
        private final Printer printer;
        private final RenderData data;
        private final Operation operation;

        public IppTask(String name, IppPrinterOptions options) {
            this.printer = PrinterFactory.createIppPrinter((String)name, (boolean)false, (IppPrinterOptions)options, (String)AppDefaults.getInstance().getProperty("printer.ipp.render"));
            this.data = new RenderData();
            this.operation = new Operation();
        }

        @Override
        public Object execute() {
            this.operation.setCheckNumber(9999);
            this.operation.setCommission(new Commission(0, "5%", CommissionType.Direct, 5.0, new Sum(0)));
            this.operation.setIdOperation(123456);
            Keeper keeper = new Keeper();
            keeper.addCash(new CashUnit(0, new Sum(100.0), 3));
            this.operation.setKeeper(keeper);
            Service service = new Service();
            service.setId(0);
            service.setName(B.get("listener.printer.doc.service"));
            service.setPrintName(B.get("listener.printer.doc.service"));
            service.setPrintText(B.get("listener.printer.doc.text"));
            service.setProvider(new Dealer(B.get("listener.printer.doc.agent"), B.get("listener.printer.doc.agent.inn"), B.get("listener.printer.doc.agent.address"), B.get("listener.printer.doc.agent.support"), B.get("listener.printer.doc.agent.support-work-time")));
            this.operation.setService(service);
            this.operation.setSumResult(new SumResult(new Sum(100.0), new Sum(0.0), new Sum(90.0), new Sum(0.0), new Sum(10.0), new Sum(0), null, null));
            this.operation.getForm().put("id1", B.get("listener.printer.doc.number"));
            this.operation.getTitles().put("id1", B.get("listener.printer.doc.number.title"));
            this.operation.getViews().put("id1", B.get("listener.printer.doc.number.view"));
            this.operation.getInputElements().put("id1", new InputElement("id1", B.get("listener.printer.doc.number.title"), B.get("listener.printer.doc.number"), B.get("listener.printer.doc.number.view"), 0));
            this.operation.setDealer(new Dealer(B.get("listener.printer.doc.agent"), B.get("listener.printer.doc.agent.inn"), B.get("listener.printer.doc.agent.address"), B.get("listener.printer.doc.agent.support"), B.get("listener.printer.doc.agent.support-work-time")));
            this.operation.setPoint(new Point(1, B.get("listener.printer.doc.point"), B.get("listener.printer.doc.point.address")));
            this.data.setAdvertisement(B.get("listener.printer.doc.adv"));
            this.data.setDeviceType(DeviceType.IppPrinter);
            this.data.setDeviceClass(DeviceClass.IppPrinter);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IppTask.this.printer.print(IppTask.this.operation, IppTask.this.data);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            return null;
        }

        @Override
        public void onResult(Object object) {
            TestPrinterListener.this.initializator.getDialog(B.get("listener.printer.ipp.send"), true);
        }
    }
}

