/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.panels.ModemPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.hardware.api.ApiFactory;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.modem.batch.ModemIniter;
import ru.softlogic.hardware.device.modem.drivers.GenericModemApi;
import ru.softlogic.hardware.device.modem.resources.ModemHelper;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.ppp.ConnectionManager;

public class TestModemListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final TaskExecutor taskExecutor;
    private final ModemPanel modemPanel;
    private final ConnectionManager manager;

    public TestModemListener(LazyInitializator initializator, TaskExecutor taskExecutor, ModemPanel modemPanel, ConnectionManager manager) {
        this.initializator = initializator;
        this.taskExecutor = taskExecutor;
        this.modemPanel = modemPanel;
        this.manager = manager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SerialPort sp;
        DeviceType dt = this.initializator.getDeviceTypes().get(DeviceClass.Modem);
        SerialDeviceApi api = ApiFactory.createDeviceApi((DeviceType)dt, (SerialPort)(sp = this.initializator.getSerialPort(DeviceClass.Modem)));
        if (api != null && api instanceof GenericModemApi) {
            this.taskExecutor.execute(new ModemActionTask((GenericModemApi)api));
        } else {
            this.initializator.getDialog(B.get("listener.modem.create.err"), true);
        }
    }

    private class ModemActionTask
    extends Task {
        private final GenericModemApi api;

        public ModemActionTask(GenericModemApi api) {
            this.api = api;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute() {
            TestModemListener.this.manager.disconnectAll();
            HashMap<String, String> data = new HashMap<String, String>();
            try {
                this.api.open();
                new ModemIniter(this.api).process();
                if (this.api.getRegistration().getState() == 1) {
                    int operatorId = this.api.getOperatorId();
                    String name = this.api.getOperatorName();
                    data.put("imei", "" + this.api.getImei());
                    data.put("imsi", "" + this.api.getImsi());
                    data.put("operator", name);
                    data.put("operator-id", "" + operatorId);
                    data.put("model", "" + this.api.getModel());
                    String vendor = this.api.getVendor();
                    data.put("vendor", "" + vendor);
                    if (TestModemListener.this.modemPanel.getCheckBalanceCheckBox().isSelected()) {
                        String ussd = null;
                        ussd = TestModemListener.this.modemPanel.getConfigureUssdCheckBox().isSelected() ? TestModemListener.this.modemPanel.getUssdTextField().getText() : ModemHelper.getUssdRequest((int)operatorId, (String)name);
                        data.put("ussd-request", ussd);
                        if (ussd != null && !ussd.isEmpty()) {
                            data.put("ussd-responce", this.api.executeUssd(ussd, ModemHelper.isPDURequire((String)vendor)));
                        }
                    }
                    HashMap<String, String> hashMap = data;
                    return hashMap;
                }
                Object operatorId = null;
                return operatorId;
            }
            catch (Exception ex) {
                Exception exception = ex;
                return exception;
            }
            finally {
                this.api.close();
            }
        }

        @Override
        public void onResult(Object object) {
            if (object == null) {
                TestModemListener.this.initializator.getDialog(B.get("listener.modem.info.reg-err"), true);
            } else if (object instanceof Exception) {
                TestModemListener.this.initializator.getDialog(B.get("listener.modem.info.err") + object, true);
            } else {
                Map data = (Map)object;
                StringBuilder sb = new StringBuilder();
                sb.append(B.get("listener.modem.info.imei")).append((String)data.get("imei")).append(", ");
                sb.append(B.get("listener.modem.info.imsi")).append((String)data.get("imsi")).append("<br>");
                sb.append(B.get("listener.modem.info.operator")).append((String)data.get("operator")).append(", ");
                sb.append(B.get("listener.modem.info.operator-id")).append((String)data.get("operator-id")).append("<br>");
                sb.append(B.get("listener.modem.info.model")).append((String)data.get("vendor")).append(" ").append((String)data.get("model")).append("<br>");
                if (data.get("ussd-request") != null) {
                    sb.append(B.get("listener.modem.info.ussd")).append((String)data.get("ussd-request")).append("<br>");
                }
                if (data.get("ussd-responce") != null) {
                    sb.append(B.get("listener.modem.info.balance")).append((String)data.get("ussd-responce")).append("<br>");
                }
                TestModemListener.this.initializator.getDialog(sb.toString(), true);
            }
        }
    }
}

