/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.listeners.AppStateWatcherStub;
import ru.softlogic.configurator.panels.NetworkPanel;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.srv.connector.AppStateWatcher;
import ru.softlogic.srv.connector.ConnectorConfiguration;
import ru.softlogic.srv.connector.ConnectorFactory;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.system.util.os.OsApi;

public class SyncTimeListener
implements ActionListener {
    private final LazyInitializator initializator;
    private final NetworkPanel panel;
    private final TaskExecutor taskExecutor;
    private final Logger log = Logger.getLogger((String)"scanner");

    public SyncTimeListener(LazyInitializator initializator, NetworkPanel panel, TaskExecutor taskExecutor) {
        this.log.setAdditivity(false);
        this.initializator = initializator;
        this.panel = panel;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.taskExecutor.execute(new TimeSyncTask());
    }

    private class TimeSyncTask
    extends Task {
        private TimeSyncTask() {
        }

        @Override
        public Object execute() {
            ConnectorConfiguration configuration = Configuration.getInstance().getDefaultConnectorConfiguration();
            if (configuration != null) {
                try {
                    ProxyConfiguration proxy = new ProxyConfiguration();
                    proxy.setUseProxy(SyncTimeListener.this.panel.getUseProxyCheckBox().isSelected());
                    proxy.setProxyHost(SyncTimeListener.this.panel.getProxyHostTextField().getText());
                    proxy.setProxyPort(SyncTimeListener.this.panel.getProxyPortTextField().getText());
                    proxy.setAuthProxy(SyncTimeListener.this.panel.getUseProxyAuthCheckBox().isSelected());
                    proxy.setProxyUser(SyncTimeListener.this.panel.getProxyUserTextField().getText());
                    proxy.setProxyPassword(SyncTimeListener.this.panel.getProxyPasswordTextField().getText());
                    ServerInterface serverInterface = ConnectorFactory.createConnector((ConnectorType)configuration.getType(), (ConnectorConfiguration)configuration, (ProxyConfiguration)proxy, (AppStateWatcher)new AppStateWatcherStub());
                    return serverInterface.ping();
                }
                catch (Exception ex) {
                    return ex;
                }
            }
            return 1;
        }

        @Override
        public void onResult(Object object) {
            if (object == null) {
                SyncTimeListener.this.initializator.getDialog("\u041d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443. \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044e", true);
            } else if (object instanceof Integer) {
                SyncTimeListener.this.initializator.getDialog("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443. \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044e", true);
            } else if (object instanceof Exception) {
                Exception ex = (Exception)object;
                SyncTimeListener.this.initializator.getDialog("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u0435\u043b \u0441\u0435\u0442\u0435\u0432\u043e\u0439 \u0441\u0431\u043e\u0439 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044e. \u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage(), true);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                SyncTimeListener.this.log.info((Object)("\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + new Date() + ", \u0432\u0440\u0435\u043c\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + date));
                int res = OsApi.getInstance().setLocalTime(date);
                SyncTimeListener.this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438: " + res + ", \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + new Date()));
                if (res == 0) {
                    SyncTimeListener.this.initializator.getDialog("\u0412\u0440\u0435\u043c\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043e!", true);
                } else {
                    SyncTimeListener.this.initializator.getDialog("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043f\u0440\u0430\u0432. \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + res, true);
                }
            }
        }
    }
}

