/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.configurator.ScanHardwareDialog;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.scanner.DeviceTypeFilter;
import ru.softlogic.hardware.scanner.Observer;
import ru.softlogic.hardware.scanner.Scanner;
import ru.softlogic.io.BasePort;
import ru.softlogic.ppp.ConnectionManager;

public class ScanAllHardwareListener
implements ActionListener {
    private final JFrame owner;
    private final ExecutorService executorService;
    private final Scanner scanner;
    private final Observer observer;
    private ScanHardwareDialog dialog;
    private LocalScanner localScanner;
    private final Logger log = Logger.getLogger((String)"scanner");
    private List<DeviceClass> deviceClasses;
    private final LazyInitializator initializator;
    private final ConnectionManager manager;
    private final Set<String> blacklist;

    public ScanAllHardwareListener(JFrame owner, ExecutorService executorService, LazyInitializator initializator, ConnectionManager manager, Set<String> blacklist) {
        this.log.setAdditivity(false);
        this.owner = owner;
        this.executorService = executorService;
        this.initializator = initializator;
        this.manager = manager;
        this.observer = new LocalObserver();
        this.scanner = new Scanner(this.observer, (DeviceTypeFilter)AppDefaults.getInstance());
        this.blacklist = blacklist;
    }

    public void init(DeviceClass ... dcs) {
        this.deviceClasses = dcs == null || dcs.length == 0 || dcs.length == 1 && dcs[0] == null ? null : Arrays.asList(dcs);
        this.getDialog().getInfoLabel().setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.info((Object)(B.get("listener.scan-hardware.start") + this.deviceClasses));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScanAllHardwareListener.this.getDialog().getInfoLabel().setText(B.get("ScanAllHardwareListener.disconnetion.wait"));
                ScanAllHardwareListener.this.getDialog().getModeLabel().setText(B.get("listener.test-connection.result.wait"));
                ScanAllHardwareListener.this.getDialog().getCloseButton().setEnabled(false);
                ScanAllHardwareListener.this.getDialog().setVisible(true);
            }
        });
        this.localScanner = new LocalScanner();
        this.executorService.submit(this.localScanner);
    }

    private ScanHardwareDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new ScanHardwareDialog((Frame)this.owner, true);
            this.dialog.getCancelButton().addActionListener(new LocalCancelListener());
            this.dialog.setLocationRelativeTo(null);
        }
        return this.dialog;
    }

    private class LocalCancelListener
    implements ActionListener {
        private LocalCancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScanAllHardwareListener.this.log.info((Object)B.get("listener.scan-hardware.break"));
            ScanAllHardwareListener.this.scanner.cancel();
        }
    }

    private class LocalObserver
    implements Observer {
        private LocalObserver() {
        }

        public void update(Map<BasePort, DeviceType> snapshot, Map<BasePort, DeviceType> result, Set<BasePort> finished, final boolean preferred) {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append("<table border=0 cellspacing=0 cellpadding=0>");
            sb.append(B.get("listener.scan-hardware.table"));
            for (BasePort bp : snapshot.keySet()) {
                sb.append("<tr").append(result.get(bp) != null ? " style=\"background-color:lime\"" : "").append("><td>").append(this.elipses(bp.getName())).append("</td><td>").append(NameExtractor.getDeviceName(snapshot.get(bp))).append("</td><td>").append(result.get(bp) != null ? B.get("listener.scan-hardware.yes") : B.get("listener.scan-hardware.no")).append("</td><td>").append(finished.contains(bp) ? B.get("listener.scan-hardware.yes") : B.get("listener.scan-hardware.no")).append("</td></tr>");
            }
            if (ScanAllHardwareListener.this.blacklist != null) {
                for (String p : ScanAllHardwareListener.this.blacklist) {
                    sb.append("<tr style=\"background-color:red \"><td>").append(p).append("</td><td></td><td></td></tr>");
                }
            }
            sb.append("</table>");
            final String str = sb.toString();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanAllHardwareListener.this.getDialog().getInfoLabel().setText(str);
                    ScanAllHardwareListener.this.getDialog().getModeLabel().setText(preferred ? B.get("listener.scan-hardware.fast-search") : B.get("listener.scan-hardware.accurate-search"));
                }
            });
        }

        public void start() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanAllHardwareListener.this.getDialog().getCancelButton().setEnabled(true);
                    ScanAllHardwareListener.this.getDialog().getCloseButton().setEnabled(false);
                    ScanAllHardwareListener.this.getDialog().getProgressBar().setIndeterminate(true);
                }
            });
        }

        public void finish() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanAllHardwareListener.this.getDialog().getCancelButton().setEnabled(false);
                    ScanAllHardwareListener.this.getDialog().getCloseButton().setEnabled(true);
                    ScanAllHardwareListener.this.getDialog().getProgressBar().setIndeterminate(false);
                }
            });
        }

        private String elipses(String name) {
            if (name.length() > 40) {
                return name.substring(0, 10) + "..." + name.substring(name.length() - 10);
            }
            return name;
        }
    }

    private class LocalScanner
    implements Runnable {
        private LocalScanner() {
        }

        @Override
        public void run() {
            if (ScanAllHardwareListener.this.deviceClasses == null || ScanAllHardwareListener.this.deviceClasses.contains(DeviceClass.Modem)) {
                ScanAllHardwareListener.this.manager.disconnectAll();
            }
            ScanAllHardwareListener.this.log.info((Object)(B.get("listener.scan-hardware.start-thread") + (ScanAllHardwareListener.this.deviceClasses == null ? B.get("listener.scan-hardware.all") : ScanAllHardwareListener.this.deviceClasses)));
            final Map devs = ScanAllHardwareListener.this.scanner.scanSerialPorts(ScanAllHardwareListener.this.deviceClasses, null, null, ScanAllHardwareListener.this.blacklist);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanAllHardwareListener.this.getDialog().getCloseButton().setEnabled(true);
                    ScanAllHardwareListener.this.getDialog().getModeLabel().setText(B.get("listener.scan-hardware.finish-thread"));
                    ScanAllHardwareListener.this.initializator.processScanResult(ScanAllHardwareListener.this.deviceClasses, devs);
                }
            });
        }
    }
}

