/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator.app.listeners;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.keyboard.DigitalKeyboardDialog;
import ru.softlogic.configurator.keyboard.KeyBoardListener;
import ru.softlogic.configurator.resources.B;

public class IntegerEditListener
implements ActionListener {
    private final int min;
    private final int max;
    private final String title;
    private final JTextField field;
    private final LazyInitializator initializator;

    public IntegerEditListener(int min, int max, String title, JTextField field, LazyInitializator initializator) {
        this.min = min;
        this.max = max;
        this.title = title;
        this.field = field;
        this.initializator = initializator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final DigitalKeyboardDialog kbd = IntegerEditListener.this.initializator.getDigitalKeyboard();
                kbd.setKeyBoardListener(new KeyBoardListener(){

                    @Override
                    public void onResult(String data) {
                        if (data == null || data.isEmpty()) {
                            JOptionPane.showMessageDialog(kbd, B.get("listener.int.void"), B.get("dialog.error"), 0);
                            return;
                        }
                        try {
                            int val = Integer.parseInt(data);
                            if (val < IntegerEditListener.this.min) {
                                JOptionPane.showMessageDialog(kbd, MessageFormat.format(B.get("listener.int.min"), IntegerEditListener.this.min), B.get("dialog.error"), 0);
                                return;
                            }
                            if (val > IntegerEditListener.this.max) {
                                JOptionPane.showMessageDialog(kbd, MessageFormat.format(B.get("listener.int.max"), IntegerEditListener.this.max), B.get("dialog.error"), 0);
                                return;
                            }
                            IntegerEditListener.this.field.setText(data);
                            kbd.setVisible(false);
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(kbd, B.get("listener.int.digit"), B.get("dialog.error"), 0);
                        }
                    }
                });
                kbd.init(IntegerEditListener.this.field.getText(), Integer.toString(IntegerEditListener.this.max).length(), false, IntegerEditListener.this.title);
                kbd.setVisible(true);
            }
        });
    }
}

