/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.swingx.JXHyperlink;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.CardReaderConfiguration;
import ru.softlogic.app.configuration.CdmConfiguration;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.app.configuration.ConfigurationException;
import ru.softlogic.app.configuration.ConfigurationSN;
import ru.softlogic.app.configuration.DeviceConfiguration;
import ru.softlogic.app.configuration.PresentConfiguration;
import ru.softlogic.app.configuration.SerialNumbersStore;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.configurator.Application;
import ru.softlogic.configurator.InfoDialog;
import ru.softlogic.configurator.LoadKeyDialog;
import ru.softlogic.configurator.SelectKeyStoreDialog;
import ru.softlogic.configurator.TerminalKey;
import ru.softlogic.configurator.TestCashinDialog;
import ru.softlogic.configurator.app.Helper;
import ru.softlogic.configurator.app.LazyInitializator;
import ru.softlogic.configurator.app.NameExtractor;
import ru.softlogic.configurator.app.listeners.ChangeDocumentListener;
import ru.softlogic.configurator.app.listeners.ChangeItemListener;
import ru.softlogic.configurator.app.listeners.ConnectListener;
import ru.softlogic.configurator.app.listeners.DisconnectListener;
import ru.softlogic.configurator.app.listeners.ExitListener;
import ru.softlogic.configurator.app.listeners.FiscalShareListener;
import ru.softlogic.configurator.app.listeners.FolderChooserListener;
import ru.softlogic.configurator.app.listeners.InitKkmListener;
import ru.softlogic.configurator.app.listeners.IntegerEditListener;
import ru.softlogic.configurator.app.listeners.LocalStoreListener;
import ru.softlogic.configurator.app.listeners.MappingChannelSelectedListener;
import ru.softlogic.configurator.app.listeners.PortConfListener;
import ru.softlogic.configurator.app.listeners.PortDetailsListener;
import ru.softlogic.configurator.app.listeners.PortSelectedListener;
import ru.softlogic.configurator.app.listeners.PrinterPortDetailsListener;
import ru.softlogic.configurator.app.listeners.ProximityTypeSelectedListener;
import ru.softlogic.configurator.app.listeners.ScanAllHardwareListener;
import ru.softlogic.configurator.app.listeners.ScanListener;
import ru.softlogic.configurator.app.listeners.ScanModemListener;
import ru.softlogic.configurator.app.listeners.ScanPrinterListener;
import ru.softlogic.configurator.app.listeners.ScanWatchDogListener;
import ru.softlogic.configurator.app.listeners.SyncTimeListener;
import ru.softlogic.configurator.app.listeners.TestCoinListener;
import ru.softlogic.configurator.app.listeners.TestConnectionListener;
import ru.softlogic.configurator.app.listeners.TestModemListener;
import ru.softlogic.configurator.app.listeners.TestPrinterListener;
import ru.softlogic.configurator.app.listeners.TestValidatorListener;
import ru.softlogic.configurator.app.listeners.TestValidatorWorkListener;
import ru.softlogic.configurator.app.listeners.TestWatchDogListener;
import ru.softlogic.configurator.app.listeners.TextEditListener;
import ru.softlogic.configurator.app.listeners.TypeSelectedListener;
import ru.softlogic.configurator.app.listeners.UpdateGuiListener;
import ru.softlogic.configurator.app.listeners.UssdEditListener;
import ru.softlogic.configurator.app.listeners.WatchDogChangeListener;
import ru.softlogic.configurator.app.tasks.IppInitTask;
import ru.softlogic.configurator.elements.ComboBoxItem;
import ru.softlogic.configurator.keyboard.DigitalKeyboardDialog;
import ru.softlogic.configurator.keyboard.LetterKeyboardDialog;
import ru.softlogic.configurator.panels.CardModulePanel;
import ru.softlogic.configurator.panels.CardReaderPanel;
import ru.softlogic.configurator.panels.CdmPanel;
import ru.softlogic.configurator.panels.CoinHopperPanel;
import ru.softlogic.configurator.panels.CoinPanel;
import ru.softlogic.configurator.panels.CvdPanel;
import ru.softlogic.configurator.panels.ModemPanel;
import ru.softlogic.configurator.panels.NetworkPanel;
import ru.softlogic.configurator.panels.OtherPanel;
import ru.softlogic.configurator.panels.PinpadPanel;
import ru.softlogic.configurator.panels.ProximityPanel;
import ru.softlogic.configurator.panels.SerialNumbersPanel;
import ru.softlogic.configurator.panels.ValidatorPanel;
import ru.softlogic.configurator.panels.WatchDogPanel;
import ru.softlogic.configurator.panels.barcode.BarcodePanel;
import ru.softlogic.configurator.panels.present.NetworkPresentPanel;
import ru.softlogic.configurator.panels.present.PresentPanel;
import ru.softlogic.configurator.panels.print.FiscalPrinterPanel;
import ru.softlogic.configurator.panels.print.IppPrinterPanel;
import ru.softlogic.configurator.panels.print.PosPrinterPanel;
import ru.softlogic.configurator.panels.print.PrinterPanel;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.configurator.serial.PortConfigurator;
import ru.softlogic.configurator.task.Task;
import ru.softlogic.configurator.task.TaskExecutor;
import ru.softlogic.gui.Rendering;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.present.DispenserNetworkOptions;
import ru.softlogic.hardware.device.present.DispenserOptions;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.scanner.BarcodeScannerType;
import ru.softlogic.hardware.device.watchdog.EventListener;
import ru.softlogic.hardware.device.watchdog.WatchDogDescriptor;
import ru.softlogic.hardware.device.watchdog.WatchDogFactory;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.lookup.HardwareLookup;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.keyclient.PinCodeGenerator;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.srv.connector.ConnectorConfiguration;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ResourceLoader;
import ru.softlogic.system.util.ResourceUtil;

public class ApplicationView
extends FrameView
implements LazyInitializator {
    private final ValidatorPanel validatorPanel;
    private final CoinPanel coinPanel;
    private final CoinHopperPanel coinHopperPanel;
    private final CardReaderPanel readerPanel;
    private final ModemPanel modemPanel;
    private final NetworkPanel networkPanel;
    private final WatchDogPanel watchDogPanel;
    private final PrinterPanel printerPanel;
    private final OtherPanel otherPanel;
    private final BarcodePanel barcodePanel;
    private final PinpadPanel pinpadPanel;
    private final ProximityPanel proximityPanel;
    private final CardModulePanel cardModulePanel;
    private final PresentPanel presentPanel;
    private final CvdPanel cvdPanel;
    private final CdmPanel cdmPanel;
    private final SerialNumbersPanel serialNumbersPanel;
    private String[] serialPorts;
    private String[] parallelPorts;
    private String[] usbPorts;
    private final TaskExecutor te;
    private PortConfigurator portConfigurator;
    private DigitalKeyboardDialog digitalKeyboard;
    private LetterKeyboardDialog letterKeyboard;
    private InfoDialog infoDialog;
    private TestCashinDialog cashinDialog;
    private SelectKeyStoreDialog storeDialog;
    private LoadKeyDialog loadKeyDialog;
    private final Map<String, SerialPort> ports;
    private final Map<DeviceClass, String> devicePorts;
    private final Map<DeviceClass, DeviceType> deviceTypes;
    private final Map<DeviceClass, DeviceDescription> deviceNames;
    private final Map<String, DeviceDescription> deviceDescs;
    private final Map<Integer, ComboBoxItem> watchDogSwitchMap;
    private final ExecutorService executorService;
    private Logger log;
    private final ConnectionManager connectionManager;
    private PosPrinterPanel ppp;
    private final FiscalPrinterPanel fpp;
    private IppPrinterPanel ipp;
    private boolean modified;
    private JPanel aboutTabPanel;
    private JXHyperlink appHomepageLabel;
    private JLabel appTitleLabel;
    private JLabel appVendorLabel;
    private JPanel barcodeTabPanel;
    private JLabel buildDateLabel;
    private JPanel cardModuleTabPanel;
    private JPanel cardTabPanel;
    private JPanel cashTabPanel;
    private JPanel cdmTabPanel;
    private JPanel coinHopperTabPanel;
    private JPanel coinTabPanel;
    private JPanel cvdTabPanel;
    private JLabel imageLabel;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JLabel javaLabel;
    private JPanel mainPanel;
    private JPanel mainTabPanel;
    private JPanel modemTabPanel;
    private JPanel otherTabPanel;
    private JPanel pinpadTabPanel;
    private JPanel presentTabPanel;
    private JPanel printerTabPanel;
    private JProgressBar progressBar;
    private JPanel proximityTabPanel;
    private JLabel queueLabel;
    private JLabel sizeLabel;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JTabbedPane tabbedPane;
    private JPanel wdTabPanel;
    private JPanel snTabPanel;
    private JDialog aboutBox;

    public ApplicationView(SingleFrameApplication app) {
        super((org.jdesktop.application.Application)app);
        this.initComponents();
        this.imageLabel.setIcon(ResourceLoader.getIcon((String)"/icon/logo.png"));
        Icon kbd16 = ResourceLoader.getIcon((String)"/icon/x16/keyboard.png");
        Icon kbd32 = ResourceLoader.getIcon((String)"/icon/x32/keyboard.png");
        this.getApplication().addExitListener((Application.ExitListener)new LocalExitListener());
        this.getFrame().setMinimumSize(new Dimension(1024, 740));
        try {
            this.log = this.createLogger("scanner", "add/scanner");
        }
        catch (Exception ex) {
            this.log = Logger.getLogger((String)"scanner");
        }
        this.executorService = Executors.newFixedThreadPool(1);
        this.te = new TaskExecutor(this.getFrame(), this.executorService);
        this.networkPanel = new NetworkPanel();
        this.serialNumbersPanel = new SerialNumbersPanel();
        if (kbd16 != null) {
            this.networkPanel.getHttpPortButton().setIcon(kbd16);
            this.networkPanel.getHttpPortButton().setText("");
            this.networkPanel.getHttpsPortButton().setIcon(kbd16);
            this.networkPanel.getHttpsPortButton().setText("");
            this.networkPanel.getServerAddressButton().setIcon(kbd16);
            this.networkPanel.getServerAddressButton().setText("");
            this.serialNumbersPanel.getValidatorSNButton().setIcon(kbd16);
            this.serialNumbersPanel.getValidatorSNButton().setText("");
            this.serialNumbersPanel.getPrinterSNButton().setIcon(kbd16);
            this.serialNumbersPanel.getPrinterSNButton().setText("");
            this.serialNumbersPanel.getModemSNButton().setIcon(kbd16);
            this.serialNumbersPanel.getModemSNButton().setText("");
            this.serialNumbersPanel.getFirstMonitorSNButton().setIcon(kbd16);
            this.serialNumbersPanel.getFirstMonitorSNButton().setText("");
            this.serialNumbersPanel.getSecondMonitorSNButton().setIcon(kbd16);
            this.serialNumbersPanel.getSecondMonitorSNButton().setText("");
            this.serialNumbersPanel.getTerminalSNButton().setIcon(kbd16);
            this.serialNumbersPanel.getTerminalSNButton().setText("");
        }
        ExitListener el = new ExitListener(this.getApplication());
        this.connectionManager = ManagerFactory.getInstance().getManager();
        this.log.info((Object)B.get("main.conn"));
        String[] connections = this.connectionManager.getConnectionsList();
        this.log.info((Object)(B.get("main.conn.avaliable") + Arrays.asList(connections)));
        if (connections != null) {
            LinkedList<ComboBoxItem> model = new LinkedList<ComboBoxItem>();
            model.add(new ComboBoxItem(null, NameExtractor.getUndefinedName()));
            for (String string : connections) {
                model.add(new ComboBoxItem(string, NameExtractor.getComboBoxTitle(string)));
            }
            this.networkPanel.getConnectionsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model.toArray(new ComboBoxItem[model.size()])));
        } else {
            this.log.error((Object)(B.get("main.conn.errcode") + this.connectionManager.getLastError()));
        }
        DisconnectListener disconnectListener = new DisconnectListener(this, this.te, this.connectionManager);
        ScanAllHardwareListener sahl = new ScanAllHardwareListener(this.getFrame(), this.executorService, this, this.connectionManager, ResourceUtil.getPortsBlacklist((Logger)this.log));
        this.watchDogSwitchMap = new HashMap<Integer, ComboBoxItem>();
        this.networkPanel.getLoadKeyButton().addActionListener(new OpenStoreListener());
        this.networkPanel.getScanHardwareButton().addActionListener(new ScanListener(null, sahl));
        this.networkPanel.getTestConnectionButton().addActionListener(new TestConnectionListener(this.getFrame(), this.networkPanel, this, this.executorService));
        this.networkPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.networkPanel.getConnectButton().addActionListener(new ConnectListener(this, this.te, this.networkPanel, this.connectionManager));
        this.networkPanel.getDisconnectButton().addActionListener(disconnectListener);
        this.networkPanel.getExitButton().addActionListener(el);
        this.networkPanel.getSyncTimeButton().addActionListener(new SyncTimeListener(this, this.networkPanel, this.te));
        this.networkPanel.getHttpPortButton().addActionListener(new IntegerEditListener(0, 65000, this.networkPanel.getHttpPortLabel().getText(), this.networkPanel.getHttpPortTextField(), this));
        this.networkPanel.getHttpsPortButton().addActionListener(new IntegerEditListener(0, 65000, this.networkPanel.getHttpsPortLabel().getText(), this.networkPanel.getHttpsPortTextField(), this));
        this.networkPanel.getServerAddressButton().addActionListener(new TextEditListener(this.networkPanel.getServerAddressLabel().getText(), this.networkPanel.getServerAddressTextField(), 50, this));
        this.networkPanel.getUseModemCheckBox().addItemListener(new UpdateGuiListener(this));
        this.networkPanel.getUseProxyCheckBox().addItemListener(new UpdateGuiListener(this));
        this.networkPanel.getUseProxyAuthCheckBox().addItemListener(new UpdateGuiListener(this));
        this.networkPanel.getProxyHostButton().addActionListener(new TextEditListener(this.networkPanel.getProxyHostLabel().getText(), this.networkPanel.getProxyHostTextField(), 50, this));
        this.networkPanel.getProxyPortButton().addActionListener(new IntegerEditListener(0, 65000, this.networkPanel.getProxyPortLabel().getText(), this.networkPanel.getProxyPortTextField(), this));
        this.networkPanel.getProxyUserButton().addActionListener(new TextEditListener(this.networkPanel.getProxyUserLabel().getText(), this.networkPanel.getProxyUserTextField(), 50, this));
        this.networkPanel.getProxyPasswordButton().addActionListener(new TextEditListener(this.networkPanel.getProxyPasswordLabel().getText(), this.networkPanel.getProxyPasswordTextField(), 50, this));
        this.networkPanel.getConnectionsComboBox().addItemListener(new ChangeItemListener(this));
        this.networkPanel.getProxyHostTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.networkPanel.getProxyPortTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.networkPanel.getProxyUserTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.networkPanel.getProxyPasswordTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.networkPanel.getServerAddressTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.networkPanel.getHttpsPortTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.networkPanel.getHttpPortTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.mainTabPanel.add(this.networkPanel);
        this.validatorPanel = new ValidatorPanel();
        this.validatorPanel.getScanValidatorButton().addActionListener(new ScanListener(DeviceClass.CashAcceptor, sahl));
        this.validatorPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.CashAcceptor, this));
        this.validatorPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.CashAcceptor, this));
        this.validatorPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.validatorPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.CashAcceptor));
        this.validatorPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.validatorPanel.getTestButton().addActionListener(new TestValidatorListener(this, this.validatorPanel, this.te));
        this.validatorPanel.getWorkButton().addActionListener(new TestValidatorWorkListener(this, DeviceClass.CashAcceptor));
        this.validatorPanel.getExitButton().addActionListener(el);
        this.cashTabPanel.add(this.validatorPanel);
        this.cvdPanel = new CvdPanel();
        this.cvdPanel.getScanCvdButton().addActionListener(new ScanListener(DeviceClass.CardDispenser, sahl));
        this.cvdPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.CardDispenser, this));
        this.cvdPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.CardDispenser, this));
        this.cvdPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.cvdPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.CardDispenser));
        this.cvdPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.cvdPanel.getExitButton().addActionListener(el);
        this.cvdTabPanel.add(this.cvdPanel);
        this.cdmPanel = new CdmPanel();
        this.cdmPanel.getScanCvdButton().addActionListener(new ScanListener(DeviceClass.CashDispenser, sahl));
        this.cdmPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.CashDispenser, this));
        this.cdmPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.CashDispenser, this));
        this.cdmPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.cdmPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.CashDispenser));
        this.cdmPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.cdmPanel.getExitButton().addActionListener(el);
        this.cdmTabPanel.add(this.cdmPanel);
        this.coinPanel = new CoinPanel();
        this.coinPanel.getScanCoinButton().addActionListener(new ScanListener(DeviceClass.CoinAcceptor, sahl));
        this.coinPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.CoinAcceptor, this));
        this.coinPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.CoinAcceptor, this));
        this.coinPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.coinPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.CoinAcceptor));
        this.coinPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.coinPanel.getTestButton().addActionListener(new TestCoinListener(this, this.coinPanel, this.te));
        this.coinPanel.getWorkButton().addActionListener(new TestValidatorWorkListener(this, DeviceClass.CoinAcceptor));
        this.coinPanel.getExitButton().addActionListener(el);
        this.coinTabPanel.add(this.coinPanel);
        this.coinHopperPanel = new CoinHopperPanel();
        this.coinHopperPanel.getScanHopperButton().addActionListener(new ScanListener(DeviceClass.Hopper, sahl));
        this.coinHopperPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.Hopper, this));
        this.coinHopperPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.Hopper, this));
        this.coinHopperPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.coinHopperPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.Hopper));
        this.coinHopperPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.coinHopperPanel.getExitButton().addActionListener(el);
        this.coinHopperTabPanel.add(this.coinHopperPanel);
        this.readerPanel = new CardReaderPanel();
        this.readerPanel.getScanReaderButton().addActionListener(new ScanListener(DeviceClass.CardReader, sahl));
        this.readerPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.CardReader, this));
        this.readerPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.CardReader, this));
        this.readerPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.CardReader));
        this.readerPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.readerPanel.getExitButton().addActionListener(el);
        this.cardTabPanel.add(this.readerPanel);
        this.printerPanel = new PrinterPanel(this);
        this.printerPanel.getPortConfButton().addActionListener(new PrinterPortDetailsListener(this.printerPanel.getTypeComboBox(), this));
        this.printerPanel.getScanPrinterButton().addActionListener(new ScanPrinterListener(this.printerPanel, sahl));
        this.printerPanel.getTestButton().addActionListener(new TestPrinterListener(this, this.te, this.printerPanel));
        this.printerPanel.getExitButton().addActionListener(el);
        this.printerPanel.getInitKkmButton().addActionListener(new InitKkmListener(this, this.te, this.printerPanel));
        this.printerPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.printerPanel.getUsePaperNearEndSensor().addItemListener(new ChangeItemListener(this));
        this.ppp = this.printerPanel.getPosPrinterPanel();
        this.ppp.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.PosPrinter, this));
        this.ppp.getPrintWidthButton().addActionListener(new IntegerEditListener(50, 80, this.ppp.getPrintWidthLabel().getText(), this.ppp.getPrintWidthTextField(), this));
        this.ppp.getLeftMarginButton().addActionListener(new IntegerEditListener(0, 40, this.ppp.getLeftMarginLabel().getText(), this.ppp.getLeftMarginField(), this));
        this.ppp.getScrollButton().addActionListener(new IntegerEditListener(0, 15, this.ppp.getScrollTextLabel().getText(), this.ppp.getScrollTextField(), this));
        this.ppp.getDispenseButton().addActionListener(new IntegerEditListener(0, 15, this.ppp.getDispenseLabel().getText(), this.ppp.getDispenseTextField(), this));
        this.ppp.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.PosPrinter));
        this.ppp.getPrintWidthTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.ppp.getLeftMarginField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.ppp.getScrollTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.ppp.getDispenseTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.ppp.getEncodingComboBox().addItemListener(new ChangeItemListener(this));
        this.ppp.getLineSpanComboBox().addItemListener(new ChangeItemListener(this));
        this.ppp.getFontSizeComboBox().addItemListener(new ChangeItemListener(this));
        LinkedList<ComboBoxItem> encodingModel = new LinkedList<ComboBoxItem>();
        encodingModel.add(new ComboBoxItem(null, NameExtractor.getComboBoxTitle(B.get("PosPrinterPanel.encoding.default"))));
        String[] encs = AppDefaults.getInstance().getPrinterEncoding();
        if (encs != null) {
            for (String enc : encs) {
                String val = enc.trim();
                if (val.isEmpty()) continue;
                encodingModel.add(new ComboBoxItem(val, NameExtractor.getComboBoxTitle(val)));
            }
        }
        this.ppp.getEncodingComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(encodingModel.toArray(new ComboBoxItem[encodingModel.size()])));
        this.ipp = this.printerPanel.getIppPrinterPanel();
        this.ipp.getFontSizeButton().addActionListener(new IntegerEditListener(5, 20, this.ipp.getFontSizeLabel().getText(), this.ipp.getFontSizeTextField(), this));
        this.ipp.getScrollButton().addActionListener(new IntegerEditListener(0, 50, this.ipp.getScrollLabel().getText(), this.ipp.getScrollTextField(), this));
        this.ipp.getPrintersComboBox().addItemListener(new UpdateGuiListener(this));
        this.ipp.getFontSizeTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.ipp.getScrollTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.ipp.getFontsComboBox().addItemListener(new ChangeItemListener(this));
        this.fpp = this.printerPanel.getFiscalPrinterPanel();
        this.fpp.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.FiscalPrinter, this));
        this.fpp.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.FiscalPrinter));
        this.fpp.getScrollButton().addActionListener(new IntegerEditListener(0, 20, this.fpp.getScrollLabel().getText(), this.fpp.getScrollTextField(), this));
        this.fpp.getPrintWidthButton().addActionListener(new IntegerEditListener(15, 60, this.fpp.getPrintWidthLabel().getText(), this.fpp.getPrintWidthTextField(), this));
        this.fpp.getAdminPasswordButton().addActionListener(new TextEditListener(this.fpp.getAdminPasswordLabel().getText(), this.fpp.getAdminPasswordTextField(), 8, this));
        this.fpp.getOperPasswordButton().addActionListener(new TextEditListener(this.fpp.getOperPasswordLabel().getText(), this.fpp.getOperPasswordTextField(), 8, this));
        this.fpp.getScrollTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.fpp.getPrintWidthTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.fpp.getAdminPasswordTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.fpp.getOperPasswordTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.fpp.getPresenterComboBox().addItemListener(new ChangeItemListener(this));
        this.fpp.getPrinterModeCheckBox().addItemListener(new ChangeItemListener(this));
        this.printerTabPanel.add(this.printerPanel);
        this.modemPanel = new ModemPanel();
        this.modemPanel.getScanModemButton().addActionListener(new ScanModemListener(sahl, this.te, this.connectionManager));
        this.modemPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.Modem, this));
        this.modemPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.Modem, this));
        this.modemPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.modemPanel.getUssdEditButton().addActionListener(new UssdEditListener(this.modemPanel.getUssdLabel().getText(), this.modemPanel.getUssdTextField(), this));
        this.modemPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.Modem));
        this.modemPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.modemPanel.getCheckBalanceCheckBox().addItemListener(new UpdateGuiListener(this));
        this.modemPanel.getSetSoftwareWatchDogCheckBox().addItemListener(new UpdateGuiListener(this));
        this.modemPanel.getConfigureUssdCheckBox().addItemListener(new UpdateGuiListener(this));
        this.modemPanel.getTestButton().addActionListener(new TestModemListener(this, this.te, this.modemPanel, this.connectionManager));
        this.modemPanel.getExitButton().addActionListener(el);
        this.modemPanel.getUssdTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        FiscalShareListener fiscalShareListener = new FiscalShareListener(this, this.te);
        this.modemPanel.getOnNetSharButton().addActionListener(fiscalShareListener);
        this.modemPanel.getOffNetSharButton().addActionListener(fiscalShareListener);
        this.modemTabPanel.add(this.modemPanel);
        this.watchDogPanel = new WatchDogPanel();
        this.watchDogPanel.getScanWatchDogButton().addActionListener(new ScanWatchDogListener(sahl, this.te, this.connectionManager));
        this.watchDogPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.WatchDog, this));
        this.watchDogPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.watchDogPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.WatchDog, this));
        this.watchDogPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.WatchDog));
        this.watchDogPanel.getTypesComboBox().addItemListener(new WatchDogChangeListener(this, this.watchDogSwitchMap));
        this.watchDogPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.watchDogPanel.getTestButton().addActionListener(new TestWatchDogListener(this, this.watchDogPanel, this.te));
        this.watchDogPanel.getExitButton().addActionListener(el);
        this.watchDogPanel.getMappingTable().getModel().addTableModelListener(new MappingChannelSelectedListener(this, this.watchDogSwitchMap, this.watchDogPanel.getMappingTable().getModel()));
        this.watchDogPanel.getModemChannelButton().addActionListener(new IntegerEditListener(0, 99, this.watchDogPanel.getModemChannelLabel().getText(), this.watchDogPanel.getModemChannelTextField(), this));
        this.watchDogPanel.getModemChannelTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.watchDogPanel.getRebootPcTimeoutButton().addActionListener(new IntegerEditListener(2, 20, this.watchDogPanel.getRebootPcTimeoutLabel().getText(), this.watchDogPanel.getRebootPcTimeoutTextField(), this));
        this.watchDogPanel.getRebootPcTimeoutTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.wdTabPanel.add(this.watchDogPanel);
        this.barcodePanel = new BarcodePanel(this);
        this.barcodePanel.getScanButton().addActionListener(new ScanListener(DeviceClass.BarcodeScanner, sahl));
        this.barcodePanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.barcodePanel.getExitButton().addActionListener(el);
        this.barcodePanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.barcodePanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.BarcodeScanner, this));
        this.barcodePanel.getSerialBarcodePanel().getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.BarcodeScanner, this));
        this.barcodePanel.getSerialBarcodePanel().getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.BarcodeScanner));
        this.barcodeTabPanel.add(this.barcodePanel);
        this.pinpadPanel = new PinpadPanel();
        this.pinpadPanel.getScanPinpadButton().addActionListener(new ScanListener(DeviceClass.Pinpad, sahl));
        this.pinpadPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.Pinpad, this));
        this.pinpadPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.Pinpad, this));
        this.pinpadPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.pinpadPanel.getTypesComboBox().addItemListener(new TypeSelectedListener(this, DeviceClass.Pinpad));
        this.pinpadPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.pinpadPanel.getExitButton().addActionListener(el);
        this.pinpadTabPanel.add(this.pinpadPanel);
        this.proximityPanel = new ProximityPanel();
        this.proximityPanel.getScanReaderButton().addActionListener(new ScanListener(DeviceClass.ProximityReader, sahl));
        this.proximityPanel.getPortConfButton().addActionListener(new PortDetailsListener(DeviceClass.ProximityReader, this));
        this.proximityPanel.getPortsComboBox().addItemListener(new PortSelectedListener(DeviceClass.ProximityReader, this));
        this.proximityPanel.getScanPortsButton().addActionListener(new PortScannerListener());
        this.proximityPanel.getTypesComboBox().addItemListener(new ProximityTypeSelectedListener(this, DeviceClass.ProximityReader, this.proximityPanel));
        this.proximityPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.proximityPanel.getExitButton().addActionListener(el);
        this.proximityPanel.getMppkPathButton().addActionListener(new FolderChooserListener(this.getFrame(), this.proximityPanel.getMppkPathTextField()));
        this.proximityPanel.getMppkPathTextField().getDocument().addDocumentListener(new ChangeDocumentListener(this));
        this.proximityPanel.setMppkPathElementsVisible(false);
        this.proximityTabPanel.add(this.proximityPanel);
        this.cardModulePanel = new CardModulePanel();
        this.cardModulePanel.getHostButton().addActionListener(new TextEditListener(this.cardModulePanel.getHostLabel().getText(), this.cardModulePanel.getHostTextField(), 30, this));
        this.cardModulePanel.getPortButton().addActionListener(new IntegerEditListener(1, 65000, this.cardModulePanel.getPortLabel().getText(), this.cardModulePanel.getPortTextField(), this));
        this.cardModulePanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.cardModulePanel.getExitButton().addActionListener(el);
        this.cardModuleTabPanel.add(this.cardModulePanel);
        this.presentPanel = new PresentPanel(this);
        NetworkPresentPanel npp = this.presentPanel.getNetworkPresentPanel();
        npp.getHostButton().addActionListener(new TextEditListener(npp.getHostLabel().getText(), npp.getHostTextField(), 30, this));
        npp.getPortButton().addActionListener(new IntegerEditListener(1, 65000, npp.getPortLabel().getText(), npp.getPortTextField(), this));
        npp.getCostButton().addActionListener(new IntegerEditListener(1, 99, npp.getCostLabel().getText(), npp.getCostTextField(), this));
        this.presentPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.presentPanel.getExitButton().addActionListener(el);
        this.presentTabPanel.add(this.presentPanel);
        this.otherPanel = new OtherPanel();
        this.otherPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.otherPanel.getExitButton().addActionListener(el);
        this.otherPanel.getRenderingComboBox().addItemListener(new ChangeItemListener(this));
        this.otherPanel.getScreenSizeComboBox().addItemListener(new ChangeItemListener(this));
        this.otherPanel.getShowCursorCheckBox().addItemListener(new ChangeItemListener(this));
        this.otherPanel.getOnTopCheckBox().addItemListener(new ChangeItemListener(this));
        this.otherTabPanel.add(this.otherPanel);
        this.serialNumbersPanel.getSaveButton().addActionListener(new SaveConfigurationListener());
        this.serialNumbersPanel.getExitButton().addActionListener(el);
        this.serialNumbersPanel.getValidatorSNButton().addActionListener(new TextEditListener(this.serialNumbersPanel.getValidatorSNLabel().getText(), this.serialNumbersPanel.getValidatorSNTextField(), 50, this));
        this.serialNumbersPanel.getPrinterSNButton().addActionListener(new TextEditListener(this.serialNumbersPanel.getPrinterSNLabel().getText(), this.serialNumbersPanel.getPrinterSNTextField(), 50, this));
        this.serialNumbersPanel.getModemSNButton().addActionListener(new TextEditListener(this.serialNumbersPanel.getModemSNLabel().getText(), this.serialNumbersPanel.getModemSNTextField(), 50, this));
        this.serialNumbersPanel.getFirstMonitorSNButton().addActionListener(new TextEditListener(this.serialNumbersPanel.getFirstMonitorSNLabel().getText(), this.serialNumbersPanel.getFirstMonitorSNTextField(), 50, this));
        this.serialNumbersPanel.getSecondMonitorSNButton().addActionListener(new TextEditListener(this.serialNumbersPanel.getSecondMonitorSNLabel().getText(), this.serialNumbersPanel.getSecondMonitorSNTextField(), 50, this));
        this.serialNumbersPanel.getTerminalSNButton().addActionListener(new TextEditListener(this.serialNumbersPanel.getTerminalSNLabel().getText(), this.serialNumbersPanel.getTerminalSNTextField(), 50, this));
        this.snTabPanel.add(this.serialNumbersPanel);
        if (!AppDefaults.getInstance().isActiveTab("about")) {
            this.tabbedPane.remove(16);
        }
        if (!AppDefaults.getInstance().isActiveTab("other")) {
            this.tabbedPane.remove(15);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("cvd")) {
            this.tabbedPane.remove(14);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("present-module")) {
            this.tabbedPane.remove(13);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("card-module")) {
            this.tabbedPane.remove(12);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("proximity")) {
            this.tabbedPane.remove(11);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("pinpad")) {
            this.tabbedPane.remove(10);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("cardreader")) {
            this.tabbedPane.remove(9);
        }
        if (!AppDefaults.getInstance().isActiveTab("barcode")) {
            this.tabbedPane.remove(8);
        }
        if (!AppDefaults.getInstance().isActiveTab("watchdog")) {
            this.tabbedPane.remove(7);
        }
        if (!AppDefaults.getInstance().isActiveTab("modem")) {
            this.tabbedPane.remove(6);
        }
        if (!AppDefaults.getInstance().isActiveTab("print")) {
            this.tabbedPane.remove(5);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("coinhopper")) {
            this.tabbedPane.remove(4);
        }
        if (!AppDefaults.getInstance().isActiveTabDefined("cdm")) {
            this.tabbedPane.remove(3);
        }
        if (!AppDefaults.getInstance().isActiveTab("coin")) {
            this.tabbedPane.remove(2);
        }
        if (!AppDefaults.getInstance().isActiveTab("cashin")) {
            this.tabbedPane.remove(1);
        }
        if (!AppDefaults.getInstance().isActiveTab("main")) {
            this.tabbedPane.remove(0);
        }
        if (kbd32 != null) {
            this.watchDogPanel.getModemChannelButton().setText("");
            this.watchDogPanel.getModemChannelButton().setIcon(kbd32);
            this.watchDogPanel.getRebootPcTimeoutButton().setText("");
            this.watchDogPanel.getRebootPcTimeoutButton().setIcon(kbd32);
            this.modemPanel.getUssdEditButton().setText("");
            this.modemPanel.getUssdEditButton().setIcon(kbd32);
            this.networkPanel.getProxyHostButton().setIcon(kbd32);
            this.networkPanel.getProxyHostButton().setText("");
            this.networkPanel.getProxyPortButton().setIcon(kbd32);
            this.networkPanel.getProxyPortButton().setText("");
            this.networkPanel.getProxyUserButton().setIcon(kbd32);
            this.networkPanel.getProxyUserButton().setText("");
            this.networkPanel.getProxyPasswordButton().setIcon(kbd32);
            this.networkPanel.getProxyPasswordButton().setText("");
            this.ppp.getPrintWidthButton().setIcon(kbd32);
            this.ppp.getPrintWidthButton().setText("");
            this.ppp.getLeftMarginButton().setIcon(kbd32);
            this.ppp.getLeftMarginButton().setText("");
            this.ppp.getScrollButton().setIcon(kbd32);
            this.ppp.getScrollButton().setText("");
            this.ipp.getFontSizeButton().setIcon(kbd32);
            this.ipp.getFontSizeButton().setText("");
            this.ipp.getScrollButton().setIcon(kbd32);
            this.ipp.getScrollButton().setText("");
            this.fpp.getScrollButton().setIcon(kbd32);
            this.fpp.getScrollButton().setText("");
            this.fpp.getAdminPasswordButton().setIcon(kbd32);
            this.fpp.getAdminPasswordButton().setText("");
            this.fpp.getOperPasswordButton().setIcon(kbd32);
            this.fpp.getOperPasswordButton().setText("");
            this.fpp.getPrintWidthButton().setIcon(kbd32);
            this.fpp.getPrintWidthButton().setText("");
            this.cardModulePanel.getHostButton().setIcon(kbd32);
            this.cardModulePanel.getPortButton().setIcon(kbd32);
            this.presentPanel.getNetworkPresentPanel().getHostButton().setIcon(kbd32);
            this.presentPanel.getNetworkPresentPanel().getPortButton().setIcon(kbd32);
            this.presentPanel.getNetworkPresentPanel().getCostButton().setIcon(kbd32);
        }
        PortScannerListener psl = new PortScannerListener();
        this.validatorPanel.getScanPortsButton().addActionListener(psl);
        this.watchDogPanel.getScanPortsButton().addActionListener(psl);
        this.printerPanel.getScanPortsButton().addActionListener(psl);
        this.modemPanel.getScanPortsButton().addActionListener(psl);
        this.ports = new HashMap<String, SerialPort>();
        this.devicePorts = new HashMap<DeviceClass, String>();
        this.deviceTypes = new HashMap<DeviceClass, DeviceType>();
        this.deviceNames = new HashMap<DeviceClass, DeviceDescription>();
        this.deviceDescs = new HashMap<String, DeviceDescription>();
        Set dds = HardwareLookup.lookup();
        this.log.info((Object)(">>>>>>>>dds: " + dds.toString()));
        DeviceDescription dd1 = new DeviceDescription("crd", "smartcardio", "smartcardio".toUpperCase(Locale.ENGLISH), "");
        this.deviceDescs.put(dd1.getType(), dd1);
        for (DeviceDescription dd : dds) {
            this.deviceDescs.put(dd.getType(), dd);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationView.this.getFrame().setLocationRelativeTo(null);
            }
        });
        this.te.execute(new IppInitTask(this.printerPanel.getIppPrinterPanel()));
        this.te.execute(new PortScannerTask());
        this.te.execute(new LoadConfTask());
        this.initInfo();
    }

    @Override
    public final void setModifyState(boolean modified) {
        this.modified = modified;
        if (modified) {
            this.getFrame().setTitle(MessageFormat.format(B.get("Application.title.modified"), DateFormat.getTimeInstance(3).format(new Date())));
        } else {
            this.getFrame().setTitle(B.get("Application.title"));
        }
    }

    @Override
    public void processScanResult(List<DeviceClass> deviceClasses, Map<BasePort, DeviceType> data) {
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)(B.get("main.scan.res") + deviceClasses));
        this.log.info((Object)(B.get("main.scan.found") + data));
        HashMap<DeviceClass, BasePort> cm = new HashMap<DeviceClass, BasePort>();
        if (data != null) {
            for (BasePort bp : data.keySet()) {
                DeviceType dt = data.get(bp);
                if (dt == null) continue;
                cm.put(dt.getDeviceClass(), bp);
            }
        }
        this.updateData(DeviceClass.CashAcceptor, cm, data, deviceClasses);
        this.updateData(DeviceClass.CoinAcceptor, cm, data, deviceClasses);
        this.updateData(DeviceClass.Hopper, cm, data, deviceClasses);
        this.updateData(DeviceClass.CardReader, cm, data, deviceClasses);
        this.updateData(DeviceClass.Pinpad, cm, data, deviceClasses);
        this.updateData(DeviceClass.ProximityReader, cm, data, deviceClasses);
        this.updateData(DeviceClass.CardDispenser, cm, data, deviceClasses);
        this.updateData(DeviceClass.CashDispenser, cm, data, deviceClasses);
        if (deviceClasses == null || deviceClasses.contains(DeviceClass.FiscalPrinter) || deviceClasses.contains(DeviceClass.PosPrinter)) {
            if (cm.containsKey(DeviceClass.FiscalPrinter)) {
                this.printerPanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(DeviceClass.FiscalPrinter, null));
                this.updateData(DeviceClass.FiscalPrinter, cm, data, deviceClasses);
            } else if (cm.containsKey(DeviceClass.PosPrinter)) {
                this.printerPanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(DeviceClass.PosPrinter, null));
                this.updateData(DeviceClass.PosPrinter, cm, data, deviceClasses);
            } else if (this.ipp.getPrintersComboBox().getItemCount() > 1) {
                this.printerPanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(DeviceClass.IppPrinter, null));
                if (this.ipp.getPrintersComboBox().getSelectedItem() == null || this.ipp.getPrintersComboBox().getSelectedIndex() == 0) {
                    if (this.ipp.getDefaultPrinter() != null) {
                        this.ipp.getPrintersComboBox().setSelectedItem(new ComboBoxItem(this.ipp.getDefaultPrinter(), null));
                    } else {
                        this.ipp.getPrintersComboBox().setSelectedIndex(1);
                    }
                }
            } else {
                this.printerPanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(null, null));
            }
        }
        if ((deviceClasses == null || deviceClasses.contains(DeviceClass.BarcodeScanner)) && cm.containsKey(DeviceClass.BarcodeScanner)) {
            this.barcodePanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(BarcodeScannerType.Serial, null));
            this.updateData(DeviceClass.BarcodeScanner, cm, data, deviceClasses);
        }
        this.updateData(DeviceClass.Modem, cm, data, deviceClasses);
        this.updateData(DeviceClass.WatchDog, cm, data, deviceClasses);
        if (this.deviceTypes.get(DeviceClass.Modem) != null && this.deviceTypes.get(DeviceClass.WatchDog) == null) {
            this.modemPanel.getSetSoftwareWatchDogCheckBox().setSelected(true);
        }
        this.updateGui();
    }

    private void updateData(DeviceClass deviceClass, Map<DeviceClass, BasePort> classMap, Map<BasePort, DeviceType> portMap, List<DeviceClass> deviceClasses) {
        this.log.info((Object)(B.get("main.scan.process") + deviceClass));
        if (deviceClasses == null || deviceClasses.contains(deviceClass)) {
            BasePort bp = classMap.get(deviceClass);
            if (bp != null) {
                this.log.info((Object)("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + portMap.get(bp).getName() + ", \u043f\u043e\u0440\u0442=" + bp));
                this.devicePorts.put(deviceClass, bp.getName());
                if (DeviceClass.CardReader.equals((Object)deviceClass)) {
                    this.deviceNames.put(deviceClass, this.deviceDescs.get(portMap.get(bp).getName()));
                }
                this.deviceTypes.put(deviceClass, portMap.get(bp));
                if (bp instanceof SerialPort) {
                    this.ports.put(bp.getName(), (SerialPort)bp);
                }
            } else {
                this.log.info((Object)B.get("main.scan.notfound"));
                this.devicePorts.remove(deviceClass);
                this.deviceTypes.remove(deviceClass);
            }
        } else {
            this.log.info((Object)B.get("main.scan.skip"));
        }
    }

    @Override
    public void updateGui() {
        SerialParams sp;
        SerialParams sp2;
        this.setModifyState(true);
        this.log.info(this.deviceTypes);
        this.log.info(this.devicePorts);
        this.log.info(this.ports);
        this.networkPanel.getConnectionsComboBox().setEnabled(this.networkPanel.getUseModemCheckBox().isSelected());
        this.networkPanel.getProxyHostTextField().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected());
        this.networkPanel.getProxyHostButton().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected());
        this.networkPanel.getProxyPortTextField().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected());
        this.networkPanel.getProxyPortButton().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected());
        this.networkPanel.getUseProxyAuthCheckBox().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected());
        this.networkPanel.getProxyUserTextField().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected() && this.networkPanel.getUseProxyAuthCheckBox().isSelected());
        this.networkPanel.getProxyUserButton().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected() && this.networkPanel.getUseProxyAuthCheckBox().isSelected());
        this.networkPanel.getProxyPasswordTextField().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected() && this.networkPanel.getUseProxyAuthCheckBox().isSelected());
        this.networkPanel.getProxyPasswordButton().setEnabled(this.networkPanel.getUseProxyCheckBox().isSelected() && this.networkPanel.getUseProxyAuthCheckBox().isSelected());
        this.validatorPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.CashAcceptor), null));
        this.validatorPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.CashAcceptor), null));
        this.validatorPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.CashAcceptor) != null);
        this.validatorPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.CashAcceptor) != null && this.deviceTypes.get(DeviceClass.CashAcceptor) != null);
        this.validatorPanel.getWorkButton().setEnabled(this.devicePorts.get(DeviceClass.CashAcceptor) != null && this.deviceTypes.get(DeviceClass.CashAcceptor) != null);
        this.validatorPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.CashAcceptor)));
        this.validatorPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        SerialPort serialPort = this.getSerialPort(DeviceClass.CashAcceptor);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.validatorPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        this.coinHopperPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.Hopper), null));
        this.coinHopperPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.Hopper), null));
        this.coinHopperPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.Hopper) != null);
        this.coinHopperPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.Hopper)));
        this.coinHopperPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.Hopper);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.coinHopperPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        this.coinPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.CoinAcceptor), null));
        this.coinPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.CoinAcceptor), null));
        this.coinPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.CoinAcceptor) != null);
        this.coinPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.CoinAcceptor) != null && this.deviceTypes.get(DeviceClass.CoinAcceptor) != null);
        this.coinPanel.getWorkButton().setEnabled(this.devicePorts.get(DeviceClass.CoinAcceptor) != null && this.deviceTypes.get(DeviceClass.CoinAcceptor) != null);
        this.coinPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.CoinAcceptor)));
        this.coinPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.CoinAcceptor);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.coinPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        this.readerPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.CardReader), null));
        this.readerPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceNames.get(DeviceClass.CardReader), null));
        this.readerPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.CardReader) != null);
        this.readerPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.CardReader) != null && this.deviceTypes.get(DeviceClass.CardReader) != null);
        this.readerPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceNames.get(DeviceClass.CardReader)));
        this.readerPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.CardReader);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.readerPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        this.pinpadPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.Pinpad), null));
        this.pinpadPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.Pinpad), null));
        this.pinpadPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.Pinpad) != null);
        this.pinpadPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.Pinpad) != null && this.deviceTypes.get(DeviceClass.Pinpad) != null);
        this.pinpadPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.Pinpad)));
        this.pinpadPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.Pinpad);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.pinpadPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        this.proximityPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.ProximityReader), null));
        this.proximityPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.ProximityReader), null));
        this.proximityPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.ProximityReader) != null);
        this.proximityPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.ProximityReader)));
        this.proximityPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.ProximityReader);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.proximityPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        this.modemPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.Modem), null));
        this.modemPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.Modem), null));
        this.modemPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.Modem) != null);
        this.modemPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.Modem) != null && this.deviceTypes.get(DeviceClass.Modem) != null);
        this.modemPanel.getCheckBalanceCheckBox().setEnabled(this.devicePorts.get(DeviceClass.Modem) != null && this.deviceTypes.get(DeviceClass.Modem) != null);
        this.modemPanel.getSetSoftwareWatchDogCheckBox().setEnabled(this.devicePorts.get(DeviceClass.Modem) != null && this.deviceTypes.get(DeviceClass.Modem) != null);
        this.modemPanel.getConfigureUssdCheckBox().setEnabled(this.modemPanel.getCheckBalanceCheckBox().isEnabled() && this.modemPanel.getCheckBalanceCheckBox().isSelected());
        this.modemPanel.getUssdTextField().setEnabled(this.modemPanel.getConfigureUssdCheckBox().isEnabled() && this.modemPanel.getConfigureUssdCheckBox().isSelected());
        this.modemPanel.getUssdEditButton().setEnabled(this.modemPanel.getConfigureUssdCheckBox().isEnabled() && this.modemPanel.getConfigureUssdCheckBox().isSelected());
        this.modemPanel.getUssdLabel().setEnabled(this.modemPanel.getConfigureUssdCheckBox().isEnabled() && this.modemPanel.getConfigureUssdCheckBox().isSelected());
        this.modemPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.Modem)));
        this.modemPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.Modem);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.modemPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        if (this.devicePorts.get(DeviceClass.Modem) == null && this.deviceTypes.get(DeviceClass.Modem) == null) {
            this.modemPanel.getSetSoftwareWatchDogCheckBox().setSelected(false);
        }
        if (this.modemPanel.getSetSoftwareWatchDogCheckBox().isSelected()) {
            if (this.deviceTypes.get(DeviceClass.Modem) != null) {
                this.deviceTypes.put(DeviceClass.WatchDog, DeviceType.Software);
                this.devicePorts.put(DeviceClass.WatchDog, this.devicePorts.get(DeviceClass.Modem));
            }
        } else if (this.deviceTypes.get(DeviceClass.WatchDog) == DeviceType.Software) {
            this.deviceTypes.remove(DeviceClass.WatchDog);
            this.devicePorts.remove(DeviceClass.WatchDog);
        }
        this.watchDogPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.WatchDog), null));
        this.watchDogPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.WatchDog), null));
        this.watchDogPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.WatchDog) != null);
        this.watchDogPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.WatchDog) != null && this.deviceTypes.get(DeviceClass.WatchDog) != null);
        this.watchDogPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.WatchDog)));
        this.watchDogPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.WatchDog);
        if (serialPort != null) {
            sp2 = serialPort.getParams();
            this.watchDogPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp2.getSpeed(), sp2.getDataBits().getName(), sp2.getStopBits().getName(), sp2.getParity()));
        }
        if (this.deviceTypes.get(DeviceClass.WatchDog) != null) {
            WatchDogDescriptor wdtdesc = WatchDogFactory.createDescriptor((DeviceType)this.deviceTypes.get(DeviceClass.WatchDog));
            if (wdtdesc.isAllowRemap()) {
                this.watchDogPanel.getMappingTable().setEnabled(true);
                this.watchDogPanel.setChannelColumnModel(NameExtractor.getWatchDogChannelsModel(wdtdesc));
                this.watchDogPanel.setMappingRows(wdtdesc);
                for (Integer id : this.watchDogSwitchMap.keySet()) {
                    this.watchDogPanel.setChannel(id, this.watchDogSwitchMap.get(id));
                }
            } else {
                this.watchDogPanel.getMappingTable().setEnabled(false);
                this.watchDogPanel.clearMappingTable();
            }
        } else {
            this.watchDogPanel.getMappingTable().setEnabled(false);
            this.watchDogPanel.clearMappingTable();
        }
        ComboBoxItem cbi = (ComboBoxItem)this.barcodePanel.getTypeComboBox().getSelectedItem();
        BarcodeScannerType bst = (BarcodeScannerType)cbi.getObject();
        if (bst != null && bst == BarcodeScannerType.Serial) {
            this.barcodePanel.getScanPortsButton().setEnabled(true);
            this.barcodePanel.getPortConfButton().setEnabled(true);
            this.barcodePanel.getSerialBarcodePanel().getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.BarcodeScanner)));
            this.barcodePanel.getSerialBarcodePanel().getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.BarcodeScanner), null));
            this.barcodePanel.getSerialBarcodePanel().getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.BarcodeScanner), null));
            serialPort = this.getSerialPort(DeviceClass.BarcodeScanner);
            if (serialPort != null) {
                sp = serialPort.getParams();
                this.barcodePanel.getSerialBarcodePanel().getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp.getSpeed(), sp.getDataBits().getName(), sp.getStopBits().getName(), sp.getParity()));
            }
        } else {
            this.barcodePanel.getScanPortsButton().setEnabled(false);
            this.barcodePanel.getPortConfButton().setEnabled(false);
        }
        this.fpp.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.FiscalPrinter), null));
        this.fpp.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.FiscalPrinter), null));
        this.fpp.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.FiscalPrinter)));
        this.fpp.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.FiscalPrinter);
        if (serialPort != null) {
            sp = serialPort.getParams();
            this.fpp.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp.getSpeed(), sp.getDataBits().getName(), sp.getStopBits().getName(), sp.getParity()));
        }
        this.ppp = this.printerPanel.getPosPrinterPanel();
        this.ppp.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.PosPrinter), null));
        this.ppp.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.PosPrinter), null));
        this.ppp.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.PosPrinter)));
        this.ppp.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.PosPrinter);
        if (serialPort != null) {
            sp = serialPort.getParams();
            this.ppp.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp.getSpeed(), sp.getDataBits().getName(), sp.getStopBits().getName(), sp.getParity()));
        }
        this.cvdPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.CardDispenser), null));
        this.cvdPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.CardDispenser), null));
        this.cvdPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.CardDispenser) != null);
        this.cvdPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.CardDispenser)));
        this.cvdPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.CardDispenser);
        if (serialPort != null) {
            sp = serialPort.getParams();
            this.cvdPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp.getSpeed(), sp.getDataBits().getName(), sp.getStopBits().getName(), sp.getParity()));
        }
        this.cdmPanel.getPortsComboBox().setSelectedItem(new ComboBoxItem(this.devicePorts.get(DeviceClass.CashDispenser), null));
        this.cdmPanel.getTypesComboBox().setSelectedItem(new ComboBoxItem(this.deviceTypes.get(DeviceClass.CashDispenser), null));
        this.cdmPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.CashDispenser) != null);
        this.cdmPanel.getTypeDescriptionLabel().setText(NameExtractor.getDeviceDescription(this.deviceTypes.get(DeviceClass.CashDispenser)));
        this.cdmPanel.getPortParamsLabel().setText(B.get("main.notavalible"));
        serialPort = this.getSerialPort(DeviceClass.CashDispenser);
        if (serialPort != null) {
            sp = serialPort.getParams();
            this.cdmPanel.getPortParamsLabel().setText(String.format("%d,%s,%s,%s", sp.getSpeed(), sp.getDataBits().getName(), sp.getStopBits().getName(), sp.getParity()));
        }
        cbi = (ComboBoxItem)this.printerPanel.getTypeComboBox().getSelectedItem();
        DeviceClass dc = (DeviceClass)cbi.getObject();
        this.printerPanel.getTestButton().setEnabled(false);
        this.printerPanel.getInitKkmButton().setEnabled(false);
        this.printerPanel.getPortConfButton().setEnabled(false);
        if (dc != null) {
            if (dc == DeviceClass.FiscalPrinter) {
                this.printerPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.FiscalPrinter) != null);
                this.printerPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.FiscalPrinter) != null && this.deviceTypes.get(DeviceClass.FiscalPrinter) != null);
                this.printerPanel.getInitKkmButton().setEnabled(this.devicePorts.get(DeviceClass.FiscalPrinter) != null && this.deviceTypes.get(DeviceClass.FiscalPrinter) != null);
            } else if (dc == DeviceClass.PosPrinter) {
                this.printerPanel.getPortConfButton().setEnabled(this.devicePorts.get(DeviceClass.PosPrinter) != null);
                this.printerPanel.getTestButton().setEnabled(this.devicePorts.get(DeviceClass.PosPrinter) != null && this.deviceTypes.get(DeviceClass.PosPrinter) != null);
            } else if (dc == DeviceClass.IppPrinter) {
                this.printerPanel.getTestButton().setEnabled(true);
            }
        }
    }

    @Override
    public void loadTerminalKey(TerminalKey key) {
        this.log.info((Object)("load key: " + key));
        try {
            Configuration conf = Configuration.getInstance();
            if (conf == null) {
                throw new Exception("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430. \u0424\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            String unique = key.getServerAddress() + "_" + key.getHttpsPort() + "_" + key.getPoint();
            String keyPath = PathUtils.getAppHome() + "/key/";
            new File(keyPath).mkdirs();
            File privKeyPath = new File(keyPath, unique + "_private.key");
            File pubKeyPath = new File(keyPath, unique + "_public.key");
            FileUtil.writeFile((File)privKeyPath, (String)key.getPrivateTerminalKey().trim());
            FileUtil.writeFile((File)pubKeyPath, (String)key.getPublicServerKey().trim());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("server", key.getServerAddress());
            params.put("port", Integer.toString(key.getHttpsPort()));
            params.put("http-port", Integer.toString(key.getHttpPort()));
            params.put("scheme", "https");
            params.put("timeout", "45000");
            params.put("private-key", privKeyPath.getAbsolutePath());
            params.put("public-key", pubKeyPath.getAbsolutePath());
            params.put("point", Integer.toString(key.getPoint()));
            ConnectorConfiguration newConf = new ConnectorConfiguration("ws_" + unique, ConnectorType.WS, params);
            conf.setDefaultConnectorConfiguration(newConf);
            conf.updateConfiguration();
            ReferenceManager.getInstance().clear();
            this.networkPanel.getPointIdTextField().setText(Integer.toString(key.getPoint()));
            this.networkPanel.getServerAddressTextField().setText(key.getServerAddress());
            this.networkPanel.getHttpPortTextField().setText(Integer.toString(key.getHttpPort()));
            this.networkPanel.getHttpsPortTextField().setText(Integer.toString(key.getHttpsPort()));
            if (key.getPublicTerminalKey() != null) {
                String pin = PinCodeGenerator.getPin((String)key.getPublicTerminalKey());
                this.getDialog(MessageFormat.format(B.get("LoadKeyDialog.result.success1"), pin), true);
            } else {
                this.getDialog(B.get("LoadKeyDialog.result.success2"), true);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.getFrame(), ex.getMessage(), B.get("dialog.error"), 0);
        }
    }

    @Override
    public Map<DeviceClass, DeviceType> getDeviceTypes() {
        return this.deviceTypes;
    }

    @Override
    public Map<String, SerialPort> getPorts() {
        return this.ports;
    }

    @Override
    public Map<DeviceClass, String> getDevicePorts() {
        return this.devicePorts;
    }

    @Override
    public PortConfigurator getPortConfigurator() {
        if (this.portConfigurator == null) {
            this.portConfigurator = new PortConfigurator((Frame)this.getFrame(), true, this);
            this.portConfigurator.setLocationRelativeTo(null);
            this.portConfigurator.addListener(new PortConfListener(this));
        }
        return this.portConfigurator;
    }

    @Override
    public DigitalKeyboardDialog getDigitalKeyboard() {
        if (this.digitalKeyboard == null) {
            this.digitalKeyboard = new DigitalKeyboardDialog((Frame)this.getFrame(), true);
            this.digitalKeyboard.setLocationRelativeTo(null);
            this.digitalKeyboard.pack();
        }
        return this.digitalKeyboard;
    }

    @Override
    public LetterKeyboardDialog getLetterKeyboard() {
        if (this.letterKeyboard == null) {
            this.letterKeyboard = new LetterKeyboardDialog((Frame)this.getFrame(), true);
            this.letterKeyboard.setLocationRelativeTo(null);
            this.letterKeyboard.pack();
        }
        return this.letterKeyboard;
    }

    @Override
    public InfoDialog getDialog(String text, boolean show) {
        if (this.infoDialog == null) {
            this.infoDialog = new InfoDialog((Frame)this.getFrame(), true);
            this.infoDialog.setLocationRelativeTo(null);
        }
        this.infoDialog.setText(text);
        this.infoDialog.setVisible(true);
        return this.infoDialog;
    }

    @Override
    public TestCashinDialog getCashinDialog() {
        if (this.cashinDialog == null) {
            this.cashinDialog = new TestCashinDialog((Frame)this.getFrame(), true);
            this.cashinDialog.setLocationRelativeTo(null);
        }
        return this.cashinDialog;
    }

    @Override
    public SelectKeyStoreDialog getSelectKeyStoreDialog() {
        if (this.storeDialog == null) {
            this.storeDialog = new SelectKeyStoreDialog((Frame)this.getFrame(), true);
            this.storeDialog.setLocationRelativeTo(null);
            this.storeDialog.addListener(new LocalStoreListener(this.getFrame(), this));
        }
        return this.storeDialog;
    }

    @Override
    public LoadKeyDialog getLoadKeyDialog() {
        if (this.loadKeyDialog == null) {
            this.loadKeyDialog = new LoadKeyDialog((Frame)this.getFrame(), true, this, this.te);
            this.loadKeyDialog.setLocationRelativeTo(null);
        }
        return this.loadKeyDialog;
    }

    @Override
    public SerialPort getSerialPort(DeviceClass deviceClass) {
        String portName = this.devicePorts.get(deviceClass);
        if (portName != null && PortType.SerialPort.equals((Object)PortScanner.suggestType((String)portName))) {
            SerialPort sp = this.ports.get(portName);
            if (sp == null) {
                sp = new SerialPort(portName);
            }
            return sp;
        }
        return null;
    }

    @Override
    public Map<DeviceClass, DeviceDescription> getDeviceNames() {
        return this.deviceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initInfo() {
        Image img = null;
        try {
            img = ImageIO.read(new File(PathUtils.getAppHome() + File.separator + "trademark" + File.separator + "logo.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (img != null && img.getWidth(null) == 350 && img.getHeight(null) == 100) {
            this.imageLabel.setIcon(new ImageIcon(img));
        }
        Properties prop = new Properties();
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(PathUtils.getAppHome() + File.separator + "trademark" + File.separator + "info.properties"), "utf-8");
            prop.load(isr);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(isr);
                throw throwable2;
            }
        }
        IOUtils.closeQuietly((Reader)isr);
        String pr = prop.getProperty("homepage");
        if (pr != null) {
            this.appHomepageLabel.setText(pr);
        }
        pr = prop.getProperty("system", "Pay-logic");
        MessageFormat form = new MessageFormat(((Application)Application.getInstance(Application.class)).getContext().getResourceMap(ApplicationView.class).getString("AppicationView.appTitleLabel.text", new Object[0]));
        this.appTitleLabel.setText(form.format(new Object[]{pr}));
        this.appVendorLabel.setText(prop.getProperty("vendor", "Soft-logic Inc."));
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.mainTabPanel = new JPanel();
        this.cashTabPanel = new JPanel();
        this.coinTabPanel = new JPanel();
        this.cdmTabPanel = new JPanel();
        this.coinHopperTabPanel = new JPanel();
        this.printerTabPanel = new JPanel();
        this.modemTabPanel = new JPanel();
        this.wdTabPanel = new JPanel();
        this.barcodeTabPanel = new JPanel();
        this.cardTabPanel = new JPanel();
        this.pinpadTabPanel = new JPanel();
        this.proximityTabPanel = new JPanel();
        this.cardModuleTabPanel = new JPanel();
        this.presentTabPanel = new JPanel();
        this.cvdTabPanel = new JPanel();
        this.otherTabPanel = new JPanel();
        this.aboutTabPanel = new JPanel();
        this.appTitleLabel = new JLabel();
        this.snTabPanel = new JPanel();
        JLabel versionLabel = new JLabel();
        this.javaLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.buildDateLabel = new JLabel();
        this.appHomepageLabel = new JXHyperlink();
        this.imageLabel = new JLabel();
        JLabel appDescLabel = new JLabel();
        this.appVendorLabel = new JLabel();
        JLabel homepageLabel = new JLabel();
        JLabel appVersionLabel = new JLabel();
        JLabel vendorLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.queueLabel = new JLabel();
        this.sizeLabel = new JLabel();
        this.mainPanel.setMinimumSize(new Dimension(700, 500));
        this.mainPanel.setLayout(new BorderLayout());
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setFont(new Font("Tahoma", 0, 14));
        this.mainTabPanel.setLayout(new BorderLayout());
        ResourceMap resourceMap = ((Application)Application.getInstance(Application.class)).getContext().getResourceMap(ApplicationView.class);
        this.tabbedPane.addTab("", resourceMap.getIcon("mainTabPanel.TabConstraints.tabIcon"), this.mainTabPanel);
        this.cashTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("AppicationView.cashTabPanel.TabConstraints.tabIcon"), this.cashTabPanel);
        this.coinTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("coinTabPanel.TabConstraints.tabIcon"), this.coinTabPanel);
        this.cdmTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab(resourceMap.getString("cdmTabPanel.TabConstraints.tabTitle", new Object[0]), this.cdmTabPanel);
        this.coinHopperTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("coinHopperTabPanel.TabConstraints.tabIcon"), this.coinHopperTabPanel);
        this.printerTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("printerTabPanel.TabConstraints.tabIcon"), this.printerTabPanel);
        this.modemTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("modemTabPanel.TabConstraints.tabIcon"), this.modemTabPanel);
        this.wdTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("wdTabPanel.TabConstraints.tabIcon"), this.wdTabPanel);
        this.barcodeTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("barcodeTabPanel.TabConstraints.tabIcon"), this.barcodeTabPanel);
        this.cardTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("cardTabPanel.TabConstraints.tabIcon"), this.cardTabPanel);
        this.pinpadTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("pinpadTabPanel.TabConstraints.tabIcon"), this.pinpadTabPanel);
        this.proximityTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("proximityTabPanel.TabConstraints.tabIcon"), this.proximityTabPanel);
        this.cardModuleTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("cardModuleTabPanel.TabConstraints.tabIcon"), this.cardModuleTabPanel);
        this.presentTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("", resourceMap.getIcon("presentTabPanel.TabConstraints.tabIcon"), this.presentTabPanel);
        this.cvdTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab(resourceMap.getString("AppicationView.cvdTabPanel.TabConstraints.tabTitle", new Object[0]), this.cvdTabPanel);
        this.cvdTabPanel.getAccessibleContext().setAccessibleName("");
        this.otherTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab(resourceMap.getString("AppicationView.otherTabPanel.TabConstraints.tabTitle", new Object[0]), this.otherTabPanel);
        this.snTabPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab(resourceMap.getString("AppicationView.snTabPanel.TabConstraints.tabTitle", new Object[0]), this.snTabPanel);
        this.aboutTabPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.appTitleLabel.setFont(new Font("Tahoma", 1, 14));
        this.appTitleLabel.setText(resourceMap.getString("AppicationView.appTitleLabel.text", new Object[0]));
        versionLabel.setText(resourceMap.getString("AppicationView.versionLabel.text", new Object[0]));
        this.javaLabel.setText(resourceMap.getString("AppicationView.javaLabel.text", new Object[0]));
        this.jLabel2.setText("01.08.2011");
        this.buildDateLabel.setText(resourceMap.getString("AppicationView.buildDateLabel.text", new Object[0]));
        ApplicationActionMap actionMap = ((Application)Application.getInstance(Application.class)).getContext().getActionMap(ApplicationView.class, (Object)this);
        this.appHomepageLabel.setAction(actionMap.get("openSite"));
        this.appHomepageLabel.setText(resourceMap.getString("AppicationView.appHomepageLabel.text", new Object[0]));
        this.imageLabel.setMinimumSize(new Dimension(350, 100));
        this.imageLabel.setPreferredSize(new Dimension(350, 100));
        appDescLabel.setText(resourceMap.getString("AppicationView.appDescLabel.text", new Object[0]));
        appDescLabel.setVerticalAlignment(1);
        this.appVendorLabel.setText(resourceMap.getString("AppicationView.appVendorLabel.text", new Object[0]));
        homepageLabel.setText(resourceMap.getString("AppicationView.homepageLabel.text", new Object[0]));
        appVersionLabel.setText("2.5");
        vendorLabel.setText(resourceMap.getString("AppicationView.vendorLabel.text", new Object[0]));
        this.jLabel4.setText(SystemProp.getJavaVersion());
        GroupLayout aboutTabPanelLayout = new GroupLayout(this.aboutTabPanel);
        this.aboutTabPanel.setLayout(aboutTabPanelLayout);
        aboutTabPanelLayout.setHorizontalGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aboutTabPanelLayout.createSequentialGroup().addContainerGap().addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 759, Short.MAX_VALUE).addGroup(aboutTabPanelLayout.createSequentialGroup().addComponent(this.imageLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(appDescLabel, -1, 397, Short.MAX_VALUE).addComponent(this.appTitleLabel, -1, 397, Short.MAX_VALUE))).addGroup(aboutTabPanelLayout.createSequentialGroup().addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buildDateLabel, -1, -1, Short.MAX_VALUE).addComponent(vendorLabel, -1, -1, Short.MAX_VALUE).addComponent(homepageLabel, -1, -1, Short.MAX_VALUE).addComponent(this.javaLabel, -1, -1, Short.MAX_VALUE).addComponent(versionLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent((Component)this.appHomepageLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 102, Short.MAX_VALUE).addComponent(this.appVendorLabel, -1, -1, Short.MAX_VALUE).addComponent(appVersionLabel, -1, 246, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 335, Short.MAX_VALUE))).addContainerGap()));
        aboutTabPanelLayout.setVerticalGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aboutTabPanelLayout.createSequentialGroup().addContainerGap().addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageLabel, -1, 101, Short.MAX_VALUE).addGroup(aboutTabPanelLayout.createSequentialGroup().addComponent(this.appTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(appDescLabel, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, -1, -2).addGap(18, 18, 18).addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(versionLabel, -2, 20, -2).addComponent(appVersionLabel, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildDateLabel, -2, 20, -2).addComponent(this.jLabel2, -2, 20, -2)).addGap(6, 6, 6).addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(vendorLabel, -2, 20, -2).addComponent(this.appVendorLabel, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(homepageLabel, -2, 20, -2).addComponent((Component)this.appHomepageLabel, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutTabPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaLabel, -2, 20, -2).addComponent(this.jLabel4, -2, 20, -2)).addContainerGap(163, Short.MAX_VALUE)));
        this.tabbedPane.addTab("", resourceMap.getIcon("aboutTabPanel.TabConstraints.tabIcon"), this.aboutTabPanel);
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.statusPanel.setPreferredSize(new Dimension(800, 30));
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.progressBar.setFont(new Font("Tahoma", 0, 12));
        this.queueLabel.setFont(new Font("Tahoma", 1, 11));
        this.queueLabel.setText(resourceMap.getString("Application.queueLabel.text", new Object[0]));
        this.sizeLabel.setFont(new Font("Tahoma", 1, 11));
        this.sizeLabel.setText("0");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 796, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 772, Short.MAX_VALUE).addComponent(this.statusAnimationLabel).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.queueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 424, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addGap(15, 15, 15)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.queueLabel).addComponent(this.sizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel)).addGap(3, 3, 3)).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.progressBar, -2, -1, -2).addContainerGap()))));
        this.setComponent(this.mainPanel);
        this.setStatusBar(this.statusPanel);
    }

    private Logger createLogger(String name, String path) {
        Logger itemLogger = Logger.getLogger((String)name);
        itemLogger.setAdditivity(false);
        itemLogger.setLevel(Level.DEBUG);
        DailyRollingFileAppender drfa = new DailyRollingFileAppender();
        drfa.setEncoding("UTF-8");
        drfa.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %5p [%t] %m%n"));
        drfa.setFile(PathUtils.getPath((String)("/log/" + path + ".log")));
        drfa.setDatePattern("'.'yyyy-MM-dd");
        drfa.activateOptions();
        itemLogger.addAppender((Appender)drfa);
        return itemLogger;
    }

    static /* synthetic */ String[] access$402(ApplicationView x0, String[] x1) {
        x0.serialPorts = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(ApplicationView x0, String[] x1) {
        x0.parallelPorts = x1;
        return x1;
    }

    static /* synthetic */ String[] access$602(ApplicationView x0, String[] x1) {
        x0.usbPorts = x1;
        return x1;
    }

    private class OpenStoreListener
    implements ActionListener {
        private OpenStoreListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApplicationView.this.getSelectKeyStoreDialog().setVisible(true);
        }
    }

    private class LocalExitListener
    implements Application.ExitListener {
        private LocalExitListener() {
        }

        public boolean canExit(EventObject event) {
            if (!ApplicationView.this.modified) {
                return true;
            }
            return JOptionPane.showConfirmDialog(ApplicationView.this.getFrame(), B.get("Application.question.exit"), B.get("Application.question.exit.title"), 2) == 0;
        }

        public void willExit(EventObject event) {
        }
    }

    private class SaveConfigurationListener
    implements ActionListener {
        private SaveConfigurationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboBoxItem cbi;
            ComboBoxItem item;
            ApplicationView.this.log.info((Object)"=======================================================");
            ApplicationView.this.log.info((Object)(B.get("main.save.devices") + ApplicationView.this.deviceTypes));
            ApplicationView.this.log.info((Object)(B.get("main.save.ports") + ApplicationView.this.devicePorts));
            Configuration c = Configuration.getInstance();
            ConnectorConfiguration cc = c.getDefaultConnectorConfiguration();
            if (cc != null && cc.getParams() != null) {
                cc.getParams().put("server", ApplicationView.this.networkPanel.getServerAddressTextField().getText());
                cc.getParams().put("http-port", ApplicationView.this.networkPanel.getHttpPortTextField().getText());
                cc.getParams().put("port", ApplicationView.this.networkPanel.getHttpsPortTextField().getText());
            }
            c.setUseProxy(ApplicationView.this.networkPanel.getUseProxyCheckBox().isSelected());
            c.setProxyHost(ApplicationView.this.networkPanel.getProxyHostTextField().getText());
            c.setProxyPort(ApplicationView.this.networkPanel.getProxyPortTextField().getText());
            c.setAuthProxy(ApplicationView.this.networkPanel.getUseProxyAuthCheckBox().isSelected());
            c.setProxyUser(ApplicationView.this.networkPanel.getProxyUserTextField().getText());
            c.setProxyPassword(ApplicationView.this.networkPanel.getProxyPasswordTextField().getText());
            ApplicationView.this.log.info((Object)B.get("main.save.cashacceptor"));
            DeviceType dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.CashAcceptor);
            SerialPort sp = ApplicationView.this.getSerialPort(DeviceClass.CashAcceptor);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.cashacceptor.add"));
                c.setCashAcceptorConfiguration(new DeviceConfiguration(dt, (Port)sp));
            } else {
                c.setCashAcceptorConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.cashacceptor.skip"));
            }
            ApplicationView.this.log.info((Object)B.get("main.save.hopper"));
            dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.Hopper);
            sp = ApplicationView.this.getSerialPort(DeviceClass.Hopper);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.hopper.add"));
                c.setCoinHopperConfiguration(new DeviceConfiguration(dt, (Port)sp));
            } else {
                c.setCoinHopperConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.hopper.skip"));
            }
            ApplicationView.this.log.info((Object)B.get("main.save.coinacceptor"));
            dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.CoinAcceptor);
            sp = ApplicationView.this.getSerialPort(DeviceClass.CoinAcceptor);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.coinacceptor.add"));
                c.setCoinAcceptorConfiguration(new DeviceConfiguration(dt, (Port)sp));
            } else {
                c.setCoinAcceptorConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.coinacceptor.skip"));
            }
            ApplicationView.this.log.info((Object)B.get("main.save.cardreader"));
            DeviceDescription dd = (DeviceDescription)ApplicationView.this.deviceNames.get(DeviceClass.CardReader);
            String rp = (String)ApplicationView.this.devicePorts.get(DeviceClass.CardReader);
            PortType rpt = PortScanner.suggestType((String)rp);
            if (dd != null && rp != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.cardreader.add"));
                if (rpt == PortType.SerialPort) {
                    sp = ApplicationView.this.getSerialPort(DeviceClass.CardReader);
                    c.setCardReaderConfiguration(new CardReaderConfiguration(dd.getType(), (Port)sp));
                } else {
                    c.setCardReaderConfiguration(new CardReaderConfiguration(dd.getType(), (Port)new UsbPort(rp)));
                }
            } else {
                c.setCardReaderConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.cardreader.skip"));
            }
            ApplicationView.this.log.info((Object)B.get("main.save.pinpad"));
            dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.Pinpad);
            sp = ApplicationView.this.getSerialPort(DeviceClass.Pinpad);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.pinpad.add"));
                c.setPinpadConfiguration(new DeviceConfiguration(dt, (Port)sp));
            } else {
                c.setPinpadConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.pinpad.skip"));
            }
            ApplicationView.this.log.info((Object)B.get("main.save.proximity"));
            if (ApplicationView.this.proximityPanel.getTypesComboBox().getSelectedItem() != null) {
                item = (ComboBoxItem)ApplicationView.this.proximityPanel.getTypesComboBox().getSelectedItem();
                DeviceType proximityType = (DeviceType)item.getObject();
                ApplicationView.this.log.info((Object)(B.get("main.save.proximity.type") + proximityType));
                c.setProximityType(proximityType);
                if (proximityType == DeviceType.RosanProximityReader) {
                    c.setMppkPath(ApplicationView.this.proximityPanel.getMppkPathTextField().getText().trim());
                } else {
                    dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.ProximityReader);
                    sp = ApplicationView.this.getSerialPort(DeviceClass.ProximityReader);
                    if (sp != null && dt != null) {
                        c.setReaderConfiguration(new DeviceConfiguration(dt, (Port)sp));
                    } else {
                        c.setReaderConfiguration(null);
                    }
                }
            } else {
                ApplicationView.this.log.error((Object)B.get("main.save.proximity.skip"));
            }
            c.setBarcodeScannerType(null);
            c.setBarcodeScannerConfiguration(null);
            if (ApplicationView.this.barcodePanel.getTypeComboBox().getSelectedIndex() != 0) {
                cbi = (ComboBoxItem)ApplicationView.this.barcodePanel.getTypeComboBox().getSelectedItem();
                BarcodeScannerType bst = (BarcodeScannerType)cbi.getObject();
                c.setBarcodeScannerType(bst);
                if (bst == BarcodeScannerType.Serial) {
                    dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.BarcodeScanner);
                    sp = ApplicationView.this.getSerialPort(DeviceClass.BarcodeScanner);
                    c.setBarcodeScannerConfiguration(new DeviceConfiguration(dt, (Port)sp));
                }
            }
            ApplicationView.this.log.info((Object)B.get("main.save.printer"));
            c.setPrinterClass(null);
            c.setPosPrinterConfiguration(null);
            c.setFiscalPrinterConfiguration(null);
            if (ApplicationView.this.printerPanel.getTypeComboBox().getSelectedItem() != null) {
                item = (ComboBoxItem)ApplicationView.this.printerPanel.getTypeComboBox().getSelectedItem();
                DeviceClass printerClass = (DeviceClass)item.getObject();
                ApplicationView.this.log.info((Object)(B.get("main.save.printer.class") + printerClass));
                c.setPrinterClass(printerClass);
                c.setUsePaperNearEndSensor(ApplicationView.this.printerPanel.getUsePaperNearEndSensor().isSelected());
                if (printerClass == DeviceClass.PosPrinter) {
                    dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.PosPrinter);
                    ApplicationView.this.log.info((Object)(B.get("main.save.printer.type") + dt));
                    String port = (String)ApplicationView.this.devicePorts.get(DeviceClass.PosPrinter);
                    ApplicationView.this.log.info((Object)(B.get("main.save.printer.port") + dt));
                    PortType pt = PortScanner.suggestType((String)port);
                    ApplicationView.this.log.info((Object)(B.get("main.save.printer.port.type") + pt));
                    boolean exist = false;
                    if (pt == PortType.SerialPort) {
                        sp = ApplicationView.this.getSerialPort(DeviceClass.PosPrinter);
                        ApplicationView.this.log.info((Object)(B.get("main.save.printer.port.param") + sp));
                        if (dt != null && sp != null) {
                            c.setPosPrinterConfiguration(new DeviceConfiguration(dt, (Port)sp));
                            exist = true;
                        } else {
                            ApplicationView.this.log.error((Object)B.get("main.save.printer.pos.skip"));
                        }
                    } else if (pt == PortType.ParallelPort) {
                        if (dt != null && port != null) {
                            c.setPosPrinterConfiguration(new DeviceConfiguration(dt, (Port)new ParallelPort(port)));
                            exist = true;
                        } else {
                            ApplicationView.this.log.error((Object)B.get("main.save.printer.pos.skip"));
                        }
                    } else if (pt == PortType.UsbPort) {
                        if (dt != null && port != null) {
                            c.setPosPrinterConfiguration(new DeviceConfiguration(dt, (Port)new UsbPort(port)));
                            exist = true;
                        } else {
                            ApplicationView.this.log.error((Object)B.get("main.save.printer.pos.skip"));
                        }
                    }
                    PosPrinterOptions ppo = Helper.extractPosPrinterOptions(ApplicationView.this.ppp);
                    ApplicationView.this.log.info((Object)(B.get("main.save.printer.pos.options") + ppo));
                    c.setPosPrinterOptions(ppo);
                    ComboBoxItem cbi2 = (ComboBoxItem)ApplicationView.this.ppp.getHandlerComboBox().getSelectedItem();
                    c.setPrintHandler((String)cbi2.getObject());
                } else if (printerClass == DeviceClass.FiscalPrinter) {
                    dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.FiscalPrinter);
                    sp = ApplicationView.this.getSerialPort(DeviceClass.FiscalPrinter);
                    if (sp != null && dt != null) {
                        ApplicationView.this.log.info((Object)B.get("main.save.printer.kkm.add"));
                        c.setFiscalPrinterConfiguration(new DeviceConfiguration(dt, (Port)sp));
                        c.setFiscalPrinterMode(ApplicationView.this.fpp.getPrinterModeCheckBox().isSelected());
                    } else {
                        ApplicationView.this.log.error((Object)B.get("main.save.printer.kkm.skip"));
                    }
                    KkmOptions opt = Helper.extractOption(ApplicationView.this.fpp);
                    ApplicationView.this.log.info((Object)(B.get("main.save.printer.kkm.options") + opt));
                    c.setKkmOptions(opt);
                } else if (printerClass == DeviceClass.IppPrinter) {
                    IppPrinterPanel ipp = ApplicationView.this.printerPanel.getIppPrinterPanel();
                    ComboBoxItem cbi3 = (ComboBoxItem)ipp.getPrintersComboBox().getSelectedItem();
                    String name = null;
                    if (cbi3 != null) {
                        name = (String)cbi3.getObject();
                    }
                    ApplicationView.this.log.info((Object)(B.get("main.save.printer.ipp.name") + name));
                    c.setIppPrinterName(name);
                    IppPrinterOptions opt = new IppPrinterOptions();
                    if (ipp.getFontSizeTextField().getText().matches("^\\d+$")) {
                        opt.setFontSize(Integer.parseInt(ipp.getFontSizeTextField().getText()));
                    } else {
                        opt.setFontSize(9);
                    }
                    if (ipp.getScrollTextField().getText().matches("^\\d+$")) {
                        opt.setScroll(Integer.parseInt(ipp.getScrollTextField().getText()));
                    } else {
                        opt.setScroll(0);
                    }
                    cbi3 = (ComboBoxItem)ipp.getFontsComboBox().getSelectedItem();
                    String fontFamily = null;
                    if (cbi3 != null) {
                        fontFamily = (String)cbi3.getObject();
                    }
                    opt.setFontFamily(fontFamily);
                    c.setIppPrinterOptions(opt);
                }
            } else {
                ApplicationView.this.log.error((Object)B.get("main.save.printer.skip"));
            }
            dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.WatchDog);
            sp = ApplicationView.this.getSerialPort(DeviceClass.WatchDog);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.watchdog.add"));
                c.setWatchDogConfiguration(new DeviceConfiguration(dt, (Port)sp));
                WatchDogSettings wds = new WatchDogSettings();
                if (!ApplicationView.this.watchDogPanel.getModemChannelTextField().getText().isEmpty()) {
                    wds.setModemChannel(Integer.valueOf(Integer.parseInt(ApplicationView.this.watchDogPanel.getModemChannelTextField().getText())));
                }
                if (!ApplicationView.this.watchDogPanel.getRebootPcTimeoutTextField().getText().isEmpty()) {
                    wds.setPcResetTimeout(Integer.valueOf(Integer.parseInt(ApplicationView.this.watchDogPanel.getRebootPcTimeoutTextField().getText())));
                }
                if (WatchDogFactory.createDescriptor((DeviceType)dt).isAllowRemap()) {
                    HashMap<Integer, EventListener.Event.Channel> tmp = new HashMap<Integer, EventListener.Event.Channel>();
                    for (Integer id : ApplicationView.this.watchDogSwitchMap.keySet()) {
                        tmp.put(id, (EventListener.Event.Channel)((ComboBoxItem)ApplicationView.this.watchDogSwitchMap.get(id)).getObject());
                    }
                    wds.setSwitchMap(tmp);
                    c.setWatchDogSettings(wds);
                }
            } else {
                c.setWatchDogConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.watchdog.skip"));
            }
            dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.Modem);
            sp = ApplicationView.this.getSerialPort(DeviceClass.Modem);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.modem.add"));
                c.setModemConfiguration(new DeviceConfiguration(dt, (Port)sp));
            } else {
                c.setModemConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.modem.skip"));
            }
            c.setPppUse(ApplicationView.this.networkPanel.getUseModemCheckBox().isSelected());
            cbi = (ComboBoxItem)ApplicationView.this.networkPanel.getConnectionsComboBox().getSelectedItem();
            c.setPppName((String)cbi.getObject());
            c.setUssdCheck(ApplicationView.this.modemPanel.getCheckBalanceCheckBox().isSelected());
            c.setSoftwareWatchDogUse(ApplicationView.this.modemPanel.getSetSoftwareWatchDogCheckBox().isSelected());
            c.setUssdAutoRequest(!ApplicationView.this.modemPanel.getConfigureUssdCheckBox().isSelected());
            c.setUssdRequest(ApplicationView.this.modemPanel.getUssdTextField().getText());
            c.setCardModuleType(null);
            if (ApplicationView.this.cardModulePanel.getTypeComboBox().getSelectedIndex() != 0) {
                cbi = (ComboBoxItem)ApplicationView.this.cardModulePanel.getTypeComboBox().getSelectedItem();
                String mt = (String)cbi.getObject();
                c.setCardModuleType(mt);
            }
            ApplicationView.this.log.info((Object)B.get("main.save.cvd"));
            dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.CardDispenser);
            sp = ApplicationView.this.getSerialPort(DeviceClass.CardDispenser);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.cvd.add"));
                c.setCvdConfiguration(new DeviceConfiguration(dt, (Port)sp));
            } else {
                c.setCvdConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.cvd.skip"));
            }
            ApplicationView.this.log.info((Object)B.get("main.save.cdm"));
            dt = (DeviceType)ApplicationView.this.deviceTypes.get(DeviceClass.CashDispenser);
            sp = ApplicationView.this.getSerialPort(DeviceClass.CashDispenser);
            if (sp != null && dt != null) {
                ApplicationView.this.log.info((Object)B.get("main.save.cdm.add"));
                c.setCdmConfiguration(new CdmConfiguration(sp, dt));
            } else {
                c.setCdmConfiguration(null);
                ApplicationView.this.log.error((Object)B.get("main.save.cdm.skip"));
            }
            c.setPresentConfiguration(null);
            if (ApplicationView.this.presentPanel.getTypeComboBox().getSelectedIndex() != 0) {
                cbi = (ComboBoxItem)ApplicationView.this.presentPanel.getTypeComboBox().getSelectedItem();
                String mn = (String)cbi.getObject();
                PresentConfiguration pc = new PresentConfiguration();
                pc.setType(mn);
                if ("NetworkModule".equals(mn)) {
                    NetworkPresentPanel npp = ApplicationView.this.presentPanel.getNetworkPresentPanel();
                    if (npp.getCostTextField().getText().length() > 0) {
                        pc.setOptions(new DispenserOptions(Integer.parseInt(npp.getCostTextField().getText())));
                    }
                    cbi = (ComboBoxItem)npp.getDriverComboBox().getSelectedItem();
                    String driver = (String)cbi.getObject();
                    DispenserNetworkOptions pnc = new DispenserNetworkOptions();
                    pc.setDriver(driver);
                    if (npp.getHostTextField().getText().length() > 0) {
                        pnc.setHost(npp.getHostTextField().getText());
                    }
                    if (npp.getPortTextField().getText().length() > 0) {
                        pnc.setPort(Integer.valueOf(Integer.parseInt(npp.getPortTextField().getText())));
                    }
                    pc.setNetworkOptions(pnc);
                }
                c.setPresentConfiguration(pc);
            }
            c.setOnTop(Boolean.valueOf(ApplicationView.this.otherPanel.getOnTopCheckBox().isSelected()));
            c.setShowCursor(Boolean.valueOf(ApplicationView.this.otherPanel.getShowCursorCheckBox().isSelected()));
            cbi = (ComboBoxItem)ApplicationView.this.otherPanel.getScreenSizeComboBox().getSelectedItem();
            c.setScreenSize((String)cbi.getObject());
            cbi = (ComboBoxItem)ApplicationView.this.otherPanel.getRenderingComboBox().getSelectedItem();
            c.setRendering((Rendering)cbi.getObject());
            try {
                c.updateConfiguration();
                ApplicationView.this.getDialog(B.get("main.save.complete"), true);
                ApplicationView.this.setModifyState(false);
            }
            catch (ConfigurationException ex) {
                ApplicationView.this.setModifyState(true);
                ApplicationView.this.getDialog(B.get("main.save.error"), true);
                ApplicationView.this.log.error((Object)ex, (Throwable)ex);
            }
            this.writeSerialNumbers();
        }

        private void writeSerialNumbers() {
            String validatorSN = ApplicationView.this.serialNumbersPanel.getValidatorSNTextField().getText();
            String printerSN = ApplicationView.this.serialNumbersPanel.getPrinterSNTextField().getText();
            String modemSN = ApplicationView.this.serialNumbersPanel.getModemSNTextField().getText();
            String firstMonSN = ApplicationView.this.serialNumbersPanel.getFirstMonitorSNTextField().getText();
            String secMonSN = ApplicationView.this.serialNumbersPanel.getSecondMonitorSNTextField().getText();
            String terminalSN = ApplicationView.this.serialNumbersPanel.getTerminalSNTextField().getText();
            EnumMap<SerialNumbersStore.Type, String> numbers = new EnumMap<SerialNumbersStore.Type, String>(SerialNumbersStore.Type.class);
            numbers.put(SerialNumbersStore.Type.VALIDATOR, validatorSN);
            numbers.put(SerialNumbersStore.Type.PRINTER, printerSN);
            numbers.put(SerialNumbersStore.Type.MODEM, modemSN);
            numbers.put(SerialNumbersStore.Type.FIRST_MONITOR, firstMonSN);
            numbers.put(SerialNumbersStore.Type.SECOND_MONITOR, secMonSN);
            numbers.put(SerialNumbersStore.Type.TERMINAL, terminalSN);
            ConfigurationSN.getInstance().getStore().setNumbers(numbers);
            try {
                ConfigurationSN.getInstance().writeStore();
            }
            catch (IOException ex) {
                ApplicationView.this.log.error((Object)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0441\u0435\u0440\u0438\u0439\u043d\u044b\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432", (Throwable)ex);
            }
        }
    }

    private class PortScannerListener
    implements ActionListener {
        private PortScannerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApplicationView.this.te.execute(new PortScannerTask());
        }
    }

    private class LoadConfTask
    extends Task {
        public LoadConfTask() {
            super(B.get("task.init.title"));
        }

        @Override
        public Object execute() {
            return null;
        }

        @Override
        public void onResult(Object object) {
            SerialNumbersStore store;
            CdmConfiguration cdm;
            DeviceConfiguration cvd;
            DeviceConfiguration mod;
            BarcodeScannerType bst;
            DeviceConfiguration pinpad;
            DeviceType dt;
            CardReaderConfiguration reader;
            DeviceConfiguration hopper;
            DeviceConfiguration coin;
            boolean guiModified = false;
            Configuration c = Configuration.getInstance();
            Queue queue = new Queue(c.getApplicationDir() + "/data/queue.obj", null);
            int count = (queue.getGroupOperations() == null ? 0 : queue.getGroupOperations().length) + (queue.getOperations() == null ? 0 : queue.getOperations().length);
            ApplicationView.this.sizeLabel.setText("" + count);
            ConnectorConfiguration cc = c.getDefaultConnectorConfiguration();
            if (cc != null) {
                ApplicationView.this.networkPanel.getPointIdTextField().setText((String)cc.getParams().get("point"));
                ApplicationView.this.networkPanel.getServerAddressTextField().setText((String)cc.getParams().get("server"));
                ApplicationView.this.networkPanel.getHttpPortTextField().setText((String)cc.getParams().get("http-port"));
                ApplicationView.this.networkPanel.getHttpsPortTextField().setText((String)cc.getParams().get("port"));
            }
            ApplicationView.this.networkPanel.getServerAddressTextField().setEnabled(cc != null);
            ApplicationView.this.networkPanel.getServerAddressButton().setEnabled(cc != null);
            ApplicationView.this.networkPanel.getHttpPortTextField().setEnabled(cc != null);
            ApplicationView.this.networkPanel.getHttpPortButton().setEnabled(cc != null);
            ApplicationView.this.networkPanel.getHttpsPortTextField().setEnabled(cc != null);
            ApplicationView.this.networkPanel.getHttpsPortButton().setEnabled(cc != null);
            ApplicationView.this.networkPanel.getUseModemCheckBox().setSelected(c.isPppUse());
            ApplicationView.this.networkPanel.getConnectionsComboBox().setSelectedItem(new ComboBoxItem(c.getPppName(), null));
            if (ApplicationView.this.networkPanel.getConnectionsComboBox().getSelectedItem() == null) {
                ApplicationView.this.networkPanel.getConnectionsComboBox().setSelectedIndex(0);
                guiModified = true;
            }
            ApplicationView.this.networkPanel.getUseProxyCheckBox().setSelected(c.isUseProxy());
            ApplicationView.this.networkPanel.getUseProxyAuthCheckBox().setSelected(c.isAuthProxy());
            ApplicationView.this.networkPanel.getProxyHostTextField().setText(c.getProxyHost());
            ApplicationView.this.networkPanel.getProxyPortTextField().setText(c.getProxyPort());
            ApplicationView.this.networkPanel.getProxyUserTextField().setText(c.getProxyUser());
            ApplicationView.this.networkPanel.getProxyPasswordTextField().setText(c.getProxyPassword());
            DeviceConfiguration val = c.getCashAcceptorConfiguration();
            if (val != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.CashAcceptor, val.getDeviceType());
                ApplicationView.this.devicePorts.put(DeviceClass.CashAcceptor, ((SerialPort)val.getPort()).getName());
                ApplicationView.this.ports.put(((SerialPort)val.getPort()).getName(), val.getPort());
            }
            if ((coin = c.getCoinAcceptorConfiguration()) != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.CoinAcceptor, coin.getDeviceType());
                ApplicationView.this.devicePorts.put(DeviceClass.CoinAcceptor, ((SerialPort)coin.getPort()).getName());
                ApplicationView.this.ports.put(((SerialPort)coin.getPort()).getName(), coin.getPort());
            }
            if ((hopper = c.getCoinHopperConfiguration()) != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.Hopper, hopper.getDeviceType());
                ApplicationView.this.devicePorts.put(DeviceClass.Hopper, ((SerialPort)hopper.getPort()).getName());
                ApplicationView.this.ports.put(((SerialPort)hopper.getPort()).getName(), hopper.getPort());
            }
            if ((reader = c.getCardReaderConfiguration()) != null && ApplicationView.this.deviceDescs.get(reader.getName()) != null) {
                ApplicationView.this.deviceNames.put(DeviceClass.CardReader, ApplicationView.this.deviceDescs.get(reader.getName()));
                ApplicationView.this.devicePorts.put(DeviceClass.CardReader, reader.getPort().getName());
                if (reader.getPort().getType() == PortType.SerialPort) {
                    ApplicationView.this.ports.put(reader.getPort().getName(), (SerialPort)reader.getPort());
                }
            }
            if ((dt = c.getProximityType()) != null) {
                if (dt == DeviceType.RosanProximityReader) {
                    String s = c.getMppkPath();
                    if (s != null && !"".equals(s)) {
                        ApplicationView.this.deviceTypes.put(DeviceClass.ProximityReader, dt);
                        ApplicationView.this.proximityPanel.getMppkPathTextField().setText(s);
                    }
                } else {
                    DeviceConfiguration prReader = c.getReaderConfiguration();
                    if (prReader != null) {
                        ApplicationView.this.deviceTypes.put(DeviceClass.ProximityReader, prReader.getDeviceType());
                        ApplicationView.this.devicePorts.put(DeviceClass.ProximityReader, ((SerialPort)prReader.getPort()).getName());
                        ApplicationView.this.ports.put(((SerialPort)prReader.getPort()).getName(), prReader.getPort());
                    }
                }
            }
            if ((pinpad = c.getPinpadConfiguration()) != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.Pinpad, pinpad.getDeviceType());
                ApplicationView.this.devicePorts.put(DeviceClass.Pinpad, ((SerialPort)pinpad.getPort()).getName());
                ApplicationView.this.ports.put(((SerialPort)pinpad.getPort()).getName(), pinpad.getPort());
            }
            if ((bst = c.getBarcodeScannerType()) != null) {
                DeviceConfiguration sc;
                ApplicationView.this.barcodePanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(bst, null));
                if (bst == BarcodeScannerType.Serial && (sc = c.getBarcodeScannerConfiguration()) != null) {
                    ApplicationView.this.deviceTypes.put(DeviceClass.BarcodeScanner, sc.getDeviceType());
                    ApplicationView.this.devicePorts.put(DeviceClass.BarcodeScanner, ((SerialPort)sc.getPort()).getName());
                    ApplicationView.this.ports.put(((SerialPort)sc.getPort()).getName(), sc.getPort());
                }
            }
            ApplicationView.this.printerPanel.getUsePaperNearEndSensor().setSelected(c.isUsePaperNearEndSensor());
            DeviceClass pc = c.getPrinterClass();
            if (pc != null) {
                ApplicationView.this.printerPanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(pc, null));
                if (pc == DeviceClass.FiscalPrinter) {
                    DeviceConfiguration fis = c.getFiscalPrinterConfiguration();
                    if (fis != null) {
                        ApplicationView.this.deviceTypes.put(DeviceClass.FiscalPrinter, fis.getDeviceType());
                        ApplicationView.this.devicePorts.put(DeviceClass.FiscalPrinter, ((SerialPort)fis.getPort()).getName());
                        ApplicationView.this.ports.put(((SerialPort)fis.getPort()).getName(), fis.getPort());
                    }
                    ApplicationView.this.fpp.getPrinterModeCheckBox().setSelected(c.isFiscalPrinterMode());
                    if (c.getKkmOptions() != null) {
                        KkmOptions ko = c.getKkmOptions();
                        ApplicationView.this.fpp.getPresenterComboBox().setSelectedItem(new ComboBoxItem(ko.getPresenterMode(), null));
                        if (ApplicationView.this.fpp.getPresenterComboBox().getSelectedItem() == null) {
                            ApplicationView.this.fpp.getPresenterComboBox().setSelectedIndex(0);
                        }
                        if (ko.getScroll() != null) {
                            ApplicationView.this.fpp.getScrollTextField().setText(ko.getScroll().toString());
                        }
                        if (ko.getWidth() != null) {
                            ApplicationView.this.fpp.getPrintWidthTextField().setText(ko.getWidth().toString());
                        }
                        if (ko.getAdminPassword() != null) {
                            ApplicationView.this.fpp.getAdminPasswordTextField().setText(ko.getAdminPassword());
                        }
                        if (ko.getOperatorPassword() != null) {
                            ApplicationView.this.fpp.getOperPasswordTextField().setText(ko.getOperatorPassword());
                        }
                    }
                } else if (pc == DeviceClass.PosPrinter) {
                    DeviceConfiguration pos = c.getPosPrinterConfiguration();
                    if (pos != null) {
                        ApplicationView.this.deviceTypes.put(DeviceClass.PosPrinter, pos.getDeviceType());
                        ApplicationView.this.devicePorts.put(DeviceClass.PosPrinter, pos.getPort().getName());
                        if (pos.getPort() instanceof SerialPort) {
                            ApplicationView.this.ports.put(pos.getPort().getName(), (SerialPort)pos.getPort());
                        }
                    }
                    ApplicationView.this.ppp.getHandlerComboBox().setSelectedItem(new ComboBoxItem(c.getPrintHandler(), null));
                    if (ApplicationView.this.ppp.getHandlerComboBox().getSelectedItem() == null) {
                        ApplicationView.this.ppp.getHandlerComboBox().setSelectedIndex(0);
                    }
                } else if (pc == DeviceClass.IppPrinter) {
                    ApplicationView.this.ipp = ApplicationView.this.printerPanel.getIppPrinterPanel();
                    ApplicationView.this.ipp.getPrintersComboBox().setSelectedItem(new ComboBoxItem(c.getIppPrinterName(), null));
                    if (ApplicationView.this.ipp.getPrintersComboBox().getSelectedItem() == null) {
                        guiModified = true;
                        ApplicationView.this.ipp.getPrintersComboBox().setSelectedIndex(0);
                    }
                    if (c.getIppPrinterOptions() != null) {
                        ApplicationView.this.ipp.getFontSizeTextField().setText(Integer.toString(c.getIppPrinterOptions().getFontSize()));
                        ApplicationView.this.ipp.getScrollTextField().setText(Integer.toString(c.getIppPrinterOptions().getScroll()));
                        ApplicationView.this.ipp.getFontsComboBox().setSelectedItem(new ComboBoxItem(c.getIppPrinterOptions().getFontFamily(), null));
                    }
                }
            }
            if (c.getPosPrinterOptions() != null) {
                ApplicationView.this.ppp.getScrollTextField().setText(Integer.toString(c.getPosPrinterOptions().getScroll()));
                ApplicationView.this.ppp.getLeftMarginField().setText(Integer.toString(c.getPosPrinterOptions().getLeftMargin()));
                ApplicationView.this.ppp.getPrintWidthTextField().setText(Integer.toString(c.getPosPrinterOptions().getWidth()));
                ApplicationView.this.ppp.getLineSpanComboBox().setSelectedItem(new ComboBoxItem(c.getPosPrinterOptions().getSpan(), null));
                ApplicationView.this.ppp.getFontSizeComboBox().setSelectedItem(new ComboBoxItem(c.getPosPrinterOptions().getFontSize(), null));
                if (ApplicationView.this.ppp.getFontSizeComboBox().getSelectedItem() == null) {
                    guiModified = true;
                    ApplicationView.this.ppp.getFontSizeComboBox().setSelectedIndex(0);
                }
                ApplicationView.this.ppp.getEncodingComboBox().setSelectedItem(new ComboBoxItem(c.getPosPrinterOptions().getEncoding(), null));
                if (ApplicationView.this.ppp.getEncodingComboBox().getSelectedItem() == null) {
                    guiModified = true;
                    ApplicationView.this.ppp.getEncodingComboBox().setSelectedIndex(0);
                }
                if (c.getPosPrinterOptions().getDispense() != null) {
                    ApplicationView.this.ppp.getDispenseTextField().setText(Integer.toString(c.getPosPrinterOptions().getDispense()));
                }
            } else {
                ApplicationView.this.ppp.getPrintWidthTextField().setText(Integer.toString(AppDefaults.getInstance().getPosPrinterPrintWidth()));
                ApplicationView.this.ppp.getLeftMarginField().setText(Integer.toString(AppDefaults.getInstance().getPosPrinterLeftMargin()));
                ApplicationView.this.ppp.getScrollTextField().setText(Integer.toString(AppDefaults.getInstance().getPosPrinterScroll()));
            }
            if ((mod = c.getModemConfiguration()) != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.Modem, mod.getDeviceType());
                ApplicationView.this.devicePorts.put(DeviceClass.Modem, ((SerialPort)mod.getPort()).getName());
                ApplicationView.this.ports.put(((SerialPort)mod.getPort()).getName(), mod.getPort());
            }
            ApplicationView.this.modemPanel.getCheckBalanceCheckBox().setSelected(c.isUssdCheck());
            ApplicationView.this.modemPanel.getSetSoftwareWatchDogCheckBox().setSelected(c.isSoftwareWatchDogUse());
            ApplicationView.this.modemPanel.getConfigureUssdCheckBox().setSelected(c.getUssdRequest() != null);
            ApplicationView.this.modemPanel.getUssdTextField().setText(c.getUssdRequest());
            ApplicationView.this.modemPanel.getConfigureUssdCheckBox().setSelected(!c.isUssdAutoRequest());
            DeviceConfiguration wtd = c.getWatchDogConfiguration();
            if (wtd != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.WatchDog, wtd.getDeviceType());
                ApplicationView.this.devicePorts.put(DeviceClass.WatchDog, ((SerialPort)wtd.getPort()).getName());
                ApplicationView.this.ports.put(((SerialPort)wtd.getPort()).getName(), wtd.getPort());
                WatchDogSettings wds = c.getWatchDogSettings();
                if (wds != null && wds.getModemChannel() != null) {
                    ApplicationView.this.watchDogPanel.getModemChannelTextField().setText(Integer.toString(wds.getModemChannel()));
                }
                if (wds != null && wds.getPcResetTimeout() != null) {
                    ApplicationView.this.watchDogPanel.getRebootPcTimeoutTextField().setText(Integer.toString(wds.getPcResetTimeout()));
                }
                if (wds != null) {
                    for (Integer id : wds.getSwitchMap().keySet()) {
                        EventListener.Event.Channel chan = (EventListener.Event.Channel)wds.getSwitchMap().get(id);
                        if (chan != null) {
                            ApplicationView.this.watchDogSwitchMap.put(id, new ComboBoxItem(wds.getSwitchMap().get(id), NameExtractor.getComboBoxTitle(chan.toString())));
                            continue;
                        }
                        ApplicationView.this.watchDogSwitchMap.put(id, new ComboBoxItem(wds.getSwitchMap().get(id), NameExtractor.getComboBoxTitle(NameExtractor.getDeviceName(null))));
                    }
                }
            }
            if (c.getCardModuleType() != null) {
                ApplicationView.this.cardModulePanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(c.getCardModuleType(), null));
                if (ApplicationView.this.cardModulePanel.getTypeComboBox().getSelectedItem() == null) {
                    ApplicationView.this.cardModulePanel.getTypeComboBox().setSelectedIndex(0);
                }
            }
            if ((cvd = c.getCvdConfiguration()) != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.CardDispenser, cvd.getDeviceType());
                ApplicationView.this.devicePorts.put(DeviceClass.CardDispenser, ((SerialPort)cvd.getPort()).getName());
                ApplicationView.this.ports.put(((SerialPort)cvd.getPort()).getName(), cvd.getPort());
            }
            if ((cdm = c.getCdmConfiguration()) != null) {
                ApplicationView.this.deviceTypes.put(DeviceClass.CashDispenser, cdm.getType());
                ApplicationView.this.devicePorts.put(DeviceClass.CashDispenser, cdm.getPort().getName());
                ApplicationView.this.ports.put(cdm.getPort().getName(), cdm.getPort());
            }
            if (c.getPresentConfiguration() != null) {
                DispenserNetworkOptions pnc;
                PresentConfiguration prc = c.getPresentConfiguration();
                ApplicationView.this.presentPanel.getTypeComboBox().setSelectedItem(new ComboBoxItem(prc.getType(), null));
                if (ApplicationView.this.presentPanel.getTypeComboBox().getSelectedItem() == null) {
                    ApplicationView.this.presentPanel.getTypeComboBox().setSelectedIndex(0);
                }
                if ("NetworkModule".equals(prc.getType()) && (pnc = c.getPresentConfiguration().getNetworkOptions()) != null) {
                    NetworkPresentPanel npp = ApplicationView.this.presentPanel.getNetworkPresentPanel();
                    if (prc.getOptions() != null) {
                        npp.getCostTextField().setText(Integer.toString(prc.getOptions().getCost()));
                    }
                    npp.getDriverComboBox().setSelectedItem(new ComboBoxItem(c.getPresentConfiguration().getDriver(), null));
                    if (npp.getDriverComboBox().getSelectedItem() == null) {
                        npp.getDriverComboBox().setSelectedIndex(0);
                    }
                    npp.getHostTextField().setText(pnc.getHost());
                    npp.getPortTextField().setText("" + pnc.getPort());
                }
            }
            if ((store = ConfigurationSN.getInstance().getStore()) != null) {
                String serial = store.getSerial(SerialNumbersStore.Type.VALIDATOR);
                if (serial != null) {
                    ApplicationView.this.serialNumbersPanel.getValidatorSNTextField().setText(serial);
                }
                if ((serial = store.getSerial(SerialNumbersStore.Type.PRINTER)) != null) {
                    ApplicationView.this.serialNumbersPanel.getPrinterSNTextField().setText(serial);
                }
                if ((serial = store.getSerial(SerialNumbersStore.Type.MODEM)) != null) {
                    ApplicationView.this.serialNumbersPanel.getModemSNTextField().setText(serial);
                }
                if ((serial = store.getSerial(SerialNumbersStore.Type.FIRST_MONITOR)) != null) {
                    ApplicationView.this.serialNumbersPanel.getFirstMonitorSNTextField().setText(serial);
                }
                if ((serial = store.getSerial(SerialNumbersStore.Type.SECOND_MONITOR)) != null) {
                    ApplicationView.this.serialNumbersPanel.getSecondMonitorSNTextField().setText(serial);
                }
                if ((serial = store.getSerial(SerialNumbersStore.Type.TERMINAL)) != null) {
                    ApplicationView.this.serialNumbersPanel.getTerminalSNTextField().setText(serial);
                }
            }
            if (c.getOnTop() == null || c.getOnTop().booleanValue()) {
                ApplicationView.this.otherPanel.getOnTopCheckBox().setSelected(true);
            }
            if (c.getShowCursor() != null && c.getShowCursor().booleanValue()) {
                ApplicationView.this.otherPanel.getShowCursorCheckBox().setSelected(true);
            }
            if (c.getRendering() == null || c.getRendering() == Rendering.Quality) {
                ApplicationView.this.otherPanel.getRenderingComboBox().setSelectedItem(new ComboBoxItem(Rendering.Quality, null));
            } else {
                ApplicationView.this.otherPanel.getRenderingComboBox().setSelectedItem(new ComboBoxItem(Rendering.Performance, null));
            }
            ApplicationView.this.otherPanel.getScreenSizeComboBox().setSelectedItem(new ComboBoxItem(c.getScreenSize(), null));
            if (ApplicationView.this.otherPanel.getScreenSizeComboBox().getSelectedItem() == null) {
                ApplicationView.this.otherPanel.getScreenSizeComboBox().setSelectedIndex(0);
            }
            ApplicationView.this.updateGui();
            ApplicationView.this.setModifyState(guiModified);
        }
    }

    private class PortScannerTask
    extends Task {
        public PortScannerTask() {
            super(B.get("task.ports.title"));
        }

        @Override
        public Object execute() {
            try {
                ApplicationView.access$402(ApplicationView.this, PortScanner.scanSerial());
                ApplicationView.access$502(ApplicationView.this, PortScanner.scanParallel());
                ApplicationView.access$602(ApplicationView.this, PortScanner.scanUsb());
            }
            catch (Throwable ex) {
                ApplicationView.this.log.error((Object)"Error on scan ports", ex);
            }
            return null;
        }

        @Override
        public void onResult(Object object) {
            LinkedList<ComboBoxItem> serialModel = new LinkedList<ComboBoxItem>();
            serialModel.add(new ComboBoxItem(null, NameExtractor.getUndefinedName()));
            LinkedList<ComboBoxItem> allModel = new LinkedList<ComboBoxItem>();
            allModel.add(new ComboBoxItem(null, NameExtractor.getUndefinedName()));
            if (ApplicationView.this.serialPorts != null) {
                for (String serialPort : ApplicationView.this.serialPorts) {
                    serialModel.add(new ComboBoxItem(serialPort, NameExtractor.getComboBoxTitle(serialPort)));
                    allModel.add(new ComboBoxItem(serialPort, NameExtractor.getComboBoxTitle(serialPort)));
                }
            }
            if (ApplicationView.this.parallelPorts != null) {
                for (String parallelPort : ApplicationView.this.parallelPorts) {
                    allModel.add(new ComboBoxItem(parallelPort, NameExtractor.getComboBoxTitle(parallelPort)));
                }
            }
            if (ApplicationView.this.usbPorts != null) {
                for (String usbPort : ApplicationView.this.usbPorts) {
                    allModel.add(new ComboBoxItem(usbPort, NameExtractor.getComboBoxTitle(usbPort)));
                }
            }
            ComboBoxItem[] model2 = serialModel.toArray(new ComboBoxItem[serialModel.size()]);
            ComboBoxItem[] model3 = allModel.toArray(new ComboBoxItem[allModel.size()]);
            ApplicationView.this.validatorPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.coinPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.coinHopperPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.readerPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.pinpadPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.modemPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.watchDogPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.barcodePanel.getSerialBarcodePanel().getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.proximityPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.cvdPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.cdmPanel.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.fpp.getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model2));
            ApplicationView.this.printerPanel.getPosPrinterPanel().getPortsComboBox().setModel(new DefaultComboBoxModel<ComboBoxItem>(model3));
        }
    }
}

